/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.ui.Canvas;
import de.enough.polish.ui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DeviceInfo {
    public static final int VENDOR_UNKNOWN = -1;
    public static final int VENDOR_NOKIA = 1;
    public static final int VENDOR_SAMSUNG = 2;
    public static final int VENDOR_LG = 3;
    public static final int VENDOR_SONY_ERICSSON = 4;
    public static final int VENDOR_MOTOROLA = 5;
    public static final int VENDOR_ZTE = 6;
    public static final int VENDOR_ACER = 7;
    public static final int VENDOR_ALCATEL = 8;
    public static final int VENDOR_BLACKBERRY = 9;
    public static final int VENDOR_SAGEM = 10;
    private static boolean requiresFullRgbArrayForDrawRgb;
    private static boolean requiresFullRgbArrayForDrawRgbResolved;
    private static final int VENDOR_UNRESOLVED = -2;
    private static int resolvedVendor;

    private DeviceInfo() {
    }

    public static int getVendor() {
        if (resolvedVendor == -2) {
            resolvedVendor = DeviceInfo.resolveVendor();
        }
        return resolvedVendor;
    }

    private static int resolveVendor() {
        String model;
        String platform = System.getProperty("microedition.platform");
        platform = platform == null ? "" : platform.toLowerCase();
        if ("j2me".equals(platform) && (model = System.getProperty("device.model")) != null) {
            return 5;
        }
        if (platform.startsWith("nokia")) {
            return 1;
        }
        if (platform.startsWith("sonyericsson")) {
            return 4;
        }
        if (platform.startsWith("samsung")) {
            return 2;
        }
        if (platform.startsWith("lg")) {
            return 3;
        }
        if (platform.startsWith("zte")) {
            return 6;
        }
        if (platform.startsWith("blackberry") || platform.startsWith("rim")) {
            return 9;
        }
        model = System.getProperty("device.model");
        if (model != null) {
            return 2;
        }
        return -1;
    }

    public static String getVendorName() {
        int vendor = DeviceInfo.getVendor();
        switch (vendor) {
            case -1: {
                return null;
            }
            case 1: {
                return "Nokia";
            }
            case 2: {
                return "Samsung";
            }
            case 3: {
                return "LG";
            }
            case 4: {
                return "Sony Ericsson";
            }
            case 5: {
                return "Motorola";
            }
            case 6: {
                return "ZTE";
            }
            case 7: {
                return "Acter";
            }
            case 8: {
                return "Alcatel";
            }
            case 9: {
                return "BlackBerry";
            }
            case 10: {
                return "Sagem";
            }
        }
        return null;
    }

    public static String getDeviceName() {
        String vendor;
        String platform = System.getProperty("microedition.platform");
        if (platform == null || "j2me".equals(platform)) {
            platform = System.getProperty("device.model");
        }
        if (platform != null && (vendor = DeviceInfo.getVendorName()) != null) {
            int index = platform.toLowerCase().indexOf(vendor.toLowerCase());
            if (index != -1) {
                platform = platform.substring(index + vendor.length()).trim();
            }
            if ((index = platform.indexOf(32)) != -1) {
                platform = platform.substring(0, index);
            }
            if ((index = platform.indexOf(45)) != -1) {
                platform = platform.substring(0, index);
            }
            if ((index = platform.indexOf(47)) != -1) {
                platform = platform.substring(0, index);
            }
            return platform;
        }
        return null;
    }

    public static int getKeyInputModeSwitch() {
        int key = 35;
        int vendor = DeviceInfo.getVendor();
        if (vendor == 4 || vendor == 2) {
            key = 42;
        }
        return key;
    }

    public static int getKeySpace() {
        int key = 48;
        int vendor = DeviceInfo.getVendor();
        if (vendor == 4 || vendor == 2) {
            key = 35;
        }
        return key;
    }

    public static boolean requiresFullRgbArrayForDrawRgb() {
        if (!requiresFullRgbArrayForDrawRgbResolved) {
            int[] rgb = new int[10];
            for (int i = 0; i < rgb.length; ++i) {
                rgb[i] = -1728053248;
            }
            try {
                Image image = Image.createImage(10, 10);
                Graphics g = image.getGraphics();
                g.drawRGB(rgb, 0, 0, 0, 0, 10, 10, true);
                image.getRGB(rgb, 0, 10, 0, 7, 10, 1);
                int pixel = rgb[4];
                if (pixel == -1) {
                    requiresFullRgbArrayForDrawRgb = true;
                }
            }
            catch (Exception e) {
                requiresFullRgbArrayForDrawRgb = true;
            }
            requiresFullRgbArrayForDrawRgbResolved = true;
        }
        return requiresFullRgbArrayForDrawRgb;
    }

    public static boolean hasPointerEvents() {
        Display disp = Display.getInstance();
        if (disp != null) {
            return disp.hasPointerEvents();
        }
        Canvas canvas = new Canvas(){

            public void paint(Graphics g) {
            }
        };
        return canvas.hasPointerEvents();
    }

    public static String getDeviceId() {
        String[] properties = new String[]{"phone.imei", "phone.imei", "com.sonyericsson.imei", "IMEI", "com.motorola.IMEI", "com.samsung.imei", "com.lge.imei", "IMEI"};
        String id = null;
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i];
            try {
                id = System.getProperty(name);
                if (id == null) continue;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (id != null) {
            return id;
        }
        return null;
    }

    static {
        resolvedVendor = -2;
    }
}

