/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.BitMapFont;
import de.enough.polish.util.WrappedText;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BitMapFontViewer {
    public static final int ABSOLUTE_LINE_BREAK = -2;
    public static final int ARTIFICAL_LINE_BREAK = -3;
    public static final int COLORIZE_MASK = -16777216;
    private Image image;
    private short[] xPositions;
    private byte[] usedCharactersWidths;
    private final int fontHeight;
    private int verticalPadding;
    private final int spaceIndex;
    private int height;
    private int width;
    private int numberOfLines;
    private short[] lineWidths;
    private int[] indeces;
    private final byte[] actualCharacterWidths;
    private int orientation;
    private BitMapFontViewer maxLineAppendixViewer;
    private int color;

    public BitMapFontViewer(Image image, int[] indeces, short[] xPositions, byte[] characterWidths, int fontHeight, int spaceIndex, int verticalPadding) {
        this.image = image;
        this.indeces = indeces;
        this.actualCharacterWidths = characterWidths;
        this.spaceIndex = spaceIndex;
        this.lineWidths = new short[20];
        this.verticalPadding = verticalPadding;
        this.xPositions = new short[indeces.length];
        this.usedCharactersWidths = new byte[indeces.length];
        int currentLineWidth = 0;
        int maxLineWidth = 0;
        int linesIndex = 0;
        for (int i = 0; i < indeces.length; ++i) {
            byte characterWidth;
            int index = indeces[i];
            if (index == -1) continue;
            if (index == -2) {
                if (currentLineWidth > maxLineWidth) {
                    maxLineWidth = currentLineWidth;
                }
                this.lineWidths[linesIndex] = currentLineWidth;
                currentLineWidth = 0;
                this.usedCharactersWidths[i] = -2;
                if ((linesIndex = (int)((short)(linesIndex + 1))) < this.lineWidths.length) continue;
                this.lineWidths = this.increaseShortArraySize(this.lineWidths, 10);
                continue;
            }
            this.xPositions[i] = xPositions[index];
            this.usedCharactersWidths[i] = characterWidth = characterWidths[index];
            currentLineWidth = (short)(currentLineWidth + characterWidth);
        }
        this.lineWidths[linesIndex] = currentLineWidth;
        if (currentLineWidth > maxLineWidth) {
            maxLineWidth = currentLineWidth;
        }
        this.numberOfLines = linesIndex + 1;
        this.height = this.numberOfLines * (fontHeight + verticalPadding) - verticalPadding;
        this.width = maxLineWidth;
        this.fontHeight = fontHeight;
    }

    public BitMapFontViewer(Image image, int color2, int[] indeces, short[] xPositions, byte[] characterWidths, int fontHeight, int spaceIndex, int verticalPadding) {
        this(image, indeces, xPositions, characterWidths, fontHeight, spaceIndex, verticalPadding);
        if (color2 != -1 && color2 != 0) {
            this.image = this.applyColor(image, -16777216, color2);
        }
        this.color = color2;
    }

    protected Image applyColor(Image img, int mask, int color2) {
        int h = img.getHeight();
        int w = img.getWidth();
        int[] rgb = new int[h * w];
        img.getRGB(rgb, 0, w, 0, 0, w, h);
        for (int i = 0; i < rgb.length; ++i) {
            int pixel = rgb[i];
            rgb[i] = pixel & 0xFF000000 | color2 & 0xFFFFFF;
        }
        return Image.createRGBImage(rgb, w, h, true);
    }

    protected boolean isValidPixel(int argb, int mask) {
        return (argb & 0xFFFFFF) == (mask & 0xFFFFFF);
    }

    protected int colorizePixel(int argb, int color2) {
        return argb & 0xFF000000 | color2 & 0xFFFFFF;
    }

    public void paint(int x, int y, Graphics g) {
        boolean isLayoutCenter;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int clipXEnd = clipX + clipWidth;
        int startX = x;
        boolean isLayoutRight = this.orientation == 8;
        boolean bl = isLayoutCenter = this.orientation == 1;
        if (isLayoutCenter) {
            x = startX - this.lineWidths[0] / 2;
        } else if (isLayoutRight) {
            x = startX - this.lineWidths[0];
        }
        int lineIndex = 0;
        for (int i = 0; i < this.xPositions.length; ++i) {
            byte characterWidth = this.usedCharactersWidths[i];
            if (characterWidth == 0) continue;
            if (characterWidth < 0) {
                if (++lineIndex == this.numberOfLines) {
                    if (this.maxLineAppendixViewer == null) break;
                    this.maxLineAppendixViewer.paint(x, y, g);
                    break;
                }
                x = isLayoutCenter ? startX - this.lineWidths[lineIndex] / 2 : (isLayoutRight ? startX - this.lineWidths[lineIndex] : startX);
                y += this.fontHeight + this.verticalPadding;
                continue;
            }
            if (x >= clipXEnd) continue;
            g.clipRect(x, y, characterWidth, this.fontHeight);
            int imageX = x - this.xPositions[i];
            g.drawImage(this.image, imageX, y, 20);
            x += characterWidth;
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void layout(int firstLineWidth, int lineWidth, int paddingVertical, int orientationSetting) {
        this.layout(firstLineWidth, lineWidth, paddingVertical, orientationSetting, -1, null, null);
    }

    public void layout(int firstLineWidth, int lineWidth, int paddingVertical, int orientationSetting, int maxLines, String maxLinesAppendix, BitMapFont maxLinesAppendixFont) {
        this.orientation = orientationSetting;
        this.verticalPadding = paddingVertical;
        int lineIndex = 0;
        int currentLineWidth = 0;
        int maxLineWidth = 0;
        int lastSpaceIndex = -1;
        int lastSpaceWidth = 0;
        int lineStartIndex = 0;
        boolean maxLinesReached = false;
        --maxLines;
        int i = 0;
        byte[] charWidths = this.usedCharactersWidths;
        for (i = 0; i < charWidths.length; ++i) {
            byte characterWidth = charWidths[i];
            if (characterWidth == -3) {
                charWidths[i] = characterWidth = this.actualCharacterWidths[this.indeces[i]];
            } else if (characterWidth == -2) {
                this.lineWidths[lineIndex] = currentLineWidth;
                if (currentLineWidth > maxLineWidth) {
                    maxLineWidth = currentLineWidth;
                }
                if (lineIndex == maxLines) {
                    maxLinesReached = true;
                    break;
                }
                lineStartIndex = i + 1;
                if (++lineIndex >= this.lineWidths.length) {
                    this.lineWidths = this.increaseShortArraySize(this.lineWidths, 10);
                }
                currentLineWidth = 0;
                continue;
            }
            int index = this.indeces[i];
            if (index == this.spaceIndex) {
                lastSpaceIndex = i;
                lastSpaceWidth = currentLineWidth;
            }
            if ((currentLineWidth = (int)((short)(currentLineWidth + characterWidth))) > firstLineWidth) {
                if (lastSpaceIndex > lineStartIndex) {
                    charWidths[lastSpaceIndex] = -3;
                    lineStartIndex = lastSpaceIndex + 1;
                    this.lineWidths[lineIndex] = (short)lastSpaceWidth;
                    if (lastSpaceWidth > maxLineWidth) {
                        maxLineWidth = (short)lastSpaceWidth;
                    }
                    if (lineIndex == maxLines) {
                        maxLinesReached = true;
                        break;
                    }
                    currentLineWidth = (short)(currentLineWidth - (short)(lastSpaceWidth + this.actualCharacterWidths[this.spaceIndex]));
                    if (++lineIndex >= this.lineWidths.length) {
                        this.lineWidths = this.increaseShortArraySize(this.lineWidths, 10);
                    }
                } else {
                    byte[] widths = new byte[charWidths.length + 1];
                    System.arraycopy(charWidths, 0, widths, 0, i);
                    widths[i] = -3;
                    System.arraycopy(charWidths, i, widths, i + 1, charWidths.length - i);
                    this.usedCharactersWidths = charWidths = widths;
                    int[] indexArray = new int[this.indeces.length + 1];
                    System.arraycopy(this.indeces, 0, indexArray, 0, i);
                    System.arraycopy(this.indeces, i, indexArray, i + 1, this.indeces.length - i);
                    this.indeces = indexArray;
                    short[] xPosArray = new short[this.xPositions.length + 1];
                    System.arraycopy(this.xPositions, 0, xPosArray, 0, i);
                    System.arraycopy(this.xPositions, i, xPosArray, i + 1, this.xPositions.length - i);
                    this.xPositions = xPosArray;
                    lineStartIndex = i;
                    this.lineWidths[lineIndex] = currentLineWidth = (int)((short)(currentLineWidth - characterWidth));
                    if (currentLineWidth > maxLineWidth) {
                        maxLineWidth = currentLineWidth;
                    }
                    if (lineIndex == maxLines) {
                        maxLinesReached = true;
                        break;
                    }
                    if (++lineIndex >= this.lineWidths.length) {
                        this.lineWidths = this.increaseShortArraySize(this.lineWidths, 10);
                    }
                    currentLineWidth = 0;
                }
            }
            firstLineWidth = lineWidth;
        }
        if (maxLinesReached) {
            if (maxLinesAppendix != null && maxLinesAppendixFont != null) {
                BitMapFontViewer appendixViewer = maxLinesAppendixFont.getViewer(maxLinesAppendix, this.color);
                appendixViewer.layout(firstLineWidth, lineWidth, paddingVertical, 4);
                int lastLineWidth = this.lineWidths[lineIndex];
                lastLineWidth += appendixViewer.getWidth();
                while (lastLineWidth > firstLineWidth && i > 0) {
                    lastLineWidth -= charWidths[i];
                    charWidths[i] = -3;
                    --i;
                }
                this.maxLineAppendixViewer = appendixViewer;
                if (lastLineWidth > maxLineWidth) {
                    maxLineWidth = (short)lastLineWidth;
                }
            }
        } else {
            this.maxLineAppendixViewer = null;
            this.lineWidths[lineIndex] = currentLineWidth;
            if (currentLineWidth > maxLineWidth) {
                maxLineWidth = currentLineWidth;
            }
        }
        this.numberOfLines = lineIndex + 1;
        this.width = maxLineWidth;
        this.height = this.numberOfLines * (this.fontHeight + paddingVertical) - paddingVertical;
    }

    public void setHorizontalOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    private short[] increaseShortArraySize(short[] src, int growFactor) {
        short[] dest = new short[src.length + growFactor];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public byte[] getUsedCharactersWidths() {
        byte[] ret = new byte[this.usedCharactersWidths.length];
        System.arraycopy(this.usedCharactersWidths, 0, ret, 0, ret.length);
        return ret;
    }

    public boolean isInitialized() {
        return this.fontHeight != 0 && this.usedCharactersWidths != null && this.usedCharactersWidths.length > 0;
    }

    public String[] wrap(String text) {
        WrappedText wrappedText = new WrappedText();
        this.wrap(text, wrappedText);
        return wrappedText.getLines();
    }

    public void wrap(String text, WrappedText wrappedText) {
        if (this.lineWidths == null) {
            throw new IllegalStateException();
        }
        int start = 0;
        int lineIndex = 0;
        int lineWidth = 0;
        for (int i = 0; i < this.xPositions.length; ++i) {
            byte characterWidth = this.usedCharactersWidths[i];
            if (characterWidth < 0) {
                String line = text.substring(start, i);
                wrappedText.addLine(line, lineWidth);
                lineWidth = 0;
                start = i + 1;
                if (++lineIndex < this.numberOfLines) continue;
                break;
            }
            lineWidth += characterWidth;
        }
        if (lineIndex < this.numberOfLines) {
            wrappedText.addLine(text.substring(start), lineWidth);
        }
    }
}

