/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.util.IntHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SmileyTextEffect
extends TextEffect {
    public static Smiley[] smileyList = null;
    static IntHashMap smileyMap;
    static IntHashMap smileyHash;
    static boolean isInitialized;
    static int smileyWidth;
    static int smileyHeight;

    public SmileyTextEffect() {
        smileyList = new Smiley[0];
    }

    public static void init() {
        smileyMap = new IntHashMap();
        smileyHash = new IntHashMap();
        if (smileyList == null || smileyList.length == 0) {
            return;
        }
        Image img = SmileyTextEffect.smileyList[0].image;
        if (img != null) {
            smileyWidth = img.getWidth();
            smileyHeight = img.getHeight();
        }
        for (int i = 0; i < smileyList.length; ++i) {
            Smiley smiley = smileyList[i];
            for (int j = 0; j < smiley.smileys.length; ++j) {
                String smileyText = smiley.smileys[j].toLowerCase();
                smileyMap.put(smileyText.hashCode(), smiley);
                char hash = smileyText.charAt(0);
                ArrayList smileys = (ArrayList)smileyHash.get(hash);
                if (smileys == null) {
                    smileys = new ArrayList();
                    smileys.add(smileyText);
                    smileyHash.put(hash, smileys);
                    continue;
                }
                if (smileys.contains(smiley)) continue;
                smileys.add(smileyText);
            }
        }
        isInitialized = true;
    }

    public int stringWidth(String str) {
        if (!isInitialized) {
            SmileyTextEffect.init();
        }
        int textStart = 0;
        int stringWidth = 0;
        for (int index = 0; index < str.length(); ++index) {
            String sequence;
            char hash = Character.toLowerCase(str.charAt(index));
            ArrayList smileys = (ArrayList)smileyHash.get(hash);
            if (smileys == null || (sequence = this.getNextSmiley(str, index, smileys)) == null) continue;
            int textWidth = this.getFont().substringWidth(str, textStart, index - textStart);
            stringWidth += textWidth + smileyWidth;
            index += sequence.length();
            textStart = index--;
        }
        return stringWidth += this.getFont().substringWidth(str, textStart, str.length() - textStart);
    }

    public int getFontHeight() {
        int fontHeight;
        if (!isInitialized) {
            SmileyTextEffect.init();
        }
        if ((fontHeight = super.getFontHeight()) > smileyHeight) {
            return fontHeight;
        }
        return smileyHeight;
    }

    public String[] wrap(String text, int textColor, Font font, int firstLineWidth, int lineWidth) {
        return this.wrap(text, textColor, font, firstLineWidth, lineWidth, -1, null);
    }

    public String[] wrap(String text, int textColor, Font font, int firstLineWidth, int lineWidth, int maxLines, String maxLinesAppendix) {
        if (!isInitialized) {
            SmileyTextEffect.init();
        }
        if (firstLineWidth <= 0 || lineWidth <= 0) {
            Debug.debug("error", "de.enough.polish.ui.texteffects.SmileyTextEffect", 227, "INVALID LINE WIDTH FOR SPLITTING " + firstLineWidth + " / " + lineWidth + " ( for string " + text + ")");
            new RuntimeException().printStackTrace();
            return new String[]{text};
        }
        boolean hasLineBreaks = text.indexOf(10) != -1;
        int completeWidth = this.stringWidth(text);
        if (completeWidth <= firstLineWidth && !hasLineBreaks) {
            return new String[]{text};
        }
        ArrayList lines = new ArrayList();
        if (!hasLineBreaks) {
            this.wrap(text, font, completeWidth, firstLineWidth, lineWidth, lines);
        } else {
            char[] valueChars = text.toCharArray();
            int lastIndex = 0;
            int c = 32;
            for (int i = 0; i < valueChars.length; ++i) {
                c = valueChars[i];
                if (c != 10 && i != valueChars.length - 1) continue;
                String line = null;
                line = i == valueChars.length - 1 ? new String(valueChars, lastIndex, i + 1 - lastIndex) : new String(valueChars, lastIndex, i - lastIndex);
                completeWidth = this.stringWidth(line);
                if (completeWidth <= firstLineWidth) {
                    lines.add(line);
                } else {
                    this.wrap(line, font, completeWidth, firstLineWidth, lineWidth, lines);
                }
                lastIndex = i + 1;
                firstLineWidth = lineWidth;
            }
            if (c == 10) {
                lines.add("");
            }
        }
        if (maxLines != -1 && lines.size() > maxLines) {
            String[] result = (String[])lines.toArray(new String[maxLines]);
            if (maxLinesAppendix != null) {
                String lastLine = result[maxLines - 1];
                int width = font.stringWidth(lastLine);
                int appendixWidth = font.stringWidth(maxLinesAppendix);
                while (width + appendixWidth > firstLineWidth && lastLine.length() > 0) {
                    lastLine = lastLine.substring(0, lastLine.length() - 1);
                    width = font.stringWidth(lastLine);
                }
                result[maxLines - 1] = lastLine + maxLinesAppendix;
            }
        }
        return (String[])lines.toArray(new String[lines.size()]);
    }

    public void wrap(String value, Font font, int completeWidth, int firstLineWidth, int lineWidth, ArrayList list) {
        if (!isInitialized) {
            SmileyTextEffect.init();
        }
        char[] valueChars = value.toCharArray();
        int startPos = 0;
        int lastSpacePos = -1;
        int lastSpacePosLength = 0;
        int currentLineWidth = 0;
        for (int i = 0; i < valueChars.length; ++i) {
            char c = valueChars[i];
            char hash = Character.toLowerCase(c);
            String smiley = null;
            ArrayList smileys = (ArrayList)smileyHash.get(hash);
            if (smileys != null) {
                smiley = this.getNextSmiley(value, i, smileys);
            }
            int elementWidth = 0;
            elementWidth = smiley == null ? font.charWidth(c) : smileyWidth;
            currentLineWidth += elementWidth;
            if (c == '\n') {
                list.add(new String(valueChars, startPos, i - startPos));
                lastSpacePos = -1;
                startPos = i + 1;
                currentLineWidth = 0;
                firstLineWidth = lineWidth;
                i = startPos;
            } else if (currentLineWidth >= firstLineWidth && i > 0) {
                if (lastSpacePos == -1) {
                    list.add(new String(valueChars, startPos, i - startPos));
                    startPos = i;
                    currentLineWidth = elementWidth;
                } else {
                    currentLineWidth -= lastSpacePosLength;
                    list.add(new String(valueChars, startPos, lastSpacePos - startPos));
                    startPos = lastSpacePos + 1;
                    lastSpacePos = -1;
                }
                firstLineWidth = lineWidth;
            } else if (c == ' ' || c == '\t') {
                lastSpacePos = i;
                lastSpacePosLength = currentLineWidth;
            }
            if (smiley == null) continue;
            i += smiley.length() - 1;
        }
        list.add(new String(valueChars, startPos, valueChars.length - startPos));
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        if (!isInitialized) {
            SmileyTextEffect.init();
        }
        int textStart = 0;
        int drawStart = 0;
        for (int index = 0; index < text.length(); ++index) {
            String sequence;
            char hash = Character.toLowerCase(text.charAt(index));
            ArrayList smileys = (ArrayList)smileyHash.get(hash);
            if (smileys == null || (sequence = this.getNextSmiley(text, index, smileys)) == null) continue;
            Smiley smiley = (Smiley)smileyMap.get(sequence.hashCode());
            g.drawSubstring(text, textStart, index - textStart, x + drawStart, y, orientation);
            int textWidth = this.getFont().substringWidth(text, textStart, index - textStart);
            g.drawImage(smiley.image, x + (drawStart += textWidth), y, orientation);
            drawStart += smileyWidth;
            index += sequence.length();
            textStart = index--;
        }
        g.drawSubstring(text, textStart, text.length() - textStart, x + drawStart, y, orientation);
    }

    protected String getNextSmiley(String line, int offset, ArrayList smileys) {
        for (int i = 0; i < smileys.size(); ++i) {
            String smiley = (String)smileys.get(i);
            if (!this.startsWithSmiley(line, smiley, offset)) continue;
            return smiley;
        }
        return null;
    }

    boolean startsWithSmiley(String line, String smiley, int offset) {
        for (int i = 0; i < smiley.length(); ++i) {
            if (offset + i < line.length()) {
                char lineCharacter = Character.toLowerCase(line.charAt(offset + i));
                if (smiley.charAt(i) == lineCharacter) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
    }

    public static class Smiley {
        public String[] smileys;
        public Image image;
        public String description;

        public Smiley(String[] smileys, String imageUrl) {
            this(smileys, imageUrl, null);
        }

        public Smiley(String[] smileys, String imageUrl, String description) {
            this.smileys = smileys;
            try {
                this.image = StyleSheet.getImage(imageUrl, this, false);
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.ui.texteffects.SmileyTextEffect", 71, (Object)"unable to load smiley image ", e);
            }
            this.description = description;
        }
    }
}

