/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.WrappedText;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CyclingTextEffect
extends TextEffect {
    private static final long DEFAULT_INTERVAL = 1000L;
    private int currentRow;
    private long interval = 1000L;
    private long lastSwitchTime;
    private Font textFont;
    private WrappedText wrappedText;

    public void animate(Item parent, long currentTime, ClippingRegion repaintRegion) {
        super.animate(parent, currentTime, repaintRegion);
        boolean addRepaintRegion = false;
        if (this.lastSwitchTime == 0L) {
            this.lastSwitchTime = currentTime;
            addRepaintRegion = true;
        } else if (currentTime - this.lastSwitchTime > this.interval) {
            int index = this.currentRow + 1;
            if (index >= this.wrappedText.size()) {
                index = 0;
            }
            this.currentRow = index;
            this.lastSwitchTime = currentTime;
            addRepaintRegion = true;
        }
        if (addRepaintRegion) {
            parent.addRepaintArea(repaintRegion);
        }
    }

    public void showNotify() {
        super.showNotify();
        this.lastSwitchTime = 0L;
    }

    public void wrap(StringItem parent, String text, int textColor, Font font, int firstLineWidth, int lineWidth, int maxLines, String maxLinesAppendix, int maxLinesAppendixPosition, WrappedText wrappedTextResult) {
        super.wrap(parent, text, textColor, font, firstLineWidth, lineWidth, maxLines, maxLinesAppendix, maxLinesAppendixPosition, wrappedTextResult);
        this.wrappedText = wrappedTextResult;
        this.textFont = font;
    }

    public void drawStrings(WrappedText textLines, int textColor, int x, int y, int leftBorder, int rightBorder, int lineHeight, int maxWidth, int layout, Graphics g) {
        if (this.wrappedText == null) {
            super.drawStrings(textLines, textColor, x, y, leftBorder, rightBorder, lineHeight, maxWidth, layout, g);
        }
        if ((layout & 3) == 3) {
            x = leftBorder + (rightBorder - leftBorder) / 2;
        } else if ((layout & 2) == 2) {
            x = rightBorder;
        }
        if ((layout & 0x20) == 32) {
            y = (layout & 0x30) == 48 ? (y -= this.textFont.getBaselinePosition()) : (y -= this.textFont.getHeight());
        }
        int anchor = this.style.getAnchorHorizontal();
        String line = this.wrappedText.getLine(this.currentRow);
        g.drawString(line, x, y, 0x10 | anchor);
    }

    public void drawString(String text, int textColor, int x, int y, int anchor, Graphics g) {
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.currentRow = dataInputStream.readInt();
        this.interval = dataInputStream.readLong();
        this.lastSwitchTime = dataInputStream.readLong();
        this.textFont = (Font)Serializer.deserialize(dataInputStream);
        this.wrappedText = (WrappedText)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.currentRow);
        dataOutputStream.writeLong(this.interval);
        dataOutputStream.writeLong(this.lastSwitchTime);
        Serializer.serialize(this.textFont, dataOutputStream);
        Serializer.serialize(this.wrappedText, dataOutputStream);
    }
}

