/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AlienGlowTextEffect
extends TextEffect {
    private static final int CLEAR_COLOR = -16776925;
    private int clearColor;
    private String lastText;
    private int lastTextColor;
    int[] argbBuffer;
    private int innerColor = -1;
    private int outerColor = -16711936;

    public AlienGlowTextEffect() {
        this.isTextSensitive = true;
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        int radius = 4;
        Font font = g.getFont();
        int fHeight = font.getHeight();
        int fWidth = font.stringWidth(text);
        int newWidth = fWidth + 8;
        int newHeight = fHeight + 8;
        if (this.lastText != text || this.lastTextColor != textColor) {
            this.lastText = text;
            this.lastTextColor = textColor;
            Image midp2ImageBuffer = Image.createImage(newWidth, newHeight);
            Graphics bufferG = midp2ImageBuffer.getGraphics();
            this.argbBuffer = new int[newWidth * newHeight];
            bufferG.setColor(-16776925);
            bufferG.fillRect(0, 0, newWidth, newHeight);
            bufferG.setFont(font);
            bufferG.setColor(this.outerColor);
            bufferG.drawString(text, 3, 3, 20);
            bufferG.drawString(text, 3, 5, 20);
            bufferG.drawString(text, 5, 3, 20);
            bufferG.drawString(text, 5, 5, 20);
            bufferG.setColor(this.innerColor);
            bufferG.drawString(text, 4, 4, 20);
            midp2ImageBuffer.getRGB(this.argbBuffer, 0, newWidth, 0, 0, newWidth, newHeight);
            int[] clearColorArray = new int[1];
            midp2ImageBuffer.getRGB(clearColorArray, 0, 1, 0, 0, 1, 1);
            this.clearColor = clearColorArray[0];
            for (int i = 0; i < this.argbBuffer.length; ++i) {
                if (this.argbBuffer[i] != this.clearColor) continue;
                this.argbBuffer[i] = 0;
            }
            DrawUtil.applyFilter(DrawUtil.FILTER_GAUSSIAN_3, 150, this.argbBuffer, newWidth, newHeight);
        }
        int startX = this.getLeftX(x, orientation, fWidth);
        int startY = this.getTopY(y, orientation, fHeight, font.getBaselinePosition());
        DrawUtil.drawRgb(this.argbBuffer, startX - 4, startY - 4, newWidth, newHeight, true, g);
        g.setColor(textColor);
        g.drawString(text, startX, startY, 20);
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
        boolean hasChanged = false;
        if (resetStyle || hasChanged) {
            this.lastText = null;
        }
    }

    public void releaseResources() {
        super.releaseResources();
        this.lastText = null;
        this.argbBuffer = null;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.argbBuffer = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.argbBuffer[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.clearColor = dataInputStream.readInt();
        this.innerColor = dataInputStream.readInt();
        this.lastText = (String)Serializer.deserialize(dataInputStream);
        this.lastTextColor = dataInputStream.readInt();
        this.outerColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        if (this.argbBuffer == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.argbBuffer.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.argbBuffer[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.clearColor);
        dataOutputStream.writeInt(this.innerColor);
        Serializer.serialize(this.lastText, dataOutputStream);
        dataOutputStream.writeInt(this.lastTextColor);
        dataOutputStream.writeInt(this.outerColor);
    }
}

