/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.splash;

import de.enough.polish.ui.Background;
import de.enough.polish.ui.Canvas;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.splash.ApplicationInitializer;
import de.enough.polish.util.Debug;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;

public class InitializerMovieScreen
extends Canvas
implements Runnable,
PlayerListener {
    private final ApplicationInitializer initializer;
    private Displayable nextScreen;
    private final Display display;
    private final int backgroundColor;
    private Background background;
    private boolean isStarted;
    private final String movieUrl;
    private Player player;
    private boolean isVideoFinished;
    private VideoControl videoControl;
    private String mimeType;

    public InitializerMovieScreen(Display display, String movieUrl, String mimeType, ApplicationInitializer initializer) {
        this(display, movieUrl, mimeType, 0xFFFFFF, initializer);
    }

    public InitializerMovieScreen(Display display, String movieUrl, String mimeType, ApplicationInitializer initializer, Style style) {
        this(display, movieUrl, mimeType, 0xFFFFFF, initializer, style);
    }

    public InitializerMovieScreen(Display display, String movieUrl, String mimeType, int backgroundColor, ApplicationInitializer initializer) {
        this.display = display;
        this.movieUrl = movieUrl;
        this.mimeType = mimeType;
        this.backgroundColor = backgroundColor;
        this.initializer = initializer;
    }

    public InitializerMovieScreen(Display display, String movieUrl, String mimeType, int backgroundColor, ApplicationInitializer initializer, Style style) {
        this.display = display;
        this.movieUrl = movieUrl;
        this.mimeType = mimeType;
        this.backgroundColor = backgroundColor;
        this.initializer = initializer;
        this.background = style.background;
    }

    public void paint(Graphics g) {
        int height = this.getHeight();
        int width = this.getWidth();
        if (this.background != null) {
            this.background.paint(0, 0, width, height, g);
        } else {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, width, height);
        }
    }

    public void run() {
        try {
            this.startVideo();
            this.initApp();
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.splash.InitializerMovieScreen", 214, (Object)"Unable to call initApp()", e);
        }
    }

    private void startVideo() {
        if (this.player == null) {
            InputStream is = this.getClass().getResourceAsStream(this.movieUrl);
            if (is == null) {
                Debug.debug("error", "de.enough.polish.ui.splash.InitializerMovieScreen", 229, (Object)"did not find video resource ", this.movieUrl);
                this.isVideoFinished = true;
                return;
            }
            try {
                this.player = Manager.createPlayer(is, this.mimeType);
                this.player.realize();
                VideoControl control = (VideoControl)this.player.getControl("VideoControl");
                if (control == null) {
                    Debug.debug("error", "de.enough.polish.ui.splash.InitializerMovieScreen", 240, "Unable to retrieve VideoControl");
                    this.isVideoFinished = true;
                    return;
                }
                control.initDisplayMode(1, StyleSheet.display);
                int sourceWidth = control.getSourceWidth();
                int sourceHeight = control.getSourceHeight();
                int width = this.getWidth();
                int height = this.getHeight();
                int x = (width >> 1) - (sourceWidth >> 1);
                int y = (height >> 1) - (sourceHeight >> 1);
                control.setDisplayLocation(x, y);
                control.setVisible(true);
                this.videoControl = control;
                this.player.addPlayerListener(this);
                this.player.start();
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.splash.InitializerMovieScreen", 264, (Object)"unable to start video ", e);
                this.isVideoFinished = true;
            }
        }
    }

    private void initApp() {
        this.nextScreen = this.initializer.initApp();
        if (this.isVideoFinished) {
            this.display.setCurrent(this.nextScreen);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.isVideoFinished && this.nextScreen != null) {
            this.display.setCurrent(this.nextScreen);
        }
    }

    public void pointerPressed(int x, int y) {
        this.keyPressed(0);
    }

    public void pointerReleased(int x, int y) {
        this.keyReleased(0);
    }

    public void sizeChanged(int width, int height) {
        this.repaint();
    }

    public void showNotify() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void hideNotify() {
        if (this.isVideoFinished && this.player != null) {
            if (this.videoControl != null) {
                try {
                    this.videoControl.setVisible(false);
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.ui.splash.InitializerMovieScreen", 325, (Object)"Unable to invisible player", e);
                }
                this.videoControl = null;
            }
            try {
                this.player.close();
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.splash.InitializerMovieScreen", 333, (Object)"Unable to close player", e);
            }
            this.player = null;
        }
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
        this.repaint();
    }

    public void playerUpdate(Player p, String event, Object data) {
        if ("endOfMedia".equals(event)) {
            this.isVideoFinished = true;
            if (this.nextScreen != null) {
                this.display.setCurrent(this.nextScreen);
            }
        }
    }
}

