/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Graphics;

public class ZoomBothScreenChangeAnimation
extends ScreenChangeAnimation {
    private int outerScaleFactor = 260;
    private int innerScaleFactor = 460;
    private int[] nextCanvasScaledRgb;
    private int[] lastCanvasScaledRgb;
    private int currentMagnifyFactor;

    public ZoomBothScreenChangeAnimation() {
        this.useLastCanvasRgb = true;
        this.useNextCanvasRgb = true;
    }

    protected void onShow(Style style, Display dsplay, int width, int height, Displayable lstDisplayable, Displayable nxtDisplayable, boolean isForward) {
        int size = width * height;
        this.lastCanvasScaledRgb = new int[size];
        this.nextCanvasScaledRgb = new int[size];
        super.onShow(style, dsplay, width, height, lstDisplayable, nxtDisplayable, isForward);
    }

    protected boolean animate(long passedTime, long duration) {
        int[] rgbSecondScaled;
        int[] rgbSecondOriginal;
        int[] rgbFirstScaled;
        int[] rgbFirstOriginal;
        int endOpacity;
        int startOpacity;
        int endFactor2;
        int startFactor2;
        int endFactor1;
        int startFactor1;
        if (passedTime > duration) {
            this.nextCanvasScaledRgb = null;
            this.lastCanvasScaledRgb = null;
            return false;
        }
        if (this.isForwardAnimation) {
            startFactor1 = 100;
            endFactor1 = this.innerScaleFactor;
            startFactor2 = 30;
            endFactor2 = 100;
            startOpacity = 10;
            endOpacity = 255;
            rgbFirstOriginal = this.lastCanvasRgb;
            rgbFirstScaled = this.lastCanvasScaledRgb;
            rgbSecondOriginal = this.nextCanvasRgb;
            rgbSecondScaled = this.nextCanvasScaledRgb;
        } else {
            startFactor1 = this.innerScaleFactor;
            endFactor1 = 100;
            startFactor2 = this.outerScaleFactor;
            endFactor2 = 100;
            startOpacity = 255;
            endOpacity = 10;
            rgbFirstOriginal = this.nextCanvasRgb;
            rgbFirstScaled = this.nextCanvasScaledRgb;
            rgbSecondOriginal = this.lastCanvasRgb;
            rgbSecondScaled = this.lastCanvasScaledRgb;
        }
        int magnifyFactor = this.calculateAnimationPoint(startFactor1, endFactor1, passedTime, duration);
        ImageUtil.scale(magnifyFactor, this.screenWidth, this.screenHeight, rgbFirstOriginal, rgbFirstScaled);
        magnifyFactor = this.calculateAnimationPoint(startFactor2, endFactor2, passedTime, duration);
        int opacity = this.calculateAnimationPoint(startOpacity, endOpacity, passedTime, duration);
        this.currentMagnifyFactor = magnifyFactor;
        ImageUtil.scale(opacity, magnifyFactor, this.screenWidth, this.screenHeight, rgbSecondOriginal, rgbSecondScaled);
        return true;
    }

    public void paintAnimation(Graphics g) {
        int[] second;
        int[] first;
        if (this.isForwardAnimation) {
            first = this.lastCanvasScaledRgb;
            second = this.nextCanvasScaledRgb;
        } else {
            first = this.nextCanvasScaledRgb;
            second = this.lastCanvasScaledRgb;
        }
        g.drawRGB(first, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, true);
        if (!this.isForwardAnimation) {
            int w = this.screenWidth * this.currentMagnifyFactor / 100;
            int h = this.screenHeight * this.currentMagnifyFactor / 100;
            g.setClip((this.screenWidth >> 1) - (w >> 1), (this.screenHeight >> 1) - (h >> 1), w, h);
        }
        g.drawRGB(second, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, true);
    }
}

