/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScaleScreenChangeAnimation
extends ScreenChangeAnimation {
    private int scaleFactor = 10;
    private int[] scaledScreenRgb;
    private int currentScaleFactor;

    protected void onShow(Style style, Display dsplay, int width, int height, Displayable lstDisplayable, Displayable nxtDisplayable, boolean isForward) {
        if (isForward) {
            this.useLastCanvasRgb = false;
            this.useNextCanvasRgb = true;
        } else {
            this.useLastCanvasRgb = true;
            this.useNextCanvasRgb = false;
        }
        this.scaledScreenRgb = new int[width * height];
        super.onShow(style, dsplay, width, height, lstDisplayable, nxtDisplayable, isForward);
    }

    protected boolean animate(long passedTime, long duration) {
        int[] rgb;
        int endValue;
        int startValue;
        if (passedTime > duration) {
            this.scaledScreenRgb = null;
            return false;
        }
        if (this.isForwardAnimation) {
            startValue = this.scaleFactor;
            endValue = 100;
            rgb = this.nextCanvasRgb;
        } else {
            startValue = 100;
            endValue = this.scaleFactor;
            rgb = this.lastCanvasRgb;
        }
        int factor = this.calculateAnimationPoint(startValue, endValue, passedTime, duration);
        ImageUtil.scale(factor, this.screenWidth, this.screenHeight, rgb, this.scaledScreenRgb);
        this.currentScaleFactor = factor;
        return true;
    }

    public void paintAnimation(Graphics g) {
        Image img = this.isForwardAnimation ? this.lastCanvasImage : this.nextCanvasImage;
        g.drawImage(img, 0, 0, 20);
        int targetWidth = this.screenWidth * this.currentScaleFactor / 100;
        int targetHeight = this.screenHeight * this.currentScaleFactor / 100;
        g.clipRect((this.screenWidth - targetWidth) / 2, (this.screenHeight - targetHeight) / 2, targetWidth, targetHeight);
        g.drawRGB(this.scaledScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, false);
    }
}

