/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RotateScreenChangeAnimation
extends ScreenChangeAnimation {
    private int[] rotatedScreenRgb;

    protected void onShow(Style style, Display dsplay, int width, int height, Displayable lstDisplayable, Displayable nxtDisplayable, boolean isForward) {
        if (isForward) {
            this.useLastCanvasRgb = false;
            this.useNextCanvasRgb = true;
        } else {
            this.useLastCanvasRgb = true;
            this.useNextCanvasRgb = false;
        }
        this.rotatedScreenRgb = new int[width * height];
        super.onShow(style, dsplay, width, height, lstDisplayable, nxtDisplayable, isForward);
    }

    protected boolean animate(long passedTime, long duration) {
        int endOpacity;
        int startOpacity;
        int endDegree;
        int startDegree;
        int[] source;
        if (passedTime > duration) {
            this.rotatedScreenRgb = null;
            return false;
        }
        if (this.isForwardAnimation) {
            source = this.nextCanvasRgb;
            startDegree = 270;
            endDegree = 360;
            startOpacity = 10;
            endOpacity = 255;
        } else {
            source = this.lastCanvasRgb;
            startDegree = 360;
            endDegree = 270;
            startOpacity = 255;
            endOpacity = 10;
        }
        int degrees = this.calculateAnimationPoint(startDegree, endDegree, passedTime, duration);
        int opacity = this.calculateAnimationPoint(startOpacity, endOpacity, passedTime, duration);
        double degreeCos = Math.cos(Math.PI * (double)degrees / 180.0);
        double degreeSin = Math.sin(Math.PI * (double)degrees / 180.0);
        int backgroundArgb = 0;
        ImageUtil.rotate(source, this.screenWidth, this.screenHeight, this.screenWidth >> 1, this.screenHeight >> 1, backgroundArgb, degreeCos, degreeSin, this.rotatedScreenRgb, this.screenWidth, this.screenHeight, opacity);
        return true;
    }

    protected void paintAnimation(Graphics g) {
        Image canvasImage = this.isForwardAnimation ? this.lastCanvasImage : this.nextCanvasImage;
        g.drawImage(canvasImage, 0, 0, 20);
        g.drawRGB(this.rotatedScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, true);
    }
}

