/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DiagonalScreenChangeAnimation
extends ScreenChangeAnimation {
    private int currentX;
    private int currentY;

    protected void setStyle(Style style) {
        super.setStyle(style);
        if (this.isForwardAnimation) {
            this.currentX = 0;
            this.currentY = 0;
        } else {
            this.currentX = this.screenWidth;
            this.currentY = this.screenHeight;
        }
    }

    protected boolean animate(long passedTime, long duration) {
        int endY;
        int startY;
        int endX;
        int startX;
        if (passedTime > duration) {
            return false;
        }
        if (this.isForwardAnimation) {
            startX = 0;
            endX = this.screenWidth;
            startY = 0;
            endY = this.screenHeight;
        } else {
            startX = this.screenWidth;
            endX = 0;
            startY = this.screenHeight;
            endY = 0;
        }
        this.currentX = this.calculateAnimationPoint(startX, endX, passedTime, duration);
        this.currentY = this.calculateAnimationPoint(startY, endY, passedTime, duration);
        return true;
    }

    public void paintAnimation(Graphics g) {
        Image second;
        Image first;
        int y = 0;
        int x = 0;
        if (this.isForwardAnimation) {
            first = this.lastCanvasImage;
            second = this.nextCanvasImage;
        } else {
            first = this.nextCanvasImage;
            second = this.lastCanvasImage;
        }
        g.drawImage(first, x, y, 20);
        g.drawImage(second, this.screenWidth - this.currentX, this.screenHeight - this.currentY, 20);
    }
}

