/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.DrawUtil;
import javax.microedition.lcdui.Graphics;

public class BwToColorScreenChangeAnimation
extends ScreenChangeAnimation {
    private int[] currentScreenRgb;

    public BwToColorScreenChangeAnimation() {
        this.useNextCanvasRgb = true;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
        this.currentScreenRgb = new int[this.screenWidth * this.screenHeight];
    }

    protected boolean animate(long passedTime, long duration) {
        if (passedTime > duration) {
            this.currentScreenRgb = null;
            this.nextCanvasRgb = null;
            return false;
        }
        int permille = this.calculateAnimationPoint(0, 1000, passedTime, duration);
        for (int i = 0; i < this.currentScreenRgb.length; ++i) {
            int targetColor = this.nextCanvasRgb[i];
            int red = 0xFF & targetColor >>> 16;
            int green = 0xFF & targetColor >>> 8;
            int blue = targetColor & 0xFF;
            int brightness = (red + green + blue) / 3;
            int startColor = brightness > 127 ? 0xFFFFFF : 0;
            if (startColor == targetColor) continue;
            this.currentScreenRgb[i] = DrawUtil.getGradientColor(startColor, targetColor, permille);
        }
        return true;
    }

    public void paintAnimation(Graphics g) {
        g.drawRGB(this.currentScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, false);
    }
}

