/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.rgbfilters;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.RgbFilter;
import de.enough.polish.ui.Style;
import de.enough.polish.util.RgbImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GrayscaleRgbFilter
extends RgbFilter {
    protected Dimension grayscale;
    protected transient RgbImage output;

    public boolean isActive() {
        boolean isActive = false;
        if (this.grayscale != null) {
            isActive = this.grayscale.getValue(1024) != 0;
        }
        return isActive;
    }

    public RgbImage process(RgbImage input) {
        if (!this.isActive()) {
            return input;
        }
        if (this.output == null || this.output.getWidth() != input.getWidth() || this.output.getHeight() != input.getHeight()) {
            this.output = new RgbImage(input.getWidth(), input.getHeight());
        }
        int[] rgbInput = input.getRgbData();
        int[] rgbOutput = this.output.getRgbData();
        int saturation = 1024 - this.grayscale.getValue(1024);
        int RW = 306;
        int RG = 601;
        int RB = 117;
        int a = (1024 - saturation) * RW + saturation * 1024;
        int b = (1024 - saturation) * RW;
        int c = (1024 - saturation) * RW;
        int d = (1024 - saturation) * RG;
        int e = (1024 - saturation) * RG + saturation * 1024;
        int f = (1024 - saturation) * RG;
        int g = (1024 - saturation) * RB;
        int h = (1024 - saturation) * RB;
        int i = (1024 - saturation) * RB + saturation * 1024;
        int pixel = 0;
        for (int p = 0; p < rgbOutput.length; ++p) {
            pixel = rgbInput[p];
            int alpha = 0xFF000000 & pixel;
            int red = 0xFF & pixel >> 16;
            int green = 0xFF & pixel >> 8;
            int blue = pixel & 0xFF;
            int output_red = a * red + d * green + g * blue >> 4 & 0xFF0000;
            int output_green = b * red + e * green + h * blue >> 12 & 0xFF00;
            int output_blue = c * red + f * green + i * blue >> 20;
            rgbOutput[p] = alpha | output_red | output_green | output_blue;
        }
        return this.output;
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
    }

    public void releaseResources() {
        this.output = null;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.grayscale = (Dimension)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.grayscale, dataOutputStream);
    }
}

