/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.gaugeviews;

import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TachometerGaugeView
extends ItemView {
    private int startValue;
    private int maxValue;
    private int factor = 1;
    private int section1Start;
    private int section2Start;
    private int section3Start;
    private int section1Color = -1;
    private int section2Color = -1;
    private int section3Color = -1;
    private int clockfaceColor = 0xFF0000;
    private int innerColor = 0xFFFFFF;
    private int needleColor = 0;

    protected void initContent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        Gauge gauge = (Gauge)parent;
        this.maxValue = gauge.getMaxValue();
        int range = this.maxValue - this.startValue;
        if (this.section2Start == 0) {
            this.section2Start = range / 3;
        }
        if (this.section3Start == 0) {
            this.section3Start = range * 2 / 3;
        }
        this.contentHeight = this.contentWidth = 120;
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int itemWidth = this.contentWidth;
        int itemHeight = this.contentHeight;
        int widthLine = x + itemWidth;
        int heightLine = y + itemHeight;
        Gauge gauge = (Gauge)parent;
        int centerX = x + itemWidth / 2;
        int centerY = y + itemWidth / 2;
        int innerCircleRadius = this.contentWidth / 10;
        g.setColor(this.clockfaceColor);
        g.drawArc(x, y, itemWidth, itemHeight, 0, 360);
        int innerStartX = x + innerCircleRadius;
        int innerStartY = y + innerCircleRadius;
        int innerWidth = itemWidth - innerCircleRadius * 2;
        int innerHeight = itemHeight - innerCircleRadius * 2;
        int pointerLength = innerWidth / 2 - innerWidth / 8;
        g.setColor(this.clockfaceColor);
        Font font = Font.getFont(32, 0, 8);
        int startValueStringWidth = font.stringWidth("" + this.startValue);
        int maxValueStringWidth = font.stringWidth("" + this.maxValue);
        int gaugeValueStringWidth = font.stringWidth("" + gauge.getValue());
        g.setFont(font);
        g.drawString("" + this.startValue, centerX / 2 + startValueStringWidth, innerStartY + innerHeight - font.getHeight(), 0);
        g.drawString("" + this.maxValue, centerX + maxValueStringWidth, innerStartY + innerHeight - font.getHeight(), 0);
        g.drawString("" + gauge.getValue(), centerX - gaugeValueStringWidth / 2, innerStartY + innerHeight - font.getHeight() * 2, 0);
        g.setColor(this.needleColor);
        int value = gauge.getValue();
        double valuePercent = (double)value / (double)this.maxValue * 100.0;
        int degree = (int)(225.0 - valuePercent * 2.7);
        double degreeCos = Math.cos(Math.PI * (double)degree / 180.0);
        double degreeSin = Math.sin(Math.PI * (double)degree / 180.0);
        int angleCos = (int)(degreeCos * (double)pointerLength);
        int angleSin = (int)(degreeSin * (double)pointerLength);
        int newX = centerX + angleCos;
        int newY = centerY + -angleSin;
        g.drawLine(centerX, centerY, newX, newY);
        int tickLength = pointerLength + 10;
        for (int i = 225; i >= -45; i -= 15) {
            degree = i;
            degreeCos = Math.cos(Math.PI * (double)degree / 180.0);
            degreeSin = Math.sin(Math.PI * (double)degree / 180.0);
            angleCos = (int)(degreeCos * (double)tickLength);
            angleSin = (int)(degreeSin * (double)tickLength);
            int startX = centerX + angleCos;
            int startY = centerY + -angleSin;
            if (i != 90 && i != 225 && i != -45 && i != 0 && i != 180 && i != 45 && i != 135) {
                angleCos = (int)(degreeCos * (double)(tickLength - 4));
                angleSin = (int)(degreeSin * (double)(tickLength - 4));
            } else {
                angleCos = (int)(degreeCos * (double)(tickLength - 10));
                angleSin = (int)(degreeSin * (double)(tickLength - 10));
            }
            int endX = centerX + angleCos;
            int endY = centerY + -angleSin;
            g.drawLine(startX, startY, endX, endY);
        }
    }

    protected void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof Gauge;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.clockfaceColor = dataInputStream.readInt();
        this.factor = dataInputStream.readInt();
        this.innerColor = dataInputStream.readInt();
        this.maxValue = dataInputStream.readInt();
        this.needleColor = dataInputStream.readInt();
        this.section1Color = dataInputStream.readInt();
        this.section1Start = dataInputStream.readInt();
        this.section2Color = dataInputStream.readInt();
        this.section2Start = dataInputStream.readInt();
        this.section3Color = dataInputStream.readInt();
        this.section3Start = dataInputStream.readInt();
        this.startValue = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.clockfaceColor);
        dataOutputStream.writeInt(this.factor);
        dataOutputStream.writeInt(this.innerColor);
        dataOutputStream.writeInt(this.maxValue);
        dataOutputStream.writeInt(this.needleColor);
        dataOutputStream.writeInt(this.section1Color);
        dataOutputStream.writeInt(this.section1Start);
        dataOutputStream.writeInt(this.section2Color);
        dataOutputStream.writeInt(this.section2Start);
        dataOutputStream.writeInt(this.section3Color);
        dataOutputStream.writeInt(this.section3Start);
        dataOutputStream.writeInt(this.startValue);
    }
}

