/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.gaugeviews;

import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Style;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class RotatingArcsGaugeView
extends ItemView {
    private int startColor = 0x222222;
    private int endColor = 0xEEEEEE;
    private int numberOfArcs = 6;
    private int rotationSpeed = 12;
    private int startArc;
    private int[] arcColors;

    public boolean animate() {
        super.animate();
        this.startArc += this.rotationSpeed;
        return true;
    }

    protected void initContent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        this.contentHeight = this.contentWidth = Math.max(availWidth / 4, 24);
        this.arcColors = DrawUtil.getGradient(this.startColor, this.endColor, this.numberOfArcs);
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int arcStep = 360 / this.numberOfArcs;
        int arc = this.startArc;
        int width = this.contentWidth;
        for (int i = 0; i < this.arcColors.length; ++i) {
            int color2 = this.arcColors[i];
            g.setColor(color2);
            g.fillArc(x, y, width, width, arc, arcStep >> 1);
            arc += arcStep;
        }
    }

    protected void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof Gauge;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.arcColors = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.arcColors[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.endColor = dataInputStream.readInt();
        this.numberOfArcs = dataInputStream.readInt();
        this.rotationSpeed = dataInputStream.readInt();
        this.startArc = dataInputStream.readInt();
        this.startColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        if (this.arcColors == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.arcColors.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.arcColors[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.endColor);
        dataOutputStream.writeInt(this.numberOfArcs);
        dataOutputStream.writeInt(this.rotationSpeed);
        dataOutputStream.writeInt(this.startArc);
        dataOutputStream.writeInt(this.startColor);
    }
}

