/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.gaugeviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HorizontalIconsGaugeView
extends ItemView {
    private int iconCount = 8;
    private int iconHighlightCount = 3;
    private Image iconImage = null;
    private Image iconHighlightImage = null;
    private Image iconHighlightCenterImage = null;
    private int iconHighlightIndex = 0;
    private int iconHighlightCenterIndex = -1;
    private int iconHighlightCenterSpan = -1;
    private int iconWidth = 10;
    private boolean isContinuousRunning;
    private int maxIcons;
    private transient Gauge gauge;
    private long lastAnimationTime;
    private long interval = 0L;
    private boolean nextHighlight = false;

    protected void initContent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        this.gauge = (Gauge)parent;
        boolean bl = this.isContinuousRunning = this.gauge.getMaxValue() == -1 && this.gauge.getValue() == 2;
        if (!this.isContinuousRunning) {
            this.maxIcons = this.iconCount - this.iconHighlightCount;
        }
        this.contentWidth = availWidth;
        this.contentHeight = this.iconWidth;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        if (this.isContinuousRunning && currentTime - this.lastAnimationTime > this.interval) {
            this.nextHighlight = true;
            this.iconHighlightIndex %= this.iconCount;
            this.lastAnimationTime = currentTime;
            this.addFullRepaintRegion(this.parentItem, repaintRegion);
        }
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        Image img = null;
        if (this.nextHighlight) {
            ++this.iconHighlightIndex;
            this.nextHighlight = false;
        }
        if (!this.isContinuousRunning) {
            this.iconHighlightIndex = this.gauge.getValue() * 100 / this.gauge.getMaxValue() * this.maxIcons / 100;
        }
        int stepX = this.contentWidth / this.iconCount;
        int offsetX = 0;
        for (int i = 0; i < this.iconCount; ++i) {
            offsetX = stepX * i;
            img = this.getImage(g, i);
            if (img == null) continue;
            g.drawImage(img, x + offsetX, y, 0);
        }
    }

    private Image getImage(Graphics g, int i) {
        int startIndex = this.iconHighlightIndex;
        int endIndex = (this.iconHighlightIndex + this.iconHighlightCount - 1) % this.iconCount;
        Image img = null;
        if (startIndex <= endIndex) {
            if (i >= startIndex && i <= endIndex) {
                if (this.iconHighlightCenterIndex != -1) {
                    img = null;
                    img = this.getCenterImage(startIndex, g, i);
                    if (img != null) {
                        return img;
                    }
                }
                return this.iconHighlightImage;
            }
        } else if (i >= startIndex || i <= endIndex) {
            if (this.iconHighlightCenterIndex != -1) {
                img = null;
                img = this.getCenterImage(startIndex, g, i);
                if (img != null) {
                    return img;
                }
            }
            return this.iconHighlightImage;
        }
        return this.iconImage;
    }

    public Image getCenterImage(int startIndex, Graphics g, int i) {
        int centerStartIndex = (startIndex + this.iconHighlightCenterIndex) % this.iconCount;
        int centerEndIndex = (startIndex + this.iconHighlightCenterIndex + (this.iconHighlightCenterSpan - 1)) % this.iconCount;
        if (centerStartIndex <= centerEndIndex ? i >= centerStartIndex && i <= centerEndIndex : i >= centerStartIndex || i <= centerEndIndex) {
            return this.iconHighlightCenterImage;
        }
        return null;
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof Gauge;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.iconCount = dataInputStream.readInt();
        this.iconHighlightCenterImage = (Image)Serializer.deserialize(dataInputStream);
        this.iconHighlightCenterIndex = dataInputStream.readInt();
        this.iconHighlightCenterSpan = dataInputStream.readInt();
        this.iconHighlightCount = dataInputStream.readInt();
        this.iconHighlightImage = (Image)Serializer.deserialize(dataInputStream);
        this.iconHighlightIndex = dataInputStream.readInt();
        this.iconImage = (Image)Serializer.deserialize(dataInputStream);
        this.iconWidth = dataInputStream.readInt();
        this.interval = dataInputStream.readLong();
        this.isContinuousRunning = dataInputStream.readBoolean();
        this.lastAnimationTime = dataInputStream.readLong();
        this.maxIcons = dataInputStream.readInt();
        this.nextHighlight = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.iconCount);
        Serializer.serialize(this.iconHighlightCenterImage, dataOutputStream);
        dataOutputStream.writeInt(this.iconHighlightCenterIndex);
        dataOutputStream.writeInt(this.iconHighlightCenterSpan);
        dataOutputStream.writeInt(this.iconHighlightCount);
        Serializer.serialize(this.iconHighlightImage, dataOutputStream);
        dataOutputStream.writeInt(this.iconHighlightIndex);
        Serializer.serialize(this.iconImage, dataOutputStream);
        dataOutputStream.writeInt(this.iconWidth);
        dataOutputStream.writeLong(this.interval);
        dataOutputStream.writeBoolean(this.isContinuousRunning);
        dataOutputStream.writeLong(this.lastAnimationTime);
        dataOutputStream.writeInt(this.maxIcons);
        dataOutputStream.writeBoolean(this.nextHighlight);
    }
}

