/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.game;

import de.enough.polish.ui.game.Layer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledLayer
extends Layer {
    protected int cellWidth;
    protected int cellHeight;
    private byte[][] grid;
    private Image image;
    private int[] tileXPositions;
    private int[] tileYPositions;
    private byte[] animatedTiles;
    private int animatedTilesLength;
    private int numberOfTiles;
    private int numberOfColumns;
    private int gridColumns;
    private int gridRows;

    public TiledLayer(int columns, int rows, Image image, int tileWidth, int tileHeight) {
        this.grid = new byte[columns][rows];
        this.gridColumns = columns;
        this.gridRows = rows;
        this.width = columns * tileWidth;
        this.height = rows * tileHeight;
        this.setStaticTileSet(image, tileWidth, tileHeight);
    }

    public void setStaticTileSet(Image image, int tileWidth, int tileHeight) {
        int i;
        this.cellWidth = tileWidth;
        this.cellHeight = tileHeight;
        int columns = image.getWidth() / tileWidth;
        int rows = image.getHeight() / tileHeight;
        this.image = image;
        this.tileXPositions = new int[columns];
        int pos = 0;
        for (i = 0; i < columns; ++i) {
            this.tileXPositions[i] = pos;
            pos += tileWidth;
        }
        this.tileYPositions = new int[rows];
        pos = 0;
        for (i = 0; i < rows; ++i) {
            this.tileYPositions[i] = pos;
            pos += tileHeight;
        }
        if (columns * rows < this.numberOfTiles) {
            for (i = 0; i < this.grid.length; ++i) {
                for (int j = 0; j < this.grid[i].length; ++j) {
                    this.grid[i][j] = 0;
                }
            }
        }
        this.numberOfTiles = columns * rows;
        this.numberOfColumns = columns;
    }

    public int createAnimatedTile(int staticTileIndex) {
        if (staticTileIndex >= this.numberOfTiles) {
            throw new IllegalArgumentException();
        }
        if (this.animatedTiles == null) {
            this.animatedTiles = new byte[4];
        } else if (this.animatedTilesLength == this.animatedTiles.length) {
            byte[] newAnimatedTiles = new byte[this.animatedTilesLength * 2];
            System.arraycopy(this.animatedTiles, 0, newAnimatedTiles, 0, this.animatedTilesLength);
            this.animatedTiles = newAnimatedTiles;
        }
        this.animatedTiles[this.animatedTilesLength] = (byte)staticTileIndex;
        ++this.animatedTilesLength;
        return -1 * this.animatedTilesLength;
    }

    public void setAnimatedTile(int animatedTileIndex, int staticTileIndex) {
        int animatedIndex = -1 * animatedTileIndex - 1;
        this.animatedTiles[animatedIndex] = (byte)staticTileIndex;
    }

    public int getAnimatedTile(int animatedTileIndex) {
        int animatedIndex = -1 * animatedTileIndex - 1;
        return this.animatedTiles[animatedIndex];
    }

    public void setCell(int col, int row, int tileIndex) {
        this.grid[col][row] = (byte)tileIndex;
    }

    public int getCell(int col, int row) {
        return this.grid[col][row];
    }

    public void fillCells(int col, int row, int numCols, int numRows, int tileIndex) {
        int endCols = col + numCols;
        int endRows = row + numRows;
        for (int i = col; i < endCols; ++i) {
            for (int j = row; j < endRows; ++j) {
                this.grid[i][j] = (byte)tileIndex;
            }
        }
    }

    public final int getCellWidth() {
        return this.cellWidth;
    }

    public final int getCellHeight() {
        return this.cellHeight;
    }

    public final int getColumns() {
        return this.gridColumns;
    }

    public final int getRows() {
        return this.gridRows;
    }

    public final void paint(Graphics g) {
        int yStart;
        int lastRow;
        int lastColumn;
        if (!this.isVisible) {
            return;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int firstColumn = 0;
        if (this.xPosition < clipX) {
            firstColumn = (clipX - this.xPosition) / this.cellWidth;
            lastColumn = (clipX - this.xPosition + clipWidth) / this.cellWidth + 1;
        } else {
            lastColumn = clipWidth / this.cellWidth + 1;
        }
        if (lastColumn > this.gridColumns) {
            lastColumn = this.gridColumns;
        }
        int firstRow = 0;
        if (this.yPosition < clipY) {
            firstRow = (clipY - this.yPosition) / this.cellHeight;
            lastRow = (clipY - this.yPosition + clipHeight) / this.cellHeight + 1;
        } else {
            lastRow = clipHeight / this.cellHeight + 1;
        }
        if (lastRow > this.gridRows) {
            lastRow = this.gridRows;
        }
        int xStart = this.xPosition + firstColumn * this.cellWidth;
        int y = yStart = this.yPosition + firstRow * this.cellHeight;
        int x = xStart;
        byte[][] gridTable = this.grid;
        for (int column = firstColumn; column < lastColumn; ++column) {
            byte[] gridColumn = gridTable[column];
            for (int row = firstRow; row < lastRow; ++row) {
                byte cellIndex = gridColumn[row];
                if (cellIndex != 0) {
                    int tileIndex = cellIndex < 0 ? this.animatedTiles[-1 * cellIndex - 1] - 1 : cellIndex - 1;
                    g.setClip(x, y, this.cellWidth, this.cellHeight);
                    g.clipRect(clipX, clipY, clipWidth, clipHeight);
                    int tileColumn = tileIndex % this.numberOfColumns;
                    int tileRow = tileIndex / this.numberOfColumns;
                    int tileX = x - this.tileXPositions[tileColumn];
                    int tileY = y - this.tileYPositions[tileRow];
                    g.drawImage(this.image, tileX, tileY, 20);
                }
                y += this.cellHeight;
            }
            y = yStart;
            x += this.cellWidth;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    protected int getTileAt(int x, int y) {
        int column = (x - this.xPosition) / this.cellWidth;
        int row = (y - this.yPosition) / this.cellHeight;
        if (column < 0 || column >= this.gridColumns || row < 0 || row >= this.gridRows) {
            return 0;
        }
        return this.grid[column][row];
    }
}

