/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.game;

import de.enough.polish.ui.game.Layer;
import de.enough.polish.ui.game.TiledLayer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite
extends Layer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    private Image image;
    private int refPixelX;
    private int refPixelY;
    private int frameSequenceIndex;
    private int[] frameSequence;
    private int transform;
    private int collisionX;
    private int collisionY;
    private int collisionWidth;
    private int collisionHeight;
    private int transformedCollisionX;
    private int transformedCollisionY;
    private int transformedCollisionWidth;
    private int transformedCollisionHeight;
    private int frameHeight;
    private int frameWidth;
    private int rawFrameCount;
    private boolean isSingleFrame;
    private int transformedRefX;
    private int transformedRefY;
    private int numberOfColumns;
    private int column;
    private int row;

    public Sprite(Image image) {
        this.setImage(image, image.getWidth(), image.getHeight());
    }

    public Sprite(Image image, int frameWidth, int frameHeight) {
        this.setImage(image, frameWidth, frameHeight);
    }

    public Sprite(Sprite s) {
        this.image = s.image;
        this.frameWidth = s.frameWidth;
        this.frameHeight = s.frameHeight;
        this.numberOfColumns = s.numberOfColumns;
        this.width = s.width;
        this.height = s.height;
        this.xPosition = s.xPosition;
        this.yPosition = s.yPosition;
        this.frameSequenceIndex = s.frameSequenceIndex;
        if (s.frameSequence != null) {
            this.frameSequence = new int[s.frameSequence.length];
            System.arraycopy(s.frameSequence, 0, this.frameSequence, 0, this.frameSequence.length);
        }
        this.refPixelX = s.refPixelX;
        this.refPixelY = s.refPixelY;
        this.transformedRefX = s.transformedRefX;
        this.transformedRefY = s.transformedRefY;
        this.transform = s.transform;
        this.collisionX = s.collisionX;
        this.collisionY = s.collisionY;
        this.collisionWidth = s.collisionWidth;
        this.collisionHeight = s.collisionHeight;
        this.transformedCollisionX = s.transformedCollisionX;
        this.transformedCollisionY = s.transformedCollisionY;
        this.transformedCollisionWidth = s.transformedCollisionWidth;
        this.transformedCollisionHeight = s.transformedCollisionHeight;
        this.isSingleFrame = s.isSingleFrame;
    }

    public void defineReferencePixel(int refX, int refY) {
        this.refPixelX = refX;
        this.refPixelY = refY;
        this.applyTransform();
    }

    public void setRefPixelPosition(int x, int y) {
        this.xPosition = x - this.transformedRefX;
        this.yPosition = y - this.transformedRefY;
    }

    public int getRefPixelX() {
        return this.transformedRefX + this.xPosition;
    }

    public int getRefPixelY() {
        return this.transformedRefY + this.yPosition;
    }

    public void setFrame(int sequenceIndex) {
        this.frameSequenceIndex = sequenceIndex;
        this.updateFrame();
    }

    public final int getFrame() {
        return this.frameSequenceIndex;
    }

    public int getRawFrameCount() {
        return this.rawFrameCount;
    }

    public int getFrameSequenceLength() {
        if (this.frameSequence == null) {
            return this.rawFrameCount;
        }
        return this.frameSequence.length;
    }

    public void nextFrame() {
        ++this.frameSequenceIndex;
        if (this.frameSequenceIndex >= this.getFrameSequenceLength()) {
            this.frameSequenceIndex = 0;
        }
        this.updateFrame();
    }

    public void prevFrame() {
        --this.frameSequenceIndex;
        if (this.frameSequenceIndex < 0) {
            this.frameSequenceIndex = this.getFrameSequenceLength() - 1;
        }
        this.updateFrame();
    }

    private void updateFrame() {
        int frameIndex = this.frameSequence == null ? this.frameSequenceIndex : this.frameSequence[this.frameSequenceIndex];
        int c = frameIndex % this.numberOfColumns;
        int r = frameIndex / this.numberOfColumns;
        int numberOfRows = this.rawFrameCount / this.numberOfColumns;
        this.column = c;
        this.row = r;
        switch (this.transform) {
            case 0: {
                this.column = c;
                this.row = r;
                break;
            }
            case 1: {
                this.column = c;
                this.row = numberOfRows - 1 - r;
                break;
            }
            case 2: {
                this.column = this.numberOfColumns - 1 - c;
                this.row = r;
                break;
            }
            case 3: {
                this.column = this.numberOfColumns - 1 - c;
                this.row = numberOfRows - 1 - r;
                break;
            }
            case 4: {
                this.column = c;
                this.row = r;
                break;
            }
            case 5: {
                this.column = numberOfRows - 1 - r;
                this.row = c;
                break;
            }
            case 6: {
                this.column = r;
                this.row = this.numberOfColumns - 1 - c;
                break;
            }
            case 7: {
                this.row = numberOfRows - 1 - r;
                this.row = this.numberOfColumns - 1 - c;
            }
        }
    }

    public final void paint(Graphics g) {
        if (this.isSingleFrame && this.transform == 0) {
            g.drawImage(this.image, this.xPosition, this.yPosition, 20);
            return;
        }
        if (this.rawFrameCount == 1) {
            g.drawImage(this.image, this.xPosition, this.yPosition, 20);
        } else {
            int x = this.xPosition;
            int y = this.yPosition;
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            g.clipRect(x, y, this.width, this.height);
            g.drawImage(this.image, x -= this.column * this.width, y -= this.row * this.height, 20);
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    public void setFrameSequence(int[] sequence) {
        int frameIndex = 0;
        this.frameSequence = null;
        if (sequence != null) {
            int[] newSequence = new int[sequence.length];
            System.arraycopy(sequence, 0, newSequence, 0, sequence.length);
            this.frameSequence = newSequence;
            frameIndex = this.frameSequence[0];
        }
        this.frameSequenceIndex = 0;
        this.column = frameIndex % this.numberOfColumns;
        this.row = frameIndex / this.numberOfColumns;
    }

    public void setImage(Image image, int frameWidth, int frameHeight) {
        this.image = image;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.numberOfColumns = image.getWidth() / frameWidth;
        int rows = image.getHeight() / frameHeight;
        int oldRawFrameCount = this.rawFrameCount;
        this.rawFrameCount = this.numberOfColumns * rows;
        boolean bl = this.isSingleFrame = this.rawFrameCount == 1;
        if (this.rawFrameCount < oldRawFrameCount) {
            this.frameSequenceIndex = 0;
            this.frameSequence = null;
            this.column = 0;
            this.row = 0;
        } else {
            int frameIndex = this.frameSequence == null ? this.frameSequenceIndex : this.frameSequence[this.frameSequenceIndex];
            this.column = frameIndex % this.numberOfColumns;
            this.column = frameIndex / this.numberOfColumns;
        }
        this.collisionX = 0;
        this.collisionY = 0;
        this.collisionWidth = frameWidth;
        this.collisionHeight = frameHeight;
        int oldRefX = this.transformedRefX;
        int oldRefY = this.transformedRefY;
        this.applyTransform();
        this.xPosition += oldRefX - this.transformedRefX;
        this.yPosition += oldRefY - this.transformedRefY;
    }

    public void defineCollisionRectangle(int leftX, int topY, int cWidth, int cHeight) {
        this.collisionX = leftX;
        this.collisionY = topY;
        this.collisionWidth = cWidth;
        this.collisionHeight = cHeight;
        this.applyTransform();
    }

    private void applyTransform() {
        int colY;
        int refY;
        int colX;
        int refX;
        if ((this.transform & 2) == 0) {
            refX = this.refPixelX;
            colX = this.collisionX;
        } else {
            refX = this.frameWidth - this.refPixelX;
            colX = this.frameWidth - (this.collisionX + this.collisionWidth);
        }
        if ((this.transform & 1) == 0) {
            refY = this.refPixelY;
            colY = this.collisionY;
        } else {
            refY = this.frameHeight - this.refPixelY;
            colY = this.frameHeight - (this.collisionY + this.collisionHeight);
        }
        if ((this.transform & 4) == 0) {
            this.width = this.frameWidth;
            this.height = this.frameHeight;
            this.transformedRefX = refX;
            this.transformedRefY = refY;
            this.transformedCollisionX = colX;
            this.transformedCollisionY = colY;
            this.transformedCollisionWidth = this.collisionWidth;
            this.transformedCollisionHeight = this.collisionHeight;
        } else {
            this.width = this.frameHeight;
            this.height = this.frameWidth;
            this.transformedRefX = refY;
            this.transformedRefY = refX;
            this.transformedCollisionX = colY;
            this.transformedCollisionY = colX;
            this.transformedCollisionWidth = this.collisionHeight;
            this.transformedCollisionHeight = this.collisionWidth;
        }
    }

    public void setTransform(int transform) {
        this.transform = transform;
        int oldRefX = this.transformedRefX;
        int oldRefY = this.transformedRefY;
        this.applyTransform();
        this.xPosition += oldRefX - this.transformedRefX;
        this.yPosition += oldRefY - this.transformedRefY;
        if (this.rawFrameCount > 1) {
            this.updateFrame();
        }
    }

    public final boolean collidesWith(Sprite s, boolean pixelLevel) {
        if (!this.isVisible || !s.isVisible) {
            return false;
        }
        int enemyX = s.xPosition + s.transformedCollisionX;
        int enemyY = s.yPosition + s.transformedCollisionY;
        return this.collidesWith(enemyX, enemyY, s.transformedCollisionWidth, s.transformedCollisionHeight);
    }

    public final boolean collidesWith(TiledLayer t, boolean pixelLevel) {
        if (!this.isVisible || !t.isVisible) {
            return false;
        }
        int tileWidth = t.cellWidth;
        int tileHeight = t.cellHeight;
        int cXStart = this.xPosition + this.transformedCollisionX;
        int cXEnd = cXStart + this.transformedCollisionWidth;
        int cYStart = this.yPosition + this.transformedCollisionY;
        int cYEnd = cYStart + this.transformedCollisionHeight;
        int y = cYStart;
        for (int x = cXStart; x <= cXEnd; x += tileWidth) {
            while (y <= cYEnd) {
                int tile = t.getTileAt(x, y);
                if (tile != 0) {
                    return true;
                }
                y += tileHeight;
            }
            y = cYStart;
        }
        return false;
    }

    public final boolean collidesWith(Image img, int leftX, int topY, boolean pixelLevel) {
        return this.collidesWith(leftX, topY, img.getWidth(), img.getHeight());
    }

    private boolean collidesWith(int enemyX, int enemyY, int enemyWidth, int enemyHeight) {
        int cXStart = this.xPosition + this.transformedCollisionX;
        int cXEnd = cXStart + this.transformedCollisionWidth;
        int cYStart = this.yPosition + this.transformedCollisionY;
        int cYEnd = cYStart + this.transformedCollisionHeight;
        return cYEnd > enemyY && cYStart < enemyY + enemyHeight && cXEnd > enemyX && cXStart < enemyX + enemyWidth;
    }
}

