/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.StringItem;
import de.enough.polish.util.WrappedText;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class TextContainerView
extends ContainerView {
    private int[] textXOffsets;
    private Background focusedBackground;
    private Border focusedBorder;

    protected void initContent(Item parentContainerItem, int firstLineWidth, int availWidth, int availHeight) {
        Container parent = (Container)parentContainerItem;
        this.focusedIndex = parent.getFocusedIndex();
        Item focItem = parent.getFocusedItem();
        if (focItem != this.focusedItem) {
            this.focusedItem = focItem;
        }
        this.parentContainer = parent;
        Item[] myItems = parent.getItems();
        int myItemsLastIndex = myItems.length - 1;
        int currentX = 0;
        int currentY = 0;
        int maxCurrentX = availWidth - availWidth / 10;
        this.textXOffsets = new int[myItemsLastIndex + 1];
        int lastLineHeight = 0;
        boolean isInteractive = false;
        for (int i = 0; i <= myItemsLastIndex; ++i) {
            Item item = myItems[i];
            boolean bl = isInteractive = isInteractive || item.isInteractive();
            if (!(item instanceof StringItem)) continue;
            StringItem stringItem = (StringItem)item;
            stringItem.relativeY = currentY;
            stringItem.relativeX = 0;
            int width = stringItem.getItemWidth(availWidth - currentX, availWidth);
            WrappedText wrappedText = stringItem.getWrappedText();
            int lineHeight = stringItem.getLineHeight();
            if (wrappedText.size() <= 1) {
                stringItem.relativeX = currentX;
                if (currentX + width < maxCurrentX) {
                    currentX += width;
                } else {
                    currentX = 0;
                    currentY += stringItem.itemHeight;
                }
                if (i == myItemsLastIndex) {
                    currentY += lineHeight + stringItem.getPaddingBottom();
                }
            } else {
                if (currentX > 0) {
                    if (wrappedText.getLineWidth(0) > availWidth - currentX) {
                        currentX = 0;
                        currentY += lastLineHeight;
                        stringItem.relativeY += lastLineHeight;
                    }
                    this.textXOffsets[i] = currentX;
                }
                currentY += stringItem.itemHeight;
                int lastLineWidth = stringItem.getMarginLeft() + stringItem.getPaddingLeft() + wrappedText.getLineWidth(wrappedText.size() - 1) + stringItem.getPaddingRight() + stringItem.getMarginRight();
                if (i != myItemsLastIndex && lastLineWidth < maxCurrentX) {
                    currentX = lastLineWidth;
                    if (wrappedText.size() > 1) {
                        currentY -= lineHeight + stringItem.getPaddingBottom() + stringItem.getMarginBottom();
                    }
                } else {
                    currentX = 0;
                }
            }
            lastLineHeight = lineHeight + stringItem.getPaddingBottom() + stringItem.getMarginBottom();
        }
        this.appearanceMode = isInteractive ? 3 : 0;
        this.contentHeight = currentY;
        this.contentWidth = availWidth;
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        Item focItem;
        int[] offsets = this.textXOffsets;
        for (int i = 0; i < myItems.length; ++i) {
            if (i == this.focusedIndex) continue;
            Item item = myItems[i];
            int itemX = x + item.relativeX;
            int itemY = y + item.relativeY;
            if (itemY > clipY + clipHeight) break;
            if (itemY + item.itemHeight < clipY) continue;
            this.paintItem(item, i, itemX, itemY, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, offsets, g);
        }
        if ((focItem = this.focusedItem) != null) {
            this.paintItem(focItem, this.focusedIndex, x += focItem.relativeX, y += focItem.relativeY, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, offsets, g);
        }
    }

    protected void paintItem(Item item, int index, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, int[] offsets, Graphics g) {
        if (item.relativeX != 0 || ((StringItem)item).getNumberOfLines() <= 1) {
            item.paint(x, y, leftBorder, rightBorder, g);
        } else {
            Background background = this.removeItemBackground(item);
            Border border = this.removeItemBorder(item);
            int xAdjust = offsets[index];
            if (background != null || border != null) {
                int backgroundWidth = rightBorder - leftBorder;
                int topLineHeight = 0;
                int bottomLineHeight = 0;
                int bottomLineWidth = item.itemWidth;
                int bodyHeight = item.itemHeight;
                if (item instanceof StringItem) {
                    StringItem stringItem = (StringItem)item;
                    WrappedText wrappedText = stringItem.getWrappedText();
                    if (xAdjust > 0 && wrappedText.size() > 1) {
                        topLineHeight = stringItem.getMarginTop() + stringItem.getPaddingTop() + stringItem.getLineHeight();
                    }
                    if ((bottomLineWidth = stringItem.getMarginLeft() + stringItem.getPaddingLeft() + wrappedText.getLineWidth(wrappedText.size() - 1) + stringItem.getPaddingRight() + stringItem.getMarginRight()) < backgroundWidth - backgroundWidth / 10) {
                        bottomLineHeight = stringItem.getMarginBottom() + stringItem.getPaddingBottom() + stringItem.getLineHeight();
                    }
                    bodyHeight -= topLineHeight + bottomLineHeight;
                    if (wrappedText.size() == 1) {
                        backgroundWidth = item.itemWidth;
                    }
                }
                if (topLineHeight > 0) {
                    g.clipRect(x + xAdjust, y, backgroundWidth - xAdjust, topLineHeight);
                    if (background != null) {
                        background.paint(x, y, backgroundWidth, item.itemHeight, g);
                    }
                    if (border != null) {
                        border.paint(x + xAdjust, y, backgroundWidth - xAdjust, item.itemHeight, g);
                    }
                    g.setClip(clipX, clipY, clipWidth, clipHeight);
                }
                g.clipRect(x, y + topLineHeight, backgroundWidth, bodyHeight);
                if (background != null) {
                    background.paint(x, y, backgroundWidth, item.itemHeight, g);
                }
                if (border != null) {
                    border.paint(x, y, backgroundWidth, item.itemHeight, g);
                    if (topLineHeight != 0) {
                        g.clipRect(x, y + topLineHeight, xAdjust + border.getBorderWidthRight(), bodyHeight);
                        border.paint(x, y + topLineHeight, backgroundWidth, bodyHeight + bottomLineHeight, g);
                    }
                    if (bottomLineHeight != 0) {
                        if (topLineHeight != 0) {
                            g.setClip(clipX, clipY, clipWidth, clipHeight);
                        }
                        g.clipRect(x + bottomLineWidth - border.getBorderWidthLeft(), y + topLineHeight + bodyHeight - border.getBorderWidthBottom(), backgroundWidth - bottomLineWidth, bodyHeight);
                        border.paint(x + bottomLineWidth - 2, y, backgroundWidth - bottomLineWidth + 2, topLineHeight + bodyHeight, g);
                    }
                }
                g.setClip(clipX, clipY, clipWidth, clipHeight);
                if (bottomLineHeight > 0) {
                    g.clipRect(x, y + topLineHeight + bodyHeight, bottomLineWidth, bottomLineHeight);
                    if (background != null) {
                        background.paint(x, y, backgroundWidth, item.itemHeight, g);
                    }
                    if (border != null) {
                        border.paint(x, y, bottomLineWidth, item.itemHeight, g);
                    }
                    g.setClip(clipX, clipY, clipWidth, clipHeight);
                }
                if (border != null) {
                    int borderWidthLeft = border.getBorderWidthLeft();
                    x += borderWidthLeft;
                    leftBorder += borderWidthLeft;
                    rightBorder -= borderWidthLeft + border.getBorderWidthRight();
                }
            }
            item.paint(x += xAdjust, y, leftBorder, rightBorder, g);
            this.addItemBackgroundBorder(item, background, border);
        }
    }

    protected int getChildHeight(Item item) {
        int index = this.parentContainer.indexOf(item);
        int availWidth = item.getAvailableWidth();
        int h = item.getItemHeight(availWidth - this.textXOffsets[index] - item.relativeX, availWidth, item.getAvailableHeight());
        return h;
    }

    protected int getChildWidth(Item item) {
        int index = this.parentContainer.indexOf(item);
        int availWidth = item.getAvailableWidth();
        int w = item.getItemWidth(availWidth - this.textXOffsets[index] - item.relativeX, availWidth, item.getAvailableHeight());
        return w;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.focusedBackground = (Background)Serializer.deserialize(dataInputStream);
        this.focusedBorder = (Border)Serializer.deserialize(dataInputStream);
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.textXOffsets = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.textXOffsets[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.focusedBackground, dataOutputStream);
        Serializer.serialize(this.focusedBorder, dataOutputStream);
        if (this.textXOffsets == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.textXOffsets.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.textXOffsets[n2]);
                ++n2;
            }
        }
    }
}

