/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.FocusListener;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Point;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TabbedContainerView
extends ContainerView
implements FocusListener {
    public static final int POSITION_TOP = 0;
    public static final int POSITION_BOTTOM = 1;
    private String iconUrl;
    private String iconHoverUrl;
    private int tabbarPosition = 0;
    private Style tabbarStyle;
    private transient Container tabbarContainer;
    private Style tabStyle;
    private boolean isTabbarInitRequired;
    private boolean isRoundtrip = true;

    public TabbedContainerView() {
        this.allowsAutoTraversal = false;
        this.isHorizontal = true;
        this.isVertical = false;
    }

    protected void initContent(Item parentContainerItem, int firstLineWidth, int availWidth, int availHeight) {
        int i;
        Container parent = (Container)parentContainerItem;
        Item[] children = parent.getItems();
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i2 = 0; i2 < children.length; ++i2) {
            Item item = children[i2];
            if (item.getItemWidth(firstLineWidth, availWidth, availHeight) > maxWidth) {
                maxWidth = item.itemWidth;
            }
            if (item.itemHeight <= maxHeight) continue;
            maxHeight = item.itemHeight;
        }
        Container tabbar = this.tabbarContainer;
        if (tabbar == null) {
            tabbar = new Container(false, this.tabbarStyle);
            tabbar.setParent(parent);
            tabbar.setFocusListener(this);
            this.tabbarContainer = tabbar;
        }
        if (tabbar.size() != children.length) {
            tabbar.clear();
            Image img = null;
            if (this.iconUrl != null) {
                try {
                    img = StyleSheet.getImage(this.iconUrl, this, false);
                }
                catch (IOException e) {
                    Debug.debug("error", "de.enough.polish.ui.containerviews.TabbedContainerView", 147, (Object)("Unable to load tabbed-icon " + this.iconUrl), e);
                }
            }
            Image hoverImg = null;
            if (this.iconHoverUrl != null) {
                try {
                    hoverImg = StyleSheet.getImage(this.iconHoverUrl, this, false);
                }
                catch (IOException e) {
                    Debug.debug("error", "de.enough.polish.ui.containerviews.TabbedContainerView", 156, (Object)("Unable to load tabbed-icon-hover " + this.iconHoverUrl), e);
                }
            }
            for (i = 0; i < children.length; ++i) {
                IconItem tab = new IconItem(null, img, this.tabStyle);
                tab.setHoverImage(hoverImg);
                tabbar.add(tab);
            }
            UiAccess.init(tabbar, firstLineWidth, availWidth, availHeight - (maxHeight + this.paddingVertical));
        } else if (this.isTabbarInitRequired) {
            UiAccess.init(tabbar, firstLineWidth, availWidth, availHeight - (maxHeight + this.paddingVertical));
            this.isTabbarInitRequired = false;
        }
        boolean displayTabs = children.length > 1;
        int y = 0;
        if (this.tabbarPosition == 1) {
            tabbar.relativeY = maxHeight + this.paddingVertical;
        } else if (displayTabs) {
            tabbar.relativeY = 0;
            y = tabbar.itemHeight + this.paddingVertical;
        }
        if (displayTabs && maxWidth < tabbar.itemWidth) {
            maxWidth = tabbar.itemWidth;
        }
        tabbar.relativeX = tabbar.isLayoutCenter() ? (maxWidth - tabbar.itemWidth) / 2 : (tabbar.isLayoutRight() ? maxWidth - tabbar.itemWidth : 0);
        for (i = 0; i < children.length; ++i) {
            Item item = children[i];
            item.relativeY = y;
            if (item.itemHeight < maxHeight) {
                if (item.isLayoutVerticalCenter()) {
                    item.relativeY += (maxHeight - item.itemHeight) / 2;
                } else if (item.isLayoutBottom()) {
                    item.relativeY += maxHeight - item.itemHeight;
                }
            }
            item.relativeX = 0;
            if (item.itemWidth >= maxWidth) continue;
            if (item.isLayoutCenter()) {
                item.relativeX = (maxWidth - item.itemWidth) / 2;
                continue;
            }
            if (!item.isLayoutRight()) continue;
            item.relativeX = maxWidth - item.itemWidth;
        }
        int index = this.focusedIndex;
        if (index == -1) {
            index = 0;
        }
        if (index < tabbar.size()) {
            Container rootContainer = this.getScreen().getRootContainer();
            int offset = rootContainer.getScrollYOffset();
            tabbar.focusChild(index);
            rootContainer.setScrollYOffset(offset, false);
        }
        this.contentWidth = maxWidth;
        this.contentHeight = displayTabs ? maxHeight + this.paddingVertical + tabbar.itemHeight : maxHeight;
        this.appearanceMode = 3;
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int index = this.focusedIndex;
        if (index == -1) {
            index = 0;
            if (myItems.length == 0) {
                return;
            }
        }
        if (myItems.length > 1) {
            Container tb = this.tabbarContainer;
            tb.paint(x + tb.relativeX, y + tb.relativeY, x + tb.relativeX, x + tb.relativeX + tb.itemWidth, g);
        }
        Item item = myItems[index];
        this.paintItem(item, index, x + item.relativeX, y + item.relativeY, x, x + item.relativeX + item.itemWidth, clipX, clipY, clipWidth, clipHeight, g);
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    public boolean handlePointerPressed(int x, int y) {
        Point p = this.adjustToContentArea(x, y);
        Container tabbar = this.tabbarContainer;
        boolean handled = UiAccess.handlePointerPressed(tabbar, p.x - tabbar.relativeX, p.y - tabbar.relativeY);
        return handled || super.handlePointerPressed(x, y);
    }

    public boolean handlePointerReleased(int x, int y) {
        Point p = this.adjustToContentArea(x, y);
        Container tabbar = this.tabbarContainer;
        boolean handled = UiAccess.handlePointerReleased(tabbar, p.x - tabbar.relativeX, p.y - tabbar.relativeY);
        return handled || super.handlePointerReleased(x, y);
    }

    public boolean handlePointerDragged(int x, int y, ClippingRegion repaintRegion) {
        Point p = this.adjustToContentArea(x, y);
        Container tabbar = this.tabbarContainer;
        boolean handled = UiAccess.handlePointerDragged(tabbar, p.x - tabbar.relativeX, p.y - tabbar.relativeY, repaintRegion);
        return handled || super.handlePointerDragged(x, y, repaintRegion);
    }

    protected Item getNextItem(int keyCode, int gameAction) {
        Item next = super.getNextItem(keyCode, gameAction);
        if (next != null) {
            this.tabbarContainer.focusChild(this.focusedIndex);
        }
        return next;
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        this.tabbarContainer.animate(currentTime, repaintRegion);
        super.animate(currentTime, repaintRegion);
    }

    public void onFocusChanged(Container parent, Item focItem, int focIndex) {
        if (focIndex != -1 && focIndex != this.focusedIndex) {
            this.parentContainer.focusChild(focIndex, focItem, 0, false);
        }
    }

    protected void onScreenSizeChanged(int screenWidth, int screenHeight) {
        super.onScreenSizeChanged(screenWidth, screenHeight);
        this.isTabbarInitRequired = true;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.iconHoverUrl = (String)Serializer.deserialize(dataInputStream);
        this.iconUrl = (String)Serializer.deserialize(dataInputStream);
        this.isRoundtrip = dataInputStream.readBoolean();
        this.isTabbarInitRequired = dataInputStream.readBoolean();
        this.tabStyle = (Style)Serializer.deserialize(dataInputStream);
        this.tabbarPosition = dataInputStream.readInt();
        this.tabbarStyle = (Style)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.iconHoverUrl, dataOutputStream);
        Serializer.serialize(this.iconUrl, dataOutputStream);
        dataOutputStream.writeBoolean(this.isRoundtrip);
        dataOutputStream.writeBoolean(this.isTabbarInitRequired);
        Serializer.serialize(this.tabStyle, dataOutputStream);
        dataOutputStream.writeInt(this.tabbarPosition);
        Serializer.serialize(this.tabbarStyle, dataOutputStream);
    }
}

