/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.util.ArrayList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class RelativeLayoutView
extends ContainerView {
    private static final int LAYOUT_HORIZONTAL = 3;
    private static final int LAYOUT_VERTICAL = 48;
    private ArrayList allRows;
    private ArrayList currentRow;
    private int rowWidth;
    private int rowHeight;
    private int horizontalOffset = -1;
    private int currentContentHeight;

    protected void initContent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        Container parContainer;
        this.parentContainer = parContainer = (Container)parent;
        Item[] myItems = parContainer.getItems();
        this.rowHeight = 0;
        this.rowWidth = 0;
        this.contentWidth = 0;
        this.contentHeight = 0;
        this.currentRow = new ArrayList();
        this.allRows = new ArrayList();
        boolean hasFocusableItem = false;
        this.currentContentHeight = 0;
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            if (item.appearanceMode != 0) {
                hasFocusableItem = true;
            }
            this.appendItemToRow(i, item, firstLineWidth, availWidth, availHeight);
        }
        this.rowBreak(availWidth, availHeight, 0);
        this.appearanceMode = !hasFocusableItem ? 0 : 3;
    }

    void appendItemToRow(int index, Item item, int firstLineWidth, int availWidth, int availHeight) {
        boolean isExpand;
        int itemLayout = item.getLayout();
        boolean bl = isExpand = (itemLayout & 0x800) == 2048;
        if (isExpand) {
            item.setLayout(itemLayout ^ 0x800);
        }
        if (this.focusFirstElement && item.appearanceMode != 0) {
            this.focusItem(index, item);
            this.focusFirstElement = false;
        }
        int width = item.getItemWidth(firstLineWidth, availWidth, availHeight);
        int height = item.getItemHeight(firstLineWidth, availWidth, availHeight);
        if (isExpand) {
            item.setLayout(itemLayout);
        }
        if (256 == (itemLayout & 0x100) || isExpand || this.rowWidth + this.paddingHorizontal + width > availWidth) {
            this.rowBreak(availWidth, availHeight, itemLayout);
        }
        this.rowWidth += width;
        if (this.currentRow.size() == 0) {
            this.rowHeight = height;
        } else {
            if (this.rowHeight < height) {
                this.rowHeight = height;
            }
            this.rowWidth += this.paddingHorizontal;
        }
        this.currentRow.add(item);
        if (512 == (itemLayout & 0x200)) {
            this.rowBreak(availWidth, availHeight, itemLayout);
        }
    }

    private void rowBreak(int lineWidth, int availHeight, int itemLayout) {
        if (this.currentRow.size() == 0) {
            return;
        }
        int remainingWidth = lineWidth - (this.currentRow.size() - 1) * this.paddingHorizontal;
        boolean requiredExpandedIndex = false;
        int top = this.currentContentHeight;
        int bottom = top + this.rowHeight;
        this.currentContentHeight += this.rowHeight + this.paddingVertical;
        int currentWidth = 0;
        for (int i = 0; i < this.currentRow.size(); ++i) {
            Item rowItem = (Item)this.currentRow.get(i);
            rowItem.relativeY = top;
            rowItem.relativeX = currentWidth;
            if (2048 == (itemLayout & 0x800)) {
                rowItem.getItemWidth(lineWidth - currentWidth, lineWidth - currentWidth, availHeight);
            }
            currentWidth += rowItem.itemWidth;
            remainingWidth -= rowItem.itemWidth;
        }
        Item rowItem = (Item)this.currentRow.get(0);
        int rowHorizontalLayout = itemLayout & 3;
        int x = 0;
        switch (rowHorizontalLayout) {
            case 3: {
                x = remainingWidth >> 1;
                break;
            }
            case 2: {
                x = remainingWidth;
            }
        }
        block9: for (int i = 0; i < this.currentRow.size(); ++i) {
            rowItem = (Item)this.currentRow.get(i);
            rowItem.relativeX = x;
            x += rowItem.itemWidth + this.paddingHorizontal;
            if (8192 != (itemLayout & 0x2000)) continue;
            rowItem.relativeY = this.contentHeight;
            if (8192 == (itemLayout & 0x2000)) continue;
            switch (itemLayout &= 0x30) {
                case 48: {
                    rowItem.relativeY += this.rowHeight - rowItem.itemHeight >> 1;
                    continue block9;
                }
                case 32: {
                    rowItem.relativeY += this.rowHeight - rowItem.itemHeight;
                }
            }
        }
        this.contentHeight = this.allRows.size() == 0 ? (this.contentHeight += this.rowHeight) : (this.contentHeight += this.paddingVertical + this.rowHeight);
        if (this.rowWidth > this.contentWidth) {
            this.contentWidth = this.rowWidth;
        }
        this.allRows.add(this.currentRow);
        this.rowWidth = 0;
        this.rowHeight = 0;
        this.currentRow = new ArrayList();
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        for (int i = 0; i < this.allRows.size(); ++i) {
            ArrayList row = (ArrayList)this.allRows.get(i);
            for (int j = 0; j < row.size(); ++j) {
                Item rowItem = (Item)row.get(j);
                int xItem = x + rowItem.relativeX;
                this.paintItem(rowItem, i, xItem, y + rowItem.relativeY, Math.max(leftBorder, xItem), Math.min(rightBorder, xItem + rowItem.itemWidth), clipX, clipY, clipWidth, clipHeight, g);
            }
        }
    }

    protected Item getNextItem(int keyCode, int gameAction) {
        Item item;
        block20: {
            Item[] items;
            block21: {
                if (this.allRows.size() == 0) {
                    return null;
                }
                items = this.parentContainer.getItems();
                if (this.focusedIndex >= items.length) {
                    for (int i = 0; i < items.length; ++i) {
                        if (items[i].appearanceMode == 0) continue;
                        this.focusItem(i, items[i], gameAction);
                        return items[i];
                    }
                }
                Item focusedItem = items[this.focusedIndex];
                int rowIndex = 0;
                int xOffset = 0;
                block1: for (int i = 0; i < this.allRows.size(); ++i) {
                    ArrayList row = (ArrayList)this.allRows.get(i);
                    for (int j = 0; j < row.size(); ++j) {
                        Item rowItem = (Item)row.get(j);
                        if (rowItem != focusedItem) continue;
                        rowIndex = i;
                        xOffset = rowItem.relativeX + (rowItem.itemWidth >> 1);
                        i = 10000;
                        continue block1;
                    }
                }
                item = null;
                if (gameAction == 1 && keyCode != 50) {
                    if (this.horizontalOffset == -1) {
                        this.horizontalOffset = xOffset;
                    }
                    while (rowIndex > 0 && (item = this.getItemByHorizontalOffset((ArrayList)this.allRows.get(--rowIndex), this.horizontalOffset)) == null) {
                    }
                    if (item == null) {
                        // empty if block
                    }
                } else if (gameAction == 6 && keyCode != 56) {
                    if (this.horizontalOffset == -1) {
                        this.horizontalOffset = xOffset;
                    }
                    while (rowIndex < this.allRows.size() - 1 && (item = this.getItemByHorizontalOffset((ArrayList)this.allRows.get(++rowIndex), this.horizontalOffset)) == null) {
                    }
                    if (item == null) {
                        // empty if block
                    }
                } else if (gameAction == 5 && keyCode != 54) {
                    this.horizontalOffset = -1;
                    item = this.getNextFocusableItem(items, true, 1, false);
                } else if (gameAction == 2 && keyCode != 52) {
                    this.horizontalOffset = -1;
                    item = this.getNextFocusableItem(items, false, 1, false);
                }
                if (item == null) break block21;
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] != item) continue;
                    this.focusItem(i, item, gameAction);
                    break block20;
                }
                break block20;
            }
            if (this.focusedIndex < items.length) break block20;
            for (int i = 0; i < items.length; ++i) {
                Item focItem = items[i];
                if (focItem.appearanceMode == 0) continue;
                this.focusItem(i, focItem, gameAction);
                return focItem;
            }
        }
        return item;
    }

    private Item getItemByHorizontalOffset(ArrayList row, int xOffset) {
        Item item = null;
        Item rowItem = null;
        int distance = 60000;
        int itemOffset = 0;
        int itemDistance = 0;
        for (int i = 0; i < row.size(); ++i) {
            rowItem = (Item)row.get(i);
            if (rowItem.appearanceMode == 0) continue;
            itemOffset = rowItem.relativeX + (rowItem.itemWidth >> 1);
            itemDistance = xOffset - itemOffset;
            if (itemDistance < 0) {
                itemDistance = -itemDistance;
            }
            if (itemDistance >= distance) continue;
            distance = itemDistance;
            item = rowItem;
        }
        return item;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.allRows = (ArrayList)Serializer.deserialize(dataInputStream);
        this.currentContentHeight = dataInputStream.readInt();
        this.currentRow = (ArrayList)Serializer.deserialize(dataInputStream);
        this.horizontalOffset = dataInputStream.readInt();
        this.rowHeight = dataInputStream.readInt();
        this.rowWidth = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.allRows, dataOutputStream);
        dataOutputStream.writeInt(this.currentContentHeight);
        Serializer.serialize(this.currentRow, dataOutputStream);
        dataOutputStream.writeInt(this.horizontalOffset);
        dataOutputStream.writeInt(this.rowHeight);
        dataOutputStream.writeInt(this.rowWidth);
    }
}

