/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Item;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Midp2ContainerView
extends ContainerView {
    Dimension contentX;

    protected void initContent(Item parentContainerItem, int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(parentContainerItem, firstLineWidth, availWidth, availHeight);
        Item[] items = this.parentContainer.getItems();
        this.initContent(items, firstLineWidth, availWidth, availHeight);
    }

    public void initContent(Item[] items, int firstLineWidth, int availWidth, int availHeight) {
        int x = 0;
        int y = 0;
        int currentRowHeight = 0;
        int currentRowStartIndex = 0;
        int maxRowWidth = 0;
        int availRowWidth = firstLineWidth;
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            int lo = item.getLayout();
            if ((lo & 0x100) == 256 || x + item.getContentWidth() > availRowWidth) {
                if (currentRowHeight != 0) {
                    this.addLineBreak(items, currentRowStartIndex, i - 1, x, currentRowHeight, availRowWidth);
                    y += currentRowHeight + this.paddingVertical;
                    currentRowHeight = 0;
                    availRowWidth = availWidth;
                }
                if (x > maxRowWidth) {
                    maxRowWidth = x;
                }
                x = 0;
                currentRowStartIndex = i;
            }
            item.relativeX = x;
            item.relativeY = y;
            if (item.itemWidth > availRowWidth) {
                item.getItemWidth(availRowWidth - x, availRowWidth - x, availHeight);
            }
            x += item.itemWidth;
            if (item.itemHeight > currentRowHeight) {
                currentRowHeight = item.itemHeight;
            }
            if (x < availRowWidth && (lo & 0x200) != 512 && i != items.length - 1) continue;
            if (currentRowHeight != 0) {
                this.addLineBreak(items, currentRowStartIndex, i, x, currentRowHeight, availRowWidth);
                y += currentRowHeight + this.paddingVertical;
                currentRowHeight = 0;
                availRowWidth = availWidth;
            }
            if (x > maxRowWidth) {
                maxRowWidth = x;
            }
            x = 0;
            currentRowStartIndex = i + 1;
        }
        if (x != 0) {
            if (currentRowHeight != 0) {
                this.addLineBreak(items, currentRowStartIndex, items.length - 1, x, currentRowHeight, availRowWidth);
                y += currentRowHeight;
                availRowWidth = availWidth;
            }
            if (x > maxRowWidth) {
                maxRowWidth = x;
            }
        }
        this.contentHeight = y;
        this.contentWidth = maxRowWidth;
    }

    protected void addLineBreak(Item[] items, int currentRowStartIndex, int currentRowEndIndex, int currentRowWidth, int currentRowHeight, int availWidth) {
        int diff = 0;
        if (this.isLayoutCenter) {
            diff = (availWidth - currentRowWidth) / 2;
        } else if (this.isLayoutRight) {
            diff = availWidth - currentRowWidth;
        }
        for (int i = currentRowStartIndex; i <= currentRowEndIndex; ++i) {
            Item item = items[i];
            int lo = item.getLayout();
            if ((lo & 0x30) == 48) {
                item.relativeY += (currentRowHeight - item.itemHeight) / 2;
            } else if ((lo & 0x20) == 32) {
                item.relativeY += currentRowHeight - item.itemHeight;
            }
            item.relativeX += diff;
            if (i != currentRowEndIndex || (lo & 2) != 2) continue;
            item.relativeX = availWidth - item.itemWidth;
        }
    }

    public void paintContent(Item[] items, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        super.paintContent(null, items, x, y, leftBorder, rightBorder, g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight(), g);
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.contentX = (Dimension)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.contentX, dataOutputStream);
    }
}

