/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.containerviews.HorizontalContainerView;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class LeftHorizontalContainerView
extends HorizontalContainerView {
    private int[] xSlots;

    protected void initContent(Item parentItm, int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(parentItm, firstLineWidth, availWidth, availHeight);
        Item[] myItems = this.parentContainer.getItems();
        this.xSlots = new int[myItems.length];
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            this.xSlots[i] = item.relativeX;
        }
        if (this.focusedItem != null) {
            this.focusItem(this.focusedIndex, this.focusedItem, 0, this.focusedItem.getStyle());
        }
    }

    public Style focusItem(int focIndex, Item item, int direction, Style focStyle) {
        int prevFocIndex = this.focusedIndex;
        Style result = super.focusItem(focIndex, item, direction, focStyle);
        if (this.xSlots != null) {
            Item[] myItems = this.parentContainer.getItems();
            int startX = this.contentWidth;
            for (int i = 0; i < myItems.length; ++i) {
                Item myItem = myItems[i];
                myItem.relativeX = i < focIndex ? startX + this.xSlots[i] : this.xSlots[i];
            }
            if (item != null) {
                if (focIndex < prevFocIndex && this.targetXOffset != this.xSlots[focIndex]) {
                    this.setScrollXOffset(this.availableWidth + this.xOffset, false);
                }
                this.setScrollXOffset(-item.relativeX, true);
            }
        }
        return result;
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        super.paintContent(container, myItems, x, y, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
        if (this.xOffset != this.targetXOffset) {
            g.clipRect(x, y, rightBorder - x + 1, this.contentHeight + 1);
            int index = this.focusedIndex - 1;
            if (index < 0) {
                index = myItems.length - 1;
                x -= this.contentWidth;
            }
            Item item = myItems[index];
            item.paint(x += this.xOffset + this.xSlots[index], y, x, x + item.itemWidth, g);
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    public void startScroll(int direction, int speed, int damping) {
        if (direction == 1 || direction == 6) {
            super.startScroll(direction, speed, damping);
        }
    }

    public boolean handlePointerDragged(int x, int y) {
        return false;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.xSlots = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.xSlots[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        if (this.xSlots == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.xSlots.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.xSlots[n2]);
                ++n2;
            }
        }
    }
}

