/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HorizontalChoiceView
extends ContainerView {
    private static final int DISTRIBUTE_EQUALS = 1;
    private static final int POSITION_BOTH_SIDES = 0;
    private static final int POSITION_RIGHT = 1;
    private static final int POSITION_LEFT = 2;
    private static final int POSITION_NONE = 3;
    private int arrowColor;
    private int arrowWidth = 10;
    private int currentItemIndex;
    private int leftArrowStartX;
    private int leftArrowEndX;
    private int rightArrowStartX;
    private int rightArrowEndX;
    private int pointerReleasedIndex = -1;
    private int contentStart;

    public HorizontalChoiceView() {
        this.allowsAutoTraversal = false;
        this.allowsDirectSelectionByPointerEvent = false;
    }

    protected void initContent(Item parentItm, int firstLineWidth, int availWidth, int availHeight) {
        int itemHeight;
        Item item;
        int i;
        int selectedItemIndex;
        boolean isMultiple;
        Container parent = (Container)parentItm;
        ChoiceGroup choiceGroup = (ChoiceGroup)parent;
        int focIndex = parent.getFocusedIndex();
        boolean bl = isMultiple = choiceGroup.getType() == 2;
        if (!isMultiple) {
            selectedItemIndex = choiceGroup.getSelectedIndex();
            if (selectedItemIndex == -1) {
                selectedItemIndex = 0;
            }
        } else {
            selectedItemIndex = focIndex;
        }
        int height = 0;
        int completeArrowWidth = this.arrowWidth + this.paddingHorizontal << 1;
        int contentStartX = 0;
        this.leftArrowStartX = 0;
        this.leftArrowEndX = this.arrowWidth;
        this.rightArrowStartX = availWidth - this.arrowWidth;
        this.rightArrowEndX = availWidth;
        this.contentStart = contentStartX = this.leftArrowEndX;
        int completeWidth = 0;
        int availItemWidth = availWidth -= completeArrowWidth;
        boolean availItemWidthWithPaddingShift8 = false;
        Item[] items = parent.getItems();
        for (i = 0; i < items.length; ++i) {
            boolean isLast;
            item = items[i];
            ((ChoiceItem)item).drawBox = false;
            itemHeight = item.getItemHeight(availItemWidth, availItemWidth, availHeight);
            int itemWidth = item.itemWidth;
            if (itemHeight > height) {
                height = itemHeight;
            }
            boolean bl2 = isLast = i == items.length - 1;
            if (isLast && item.isLayoutRight() && completeWidth + item.itemWidth < availWidth) {
                completeWidth = availWidth - item.itemWidth;
            }
            item.relativeX = completeWidth + contentStartX;
            item.relativeY = 0;
            int startX = completeWidth;
            completeWidth += itemWidth + this.paddingHorizontal;
            if (i != focIndex) continue;
            if (startX + this.getScrollXOffset() < 0) {
                this.setScrollXOffset(-startX);
                continue;
            }
            if (completeWidth + this.getScrollXOffset() <= availWidth) continue;
            this.setScrollXOffset(availWidth - completeWidth);
        }
        for (i = 0; i < items.length; ++i) {
            item = items[i];
            itemHeight = item.itemHeight;
            if (height <= itemHeight) continue;
            int lo = item.getLayout();
            if ((lo & 0x30) == 48) {
                item.relativeY += (height - item.itemHeight) / 2;
                continue;
            }
            if ((lo & 0x20) != 32) continue;
            item.relativeY += height - item.itemHeight;
        }
        if (completeWidth < availWidth) {
            completeWidth = availWidth;
        }
        this.contentWidth = completeWidth + completeArrowWidth;
        this.contentHeight = height;
        this.appearanceMode = items.length > 0 ? 3 : 0;
        if (selectedItemIndex < items.length && selectedItemIndex != -1) {
            if (this.focusedItem == null) {
                this.focusedItem = items[selectedItemIndex];
                this.focusedIndex = selectedItemIndex;
            }
            this.currentItemIndex = selectedItemIndex;
        }
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int startX;
        boolean setClip;
        int modifiedX = x;
        modifiedX += this.arrowWidth + this.paddingHorizontal;
        boolean bl = setClip = this.contentWidth > (rightBorder -= this.arrowWidth + this.paddingHorizontal) - (leftBorder += this.arrowWidth + this.paddingHorizontal);
        if (setClip) {
            g.clipRect(modifiedX, clipY, rightBorder - modifiedX, clipHeight);
        }
        super.paintContent(container, myItems, x, y, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
        if (setClip) {
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
        g.setColor(this.arrowColor);
        if (this.currentItemIndex > 0) {
            startX = x + this.leftArrowStartX;
            Image image = null;
            int vOffset = 0;
            if (image != null) {
                g.drawImage(image, startX, y + vOffset, 20);
            } else {
                g.fillTriangle(startX, y + this.contentHeight / 2, startX + this.arrowWidth, y, startX + this.arrowWidth, y + this.contentHeight);
            }
        }
        if (this.currentItemIndex < this.parentContainer.size() - 1) {
            startX = x + this.rightArrowStartX;
            g.fillTriangle(startX + this.arrowWidth, y + this.contentHeight / 2, startX, y, startX, y + this.contentHeight);
        }
    }

    protected Item getNextItem(int keyCode, int gameAction) {
        ChoiceGroup choiceGroup = (ChoiceGroup)this.parentContainer;
        Item[] items = this.parentContainer.getItems();
        ChoiceItem currentItem = (ChoiceItem)this.focusedItem;
        int current = this.currentItemIndex;
        if (currentItem == null) {
            current = choiceGroup.getSelectedIndex();
            if (choiceGroup.getType() == 2 && (current = choiceGroup.getFocusedIndex()) == -1) {
                current = 0;
            }
            this.currentItemIndex = current;
            currentItem = (ChoiceItem)items[current];
            this.focusedItem = currentItem;
        }
        ChoiceItem nextItem = null;
        if (gameAction == 2 && this.currentItemIndex > 0) {
            currentItem.select(false);
            nextItem = (ChoiceItem)items[--current];
            choiceGroup.setSelectedIndex(current, true);
            if (this.getScreen() instanceof Form) {
                choiceGroup.notifyStateChanged();
            }
        } else if (gameAction == 5 && current < items.length - 1) {
            currentItem.select(false);
            nextItem = (ChoiceItem)items[++current];
            choiceGroup.setSelectedIndex(current, true);
            if (this.getScreen() instanceof Form) {
                choiceGroup.notifyStateChanged();
            }
        }
        this.currentItemIndex = current;
        return nextItem;
    }

    public boolean handlePointerPressed(int x, int y) {
        if (!this.parentContainer.isInContentArea(x, y)) {
            this.isPointerPressedHandled = false;
        } else {
            boolean isMultiple;
            this.pointerReleasedIndex = -1;
            int index = this.currentItemIndex;
            int size = this.parentContainer.size();
            boolean bl = isMultiple = ((ChoiceGroup)this.parentContainer).getType() == 2;
            if (x >= this.leftArrowStartX && x <= this.leftArrowEndX) {
                if (isMultiple) {
                    this.pointerReleasedIndex = 0;
                    return true;
                }
                if (--index < 0) {
                    index = size - 1;
                }
            } else if (x >= this.rightArrowStartX && x <= this.rightArrowEndX) {
                if (isMultiple) {
                    this.pointerReleasedIndex = 0;
                    return true;
                }
                if (++index >= size) {
                    index = 0;
                }
            } else {
                x -= this.getScrollXOffset();
                for (int i = 0; i < size; ++i) {
                    Item item = this.parentContainer.get(i);
                    if (x < item.relativeX || x > item.relativeX + item.itemWidth) continue;
                    index = i;
                    break;
                }
                x += this.getScrollXOffset();
            }
            if (index != this.currentItemIndex || !isMultiple) {
                this.pointerReleasedIndex = index;
                Item item = this.parentContainer.get(index);
                this.notifyItemPressedStart(item);
                super.handlePointerPressed(x, y);
                return true;
            }
            this.pointerReleasedIndex = -1;
        }
        return super.handlePointerPressed(x, y);
    }

    private Item getItemAt(int x) {
        x -= this.getScrollXOffset() - this.contentStart;
        int size = this.parentContainer.size();
        for (int i = 0; i < size; ++i) {
            Item item = this.parentContainer.get(i);
            if (x < item.relativeX || x > item.relativeX + item.itemWidth) continue;
            return item;
        }
        return null;
    }

    public boolean handlePointerReleased(int x, int y) {
        boolean isMultiple;
        int index = this.pointerReleasedIndex;
        if (index == -1) {
            return super.handlePointerReleased(x, y);
        }
        if (!this.parentContainer.isInContentArea(x, y)) {
            this.pointerReleasedIndex = -1;
            return false;
        }
        super.handlePointerReleased(x, y);
        boolean bl = isMultiple = ((ChoiceGroup)this.parentContainer).getType() == 2;
        if (x >= this.rightArrowStartX && x <= this.rightArrowEndX) {
            if (isMultiple) {
                int target = this.getScrollTargetXOffset();
                if (target + this.contentWidth > this.availableWidth) {
                    int offset;
                    Item mostRightVisibleItem = this.getItemAt(this.availableWidth);
                    if (mostRightVisibleItem != null) {
                        offset = this.contentStart - mostRightVisibleItem.relativeX;
                        int diff = target - offset;
                        if (diff < this.availableWidth / 2) {
                            offset = target - this.availableWidth / 2;
                        }
                    } else {
                        offset = target - this.availableWidth / 2;
                    }
                    if (offset + this.contentWidth < this.availableWidth) {
                        offset = this.availableWidth - this.contentWidth;
                    }
                    this.setScrollXOffset(offset, true);
                    return true;
                }
                return true;
            }
        } else if (x <= this.leftArrowEndX && x >= this.leftArrowStartX && isMultiple) {
            int target = this.getScrollTargetXOffset();
            if (target < 0) {
                int offset;
                Item mostLeftVisibleItem = this.getItemAt(0);
                if (mostLeftVisibleItem != null) {
                    offset = this.contentStart + this.availableWidth - mostLeftVisibleItem.itemWidth - mostLeftVisibleItem.relativeX;
                    int diff = offset - target;
                    if (diff < this.availableWidth / 2) {
                        offset = target + this.availableWidth / 2;
                    }
                } else {
                    offset = target + this.availableWidth / 2;
                }
                if (offset > 0) {
                    offset = 0;
                }
                this.setScrollXOffset(offset, true);
                return true;
            }
            return true;
        }
        this.pointerReleasedIndex = -1;
        ChoiceGroup choiceGroup = (ChoiceGroup)this.parentContainer;
        if (!isMultiple) {
            ChoiceItem choiceItem = (ChoiceItem)this.focusedItem;
            choiceItem.select(false);
        }
        ChoiceItem item = (ChoiceItem)this.parentContainer.get(index);
        this.focusedItem = item;
        this.notifyItemPressedEnd(item);
        this.parentContainer.focusChild(index, item, 0, true);
        if (isMultiple) {
            item.toggleSelect();
        } else {
            choiceGroup.setSelectedIndex(index, !item.isSelected);
        }
        this.parentContainer.notifyStateChanged();
        return true;
    }

    protected void defocus(Style originalStyle) {
        super.defocus(originalStyle);
    }

    public void focus(Style focusstyle, int direction) {
        super.focus(focusstyle, direction);
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof ChoiceGroup;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arrowColor = dataInputStream.readInt();
        this.arrowWidth = dataInputStream.readInt();
        this.contentStart = dataInputStream.readInt();
        this.currentItemIndex = dataInputStream.readInt();
        this.leftArrowEndX = dataInputStream.readInt();
        this.leftArrowStartX = dataInputStream.readInt();
        this.pointerReleasedIndex = dataInputStream.readInt();
        this.rightArrowEndX = dataInputStream.readInt();
        this.rightArrowStartX = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arrowColor);
        dataOutputStream.writeInt(this.arrowWidth);
        dataOutputStream.writeInt(this.contentStart);
        dataOutputStream.writeInt(this.currentItemIndex);
        dataOutputStream.writeInt(this.leftArrowEndX);
        dataOutputStream.writeInt(this.leftArrowStartX);
        dataOutputStream.writeInt(this.pointerReleasedIndex);
        dataOutputStream.writeInt(this.rightArrowEndX);
        dataOutputStream.writeInt(this.rightArrowStartX);
    }
}

