/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class DroppingView
extends ContainerView {
    private static final int START_MAXIMUM = 30;
    private static final int MAX_PERIODE = 5;
    private static final int DEFAULT_DAMPING = 10;
    private boolean isDownwardsAnimation;
    private int damping = 10;
    private int currentPeriode;
    private int maxPeriode = 5;
    private int currentMaximum;
    private int startMaximum = 30;
    private int speed = -1;
    private boolean animationInitialised;
    private boolean isAnimationRunning;
    private int[] yAdjustments;

    protected void initContent(Item parentItm, int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(parentItm, firstLineWidth, availWidth, availHeight);
        Container parent = (Container)parentItm;
        if (!this.animationInitialised) {
            Item[] myItems = parent.getItems();
            this.yAdjustments = new int[myItems.length];
            this.initAnimation(myItems, this.yAdjustments);
        }
    }

    protected void paintItem(Item item, int index, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        super.paintItem(item, index, x, y -= this.yAdjustments[index], leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    private void initAnimation(Item[] items, int[] yValues) {
        this.isDownwardsAnimation = true;
        this.currentMaximum = this.startMaximum * -1;
        this.currentPeriode = 0;
        for (int i = 0; i < yValues.length; ++i) {
            yValues[i] = this.contentHeight;
        }
        this.isAnimationRunning = true;
        this.animationInitialised = true;
    }

    public boolean animate() {
        boolean animated = super.animate();
        if (this.isAnimationRunning) {
            boolean startNextPeriode = true;
            int max = this.currentMaximum;
            int column = 0;
            if (this.isDownwardsAnimation) {
                for (int i = 0; i < this.yAdjustments.length; ++i) {
                    int y = this.yAdjustments[i];
                    if (y > max) {
                        int adjustment = this.speed;
                        if (adjustment == -1 && (adjustment = y / 3) < 10) {
                            adjustment = 10;
                        }
                        if ((y -= adjustment) < max) {
                            y = max;
                        }
                        startNextPeriode = false;
                    }
                    this.yAdjustments[i] = y;
                    if (++column < this.numberOfColumns) continue;
                    if ((max += this.damping) > 0) {
                        max = 0;
                    }
                    column = 0;
                }
            } else {
                for (int i = 0; i < this.yAdjustments.length; ++i) {
                    int y = this.yAdjustments[i];
                    if (y < max) {
                        int adjustment = this.speed;
                        if (adjustment == -1 && (adjustment = y / 3) < 10) {
                            adjustment = 10;
                        }
                        if ((y += adjustment) > max) {
                            y = max;
                        }
                        startNextPeriode = false;
                    }
                    this.yAdjustments[i] = y;
                    if (++column < this.numberOfColumns) continue;
                    if ((max -= this.damping) < 0) {
                        max = 0;
                    }
                    column = 0;
                }
            }
            if (startNextPeriode) {
                ++this.currentPeriode;
                if (this.currentPeriode < this.maxPeriode && this.currentMaximum != 0) {
                    this.currentMaximum = this.currentMaximum * -2 / 3;
                    this.isDownwardsAnimation = !this.isDownwardsAnimation;
                } else {
                    this.isAnimationRunning = false;
                }
            }
            return true;
        }
        return animated;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animationInitialised = dataInputStream.readBoolean();
        this.currentMaximum = dataInputStream.readInt();
        this.currentPeriode = dataInputStream.readInt();
        this.damping = dataInputStream.readInt();
        this.isAnimationRunning = dataInputStream.readBoolean();
        this.isDownwardsAnimation = dataInputStream.readBoolean();
        this.maxPeriode = dataInputStream.readInt();
        this.speed = dataInputStream.readInt();
        this.startMaximum = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.yAdjustments = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.yAdjustments[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animationInitialised);
        dataOutputStream.writeInt(this.currentMaximum);
        dataOutputStream.writeInt(this.currentPeriode);
        dataOutputStream.writeInt(this.damping);
        dataOutputStream.writeBoolean(this.isAnimationRunning);
        dataOutputStream.writeBoolean(this.isDownwardsAnimation);
        dataOutputStream.writeInt(this.maxPeriode);
        dataOutputStream.writeInt(this.speed);
        dataOutputStream.writeInt(this.startMaximum);
        if (this.yAdjustments == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.yAdjustments.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.yAdjustments[n2]);
                ++n2;
            }
        }
    }
}

