/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.ui.containerviews.FishEyeContainerView;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CarouselContainerView
extends FishEyeContainerView {
    private boolean isFocusedAtBottom = true;
    private Dimension maximumHeight;

    protected void initItemArrangement(int lineWidth, int lineHeight, Item[] myItems, int length, int maxWidth, int maxHeight) {
        int processed;
        if (this.maximumHeight != null && lineHeight > this.maximumHeight.getValue(maxHeight)) {
            lineHeight = this.maximumHeight.getValue(maxHeight);
        }
        if (this.isRemoveText && !this.isShowTextInTitle) {
            if (this.focusedLabel == null && this.focusedStyle != null) {
                this.focusedLabel = new StringItem(null, "T");
                this.focusedLabel.setStyle(this.focusedStyle);
            }
            if (this.focusedItem != null) {
                if (this.focusedLabel.getText() == null) {
                    this.focusedLabel.setText("T");
                }
                lineHeight -= this.focusedLabel.getItemHeight(lineWidth, lineWidth, maxHeight);
            }
        }
        this.referenceXCenterPositions = new int[length];
        this.referenceYCenterPositions = new int[length];
        this.referenceXCenterPositions[this.focusedIndex] = lineWidth >> 1;
        this.referenceFocusedIndex = this.focusedIndex;
        if (this.focusedStyle != null && this.focusedItem != null) {
            UiAccess.focus(this.focusedItem, this.focusedDirection, this.focusedStyle);
            this.focusedWidth = this.focusedItem.getItemWidth(lineWidth, lineWidth, maxHeight);
            this.focusedItem.relativeX = lineWidth - this.focusedWidth >> 1;
        } else if (this.focusedWidth == 0) {
            this.focusedWidth = maxWidth;
        }
        if (this.focusedItem != null) {
            this.referenceYCenterPositions[this.focusedIndex] = this.isFocusedAtBottom ? lineHeight - (this.focusedItem.getItemHeight(lineWidth, lineWidth, maxHeight) >> 1) : this.focusedItem.getItemHeight(lineWidth, lineWidth, maxHeight) >> 1;
        }
        int availWidth = lineWidth;
        int availHeight = lineHeight;
        int halfLength = length - 1 >> 1;
        int availableWidthPerItem = (availWidth << 8) / (halfLength + 1);
        int availableHeightPerItem = (availHeight << 8) / (length - 1);
        int index = this.focusedIndex - 1;
        int x = lineWidth - maxWidth >> 1;
        int y = lineHeight - (maxHeight >> 1);
        boolean isDirectionSwitched = false;
        for (processed = 0; processed < halfLength; ++processed) {
            if (index < 0) {
                index = length - 1;
            }
            if ((x -= (availableWidthPerItem >> 8) * this.getScaleFactor(processed, length) / 100) <= maxWidth >> 1 || !isDirectionSwitched && processed + 1 >= halfLength >> 1) {
                x = maxWidth >> 1;
                availableWidthPerItem = -availableWidthPerItem;
                isDirectionSwitched = true;
            }
            this.referenceXCenterPositions[index] = x;
            this.referenceYCenterPositions[index] = y -= availableHeightPerItem >> 8;
            --index;
        }
        index = this.focusedIndex + 1;
        processed = 0;
        halfLength = length >> 1;
        x = lineWidth + maxWidth >> 1;
        y = lineHeight - (maxHeight >> 1);
        if (availableWidthPerItem > 0) {
            availableWidthPerItem = -availableWidthPerItem;
        }
        isDirectionSwitched = false;
        while (processed < halfLength) {
            if (index >= length) {
                index = 0;
            }
            if ((x -= (availableWidthPerItem >> 8) * this.getScaleFactor(processed, length) / 100) >= lineWidth - (maxWidth >> 1) || !isDirectionSwitched && processed + 1 >= halfLength >> 1) {
                x = lineWidth - (maxWidth >> 1);
                availableWidthPerItem = -availableWidthPerItem;
                isDirectionSwitched = true;
            }
            this.referenceXCenterPositions[index] = x;
            this.referenceYCenterPositions[index] = y -= availableHeightPerItem >> 8;
            ++index;
            ++processed;
        }
    }

    protected void initContent(Item parentContainerItem, int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(parentContainerItem, firstLineWidth, availWidth, availHeight);
        int lineHeight = availHeight;
        if (this.maximumHeight != null && lineHeight > this.maximumHeight.getValue(availHeight)) {
            lineHeight = this.maximumHeight.getValue(availHeight);
        }
        this.contentHeight = lineHeight;
        this.contentWidth = availWidth;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.isFocusedAtBottom = dataInputStream.readBoolean();
        this.maximumHeight = (Dimension)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.isFocusedAtBottom);
        Serializer.serialize(this.maximumHeight, dataOutputStream);
    }
}

