/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.ui.Border;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class SimpleBorder
extends Border {
    protected int color;
    protected boolean isArgb;

    public SimpleBorder(int color2, int borderWidth) {
        super(borderWidth, borderWidth, borderWidth, borderWidth);
        this.color = color2;
        this.isArgb = (color2 & 0xFF000000) != 0 && (color2 & 0xFF000000) != 255;
    }

    public SimpleBorder(int color2, int leftWidth, int rightWidth, int topWidth, int bottomWidth) {
        super(leftWidth, rightWidth, topWidth, bottomWidth);
        this.color = color2;
        this.isArgb = (color2 & 0xFF000000) != 0 && (color2 & 0xFF000000) != 255;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int border;
        --width;
        --height;
        int col = this.color;
        if (this.isArgb) {
            DrawUtil.drawRect(col, x, y, width, height, g);
            for (border = this.borderWidthLeft - 1; border > 0; --border) {
                DrawUtil.drawRect(col, x + border, y + border, width - (border << 1), height - (border << 1), g);
            }
        } else {
            g.setColor(col);
            g.drawRect(x, y, width, height);
            while (border > 0) {
                g.drawRect(x + border, y + border, width - (border << 1), height - (border << 1));
                --border;
            }
        }
    }

    public SimpleBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.isArgb = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeBoolean(this.isArgb);
    }
}

