/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.ui.borders.SimpleBorder;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PulsatingSimpleBorder
extends SimpleBorder {
    private int startColor;
    private int endColor;
    private int steps;
    private boolean repeat;
    private boolean backAndForth;
    private boolean animationStopped;
    private boolean directionUp;
    private int currentStep;

    public PulsatingSimpleBorder(int borderWidth, int startColor, int endColor, int steps, boolean repeat, boolean backAndForth) {
        super(startColor, borderWidth);
        this.startColor = startColor;
        this.endColor = endColor;
        this.steps = steps;
        this.repeat = repeat;
        this.backAndForth = backAndForth;
    }

    public boolean animate() {
        if (this.animationStopped) {
            return false;
        }
        if (this.backAndForth) {
            if (this.directionUp) {
                ++this.currentStep;
                if (this.currentStep > this.steps) {
                    --this.currentStep;
                    this.directionUp = false;
                }
            } else {
                --this.currentStep;
                if (this.currentStep == -1) {
                    this.currentStep = 0;
                    if (this.repeat) {
                        this.directionUp = true;
                    } else {
                        this.animationStopped = true;
                    }
                }
            }
        } else {
            ++this.currentStep;
            if (this.currentStep > this.steps) {
                if (this.repeat) {
                    this.currentStep = 0;
                } else {
                    --this.currentStep;
                    this.animationStopped = true;
                }
            }
        }
        this.color = DrawUtil.getGradientColor(this.startColor, this.endColor, this.currentStep, this.steps);
        return true;
    }

    public PulsatingSimpleBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animationStopped = dataInputStream.readBoolean();
        this.backAndForth = dataInputStream.readBoolean();
        this.currentStep = dataInputStream.readInt();
        this.directionUp = dataInputStream.readBoolean();
        this.endColor = dataInputStream.readInt();
        this.repeat = dataInputStream.readBoolean();
        this.startColor = dataInputStream.readInt();
        this.steps = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animationStopped);
        dataOutputStream.writeBoolean(this.backAndForth);
        dataOutputStream.writeInt(this.currentStep);
        dataOutputStream.writeBoolean(this.directionUp);
        dataOutputStream.writeInt(this.endColor);
        dataOutputStream.writeBoolean(this.repeat);
        dataOutputStream.writeInt(this.startColor);
        dataOutputStream.writeInt(this.steps);
    }
}

