/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MultiImageBorder
extends Border {
    private Image topLeftImage;
    private String topLeftUrl;
    private Image topCenterImage;
    private String topCenterUrl;
    private Image topRightImage;
    private String topRightUrl;
    private Image middleLeftImage;
    private String middleLeftUrl;
    private Image middleRightImage;
    private String middleRightUrl;
    private Image bottomLeftImage;
    private String bottomLeftUrl;
    private Image bottomCenterImage;
    private String bottomCenterUrl;
    private Image bottomRightImage;
    private String bottomRightUrl;
    private boolean isLoaded;
    private int borderWidth;

    public MultiImageBorder(int borderWidth, Image topLeft, Image topCenter, Image topRight, Image middleLeft, Image middleRight, Image bottomLeft, Image bottomCenter, Image bottomRight) {
        super(borderWidth, borderWidth, borderWidth, borderWidth);
        this.borderWidth = borderWidth;
        this.topLeftImage = topLeft;
        this.topCenterImage = topCenter;
        this.topRightImage = topRight;
        this.middleLeftImage = middleLeft;
        this.middleRightImage = middleRight;
        this.bottomLeftImage = bottomLeft;
        this.bottomCenterImage = bottomCenter;
        this.bottomRightImage = bottomRight;
        this.isLoaded = true;
    }

    public MultiImageBorder(int borderWidth, String topLeft, String topCenter, String topRight, String middleLeft, String middleRight, String bottomLeft, String bottomCenter, String bottomRight) {
        super(borderWidth, borderWidth, borderWidth, borderWidth);
        this.borderWidth = borderWidth;
        this.topLeftUrl = topLeft;
        this.topCenterUrl = topCenter;
        this.topRightUrl = topRight;
        this.middleLeftUrl = middleLeft;
        this.middleRightUrl = middleRight;
        this.bottomLeftUrl = bottomLeft;
        this.bottomCenterUrl = bottomCenter;
        this.bottomRightUrl = bottomRight;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int i;
        int num;
        if (!this.isLoaded) {
            try {
                this.topLeftImage = StyleSheet.getImage(this.topLeftUrl, this, false);
                this.topCenterImage = StyleSheet.getImage(this.topCenterUrl, this, false);
                this.topRightImage = StyleSheet.getImage(this.topRightUrl, this, false);
                this.middleLeftImage = StyleSheet.getImage(this.middleLeftUrl, this, false);
                this.middleRightImage = StyleSheet.getImage(this.middleRightUrl, this, false);
                this.bottomLeftImage = StyleSheet.getImage(this.bottomLeftUrl, this, false);
                this.bottomCenterImage = StyleSheet.getImage(this.bottomCenterUrl, this, false);
                this.bottomRightImage = StyleSheet.getImage(this.bottomRightUrl, this, false);
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.ui.borders.MultiImageBorder", 111, (Object)"unable to load image ", e);
            }
            this.isLoaded = true;
        }
        if (this.topLeftImage != null) {
            g.drawImage(this.topLeftImage, x, y, 40);
        }
        if (this.topCenterImage != null) {
            int w = this.topCenterImage.getWidth();
            num = (width - w) / w + 1;
            for (i = 0; i <= num; ++i) {
                g.drawImage(this.topCenterImage, x + i * w, y, 36);
            }
        }
        if (this.topRightImage != null) {
            g.drawImage(this.topRightImage, x + width, y, 36);
        }
        if (this.middleLeftImage != null) {
            int w = this.middleLeftImage.getHeight();
            num = (height - w) / w + 1;
            for (i = 0; i <= num; ++i) {
                g.drawImage(this.middleLeftImage, x, y + i * w, 24);
            }
        }
        if (this.middleRightImage != null) {
            int w = this.middleRightImage.getHeight();
            num = (height - w) / w + 1;
            for (i = 0; i <= num; ++i) {
                g.drawImage(this.middleRightImage, x + width, y + i * w, 20);
            }
        }
        if (this.bottomLeftImage != null) {
            g.drawImage(this.bottomLeftImage, x, y + height, 24);
        }
        if (this.bottomCenterImage != null) {
            int w = this.bottomCenterImage.getWidth();
            num = (width - w) / w + 1;
            for (i = 0; i <= num; ++i) {
                g.drawImage(this.bottomCenterImage, x + i * w, y + height, 20);
            }
        }
        if (this.bottomRightImage != null) {
            g.drawImage(this.bottomRightImage, x + width, y + height, 20);
        }
    }

    public MultiImageBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.borderWidth = dataInputStream.readInt();
        this.bottomCenterImage = (Image)Serializer.deserialize(dataInputStream);
        this.bottomCenterUrl = (String)Serializer.deserialize(dataInputStream);
        this.bottomLeftImage = (Image)Serializer.deserialize(dataInputStream);
        this.bottomLeftUrl = (String)Serializer.deserialize(dataInputStream);
        this.bottomRightImage = (Image)Serializer.deserialize(dataInputStream);
        this.bottomRightUrl = (String)Serializer.deserialize(dataInputStream);
        this.isLoaded = dataInputStream.readBoolean();
        this.middleLeftImage = (Image)Serializer.deserialize(dataInputStream);
        this.middleLeftUrl = (String)Serializer.deserialize(dataInputStream);
        this.middleRightImage = (Image)Serializer.deserialize(dataInputStream);
        this.middleRightUrl = (String)Serializer.deserialize(dataInputStream);
        this.topCenterImage = (Image)Serializer.deserialize(dataInputStream);
        this.topCenterUrl = (String)Serializer.deserialize(dataInputStream);
        this.topLeftImage = (Image)Serializer.deserialize(dataInputStream);
        this.topLeftUrl = (String)Serializer.deserialize(dataInputStream);
        this.topRightImage = (Image)Serializer.deserialize(dataInputStream);
        this.topRightUrl = (String)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.borderWidth);
        Serializer.serialize(this.bottomCenterImage, dataOutputStream);
        Serializer.serialize(this.bottomCenterUrl, dataOutputStream);
        Serializer.serialize(this.bottomLeftImage, dataOutputStream);
        Serializer.serialize(this.bottomLeftUrl, dataOutputStream);
        Serializer.serialize(this.bottomRightImage, dataOutputStream);
        Serializer.serialize(this.bottomRightUrl, dataOutputStream);
        dataOutputStream.writeBoolean(this.isLoaded);
        Serializer.serialize(this.middleLeftImage, dataOutputStream);
        Serializer.serialize(this.middleLeftUrl, dataOutputStream);
        Serializer.serialize(this.middleRightImage, dataOutputStream);
        Serializer.serialize(this.middleRightUrl, dataOutputStream);
        Serializer.serialize(this.topCenterImage, dataOutputStream);
        Serializer.serialize(this.topCenterUrl, dataOutputStream);
        Serializer.serialize(this.topLeftImage, dataOutputStream);
        Serializer.serialize(this.topLeftUrl, dataOutputStream);
        Serializer.serialize(this.topRightImage, dataOutputStream);
        Serializer.serialize(this.topRightUrl, dataOutputStream);
    }
}

