/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.ui.Border;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class CircleBorder
extends Border {
    private int strokeStyle;
    private int color;

    public CircleBorder(int color2, int width, int strokeStyle) {
        super(width, width, width, width);
        this.color = color2;
        this.strokeStyle = strokeStyle;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        boolean setStrokeStyle;
        g.setColor(this.color);
        boolean bl = setStrokeStyle = this.strokeStyle != 0;
        if (setStrokeStyle) {
            g.setStrokeStyle(this.strokeStyle);
        }
        g.drawArc(x, y, width, height, 0, 360);
        if (this.borderWidthLeft > 1) {
            for (int bw = this.borderWidthLeft; bw > 0; --bw) {
                g.drawArc(x + bw, y + bw, width - 2 * bw, height - 2 * bw, 0, 360);
            }
        }
        if (setStrokeStyle) {
            g.setStrokeStyle(0);
        }
    }

    public CircleBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.strokeStyle = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.strokeStyle);
    }
}

