/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class XmasSnowBackground
extends Background {
    private boolean isRunning = true;
    private int[] x;
    private int[] y;
    private int[] z;
    private int numberOfFlakes;
    private int color;
    private int maxFlakeSize;
    private transient Random rand = new Random();
    private int flakeColor = 0xFFFFFF;
    private int lastWidth;

    public XmasSnowBackground() {
    }

    public XmasSnowBackground(int color2, int snowFlakesColor, int maxSnowFlakeSize, int numberOfFlakes) {
        this(color2, null, 100, 100, maxSnowFlakeSize, numberOfFlakes);
        this.flakeColor = snowFlakesColor;
    }

    public XmasSnowBackground(int color2, String url, int width, int height, int maxSnowFlakeSize, int numberOfFlakes) {
        this.color = color2;
        this.maxFlakeSize = maxSnowFlakeSize;
        this.numberOfFlakes = numberOfFlakes;
        this.x = new int[numberOfFlakes];
        this.y = new int[numberOfFlakes];
        this.z = new int[numberOfFlakes];
        for (int i = 0; i < numberOfFlakes; ++i) {
            this.x[i] = this.nextRandInt(width);
            this.y[i] = this.nextRandInt(height);
            this.z[i] = this.nextRandInt(maxSnowFlakeSize);
        }
    }

    private int nextRandInt(int max) {
        int result = this.rand.nextInt(max);
        return result;
    }

    public boolean animate() {
        return this.isRunning;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        this.lastWidth = width;
        if (this.color != -1) {
            g.setColor(this.color);
            g.fillRect(x, y, width, height);
        }
        g.setColor(this.flakeColor);
        for (int i = 0; i < this.numberOfFlakes; ++i) {
            if (this.y[i] < height && this.x[i] < width) {
                int z1 = this.z[i];
                int n = i;
                this.y[n] = this.y[n] + z1;
                int n2 = i;
                this.x[n2] = this.x[n2] + 1;
            } else {
                this.y[i] = 0;
                this.x[i] = this.nextRandInt(width);
                this.z[i] = this.nextRandInt(this.maxFlakeSize);
            }
            int size = this.z[i];
            g.fillRoundRect(x + this.x[i], y + this.y[i], size, size, size, size);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.flakeColor = dataInputStream.readInt();
        this.isRunning = dataInputStream.readBoolean();
        this.lastWidth = dataInputStream.readInt();
        this.maxFlakeSize = dataInputStream.readInt();
        this.numberOfFlakes = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.x = new int[n2];
            n = 0;
            while (n < n2) {
                this.x[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.y = new int[n2];
            n = 0;
            while (n < n2) {
                this.y[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.z = new int[n2];
            n = 0;
            while (n < n2) {
                this.z[n] = dataInputStream.readInt();
                ++n;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.flakeColor);
        dataOutputStream.writeBoolean(this.isRunning);
        dataOutputStream.writeInt(this.lastWidth);
        dataOutputStream.writeInt(this.maxFlakeSize);
        dataOutputStream.writeInt(this.numberOfFlakes);
        if (this.x == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.x.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.x[n]);
                ++n;
            }
        }
        if (this.y == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.y.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.y[n]);
                ++n;
            }
        }
        if (this.z == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.z.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.z[n]);
                ++n;
            }
        }
    }
}

