/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Web20RoundRectBackground
extends Background {
    private int color;
    private Color colorObj;
    private int arcWidth;
    private int arcHeight;
    private int circleColor;
    private Color circleColorObj;
    private int circleAnchor;
    private int paddingLeft;
    private int paddingRight;
    private int paddingTop;
    private int paddingBottom;
    private boolean isInitialized;

    public Web20RoundRectBackground(int color2, int arcWidth, int arcHeight, int circleColor, int circleAnchor, int paddingLeft, int paddingRight, int paddingTop, int paddingBottom) {
        this.color = color2;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.circleColor = circleColor;
        this.circleAnchor = circleAnchor;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.isInitialized = true;
    }

    public Web20RoundRectBackground(Color colorObj, int arcWidth, int arcHeight, Color circleColorObj, int circleAnchor, int paddingLeft, int paddingRight, int paddingTop, int paddingBottom) {
        this.colorObj = colorObj;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.circleColorObj = circleColorObj;
        this.circleAnchor = circleAnchor;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.isInitialized = true;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.color = this.colorObj.getColor();
            this.circleColor = this.circleColorObj.getColor();
        }
        g.setColor(this.color);
        g.fillRoundRect(x, y, width, height, this.arcWidth, this.arcHeight);
        g.setColor(this.circleColor);
        switch (this.circleAnchor) {
            case 4: {
                g.fillArc(x, y, width, height, 315, 180);
                break;
            }
            case 8: {
                g.fillArc(x + width, y, -width, height, 315, 180);
                break;
            }
            case 16: {
                int yNew = y + this.paddingTop - (height - (this.paddingBottom + this.paddingTop));
                g.fillArc(x + this.paddingLeft, yNew, width - (this.paddingLeft + this.paddingRight), height - (this.paddingTop + this.paddingBottom) << 1, 180, 180);
                break;
            }
            default: {
                g.fillArc(x + this.paddingLeft, y + this.paddingTop, width - (this.paddingLeft + this.paddingRight), height - (this.paddingTop + this.paddingBottom) << 1, 180, -180);
            }
        }
    }

    public Web20RoundRectBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.circleAnchor = dataInputStream.readInt();
        this.circleColor = dataInputStream.readInt();
        this.circleColorObj = (Color)Serializer.deserialize(dataInputStream);
        this.color = dataInputStream.readInt();
        this.colorObj = (Color)Serializer.deserialize(dataInputStream);
        this.isInitialized = dataInputStream.readBoolean();
        this.paddingBottom = dataInputStream.readInt();
        this.paddingLeft = dataInputStream.readInt();
        this.paddingRight = dataInputStream.readInt();
        this.paddingTop = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.circleAnchor);
        dataOutputStream.writeInt(this.circleColor);
        Serializer.serialize(this.circleColorObj, dataOutputStream);
        dataOutputStream.writeInt(this.color);
        Serializer.serialize(this.colorObj, dataOutputStream);
        dataOutputStream.writeBoolean(this.isInitialized);
        dataOutputStream.writeInt(this.paddingBottom);
        dataOutputStream.writeInt(this.paddingLeft);
        dataOutputStream.writeInt(this.paddingRight);
        dataOutputStream.writeInt(this.paddingTop);
    }
}

