/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledImageBackground
extends Background {
    public static final int REPEAT = 1;
    public static final int REPEAT_X = 2;
    public static final int REPEAT_Y = 3;
    private Image image;
    private int color;
    private int repeatMode;
    private boolean isLoaded;
    private String imageUrl;
    private int anchor;
    private int paddingHorizontal;
    private int paddingVertical;
    private boolean overlap;
    private Dimension xOffset;
    private Dimension yOffset;

    public TiledImageBackground(int color2, String imageUrl, int repeatMode, int anchor, int paddingHorizontal, int paddingVertical, boolean overlap) {
        this(color2, imageUrl, repeatMode, anchor, paddingHorizontal, paddingVertical, overlap, 0, 0);
    }

    public TiledImageBackground(int color2, String imageUrl, int repeatMode, int anchor, int paddingHorizontal, int paddingVertical, boolean overlap, int xOffset, int yOffset) {
        this(color2, imageUrl, repeatMode, anchor, paddingHorizontal, paddingVertical, overlap, new Dimension(xOffset), new Dimension(yOffset));
    }

    public TiledImageBackground(int color2, String imageUrl, int repeatMode, int anchor, int paddingHorizontal, int paddingVertical, boolean overlap, Dimension xOffset, Dimension yOffset) {
        this.paddingHorizontal = paddingHorizontal;
        this.paddingVertical = paddingVertical;
        this.color = color2;
        this.repeatMode = repeatMode;
        this.imageUrl = imageUrl;
        this.anchor = anchor;
        this.overlap = overlap;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public TiledImageBackground(int color2, Image image, int repeatMode, int anchor, int paddingHorizontal, int paddingVertical, boolean overlap, Dimension xOffset, Dimension yOffset) {
        this.paddingHorizontal = paddingHorizontal;
        this.paddingVertical = paddingVertical;
        this.color = color2;
        this.repeatMode = repeatMode;
        this.image = image;
        this.anchor = anchor;
        this.overlap = overlap;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.imageUrl = null;
        this.isLoaded = true;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        block34: {
            int totalHeight;
            int numberOfYRepeats;
            int totalWidth;
            if (!this.isLoaded) {
                try {
                    this.image = StyleSheet.getImage(this.imageUrl, this, false);
                }
                catch (IOException e) {
                    Debug.debug("error", "de.enough.polish.ui.backgrounds.TiledImageBackground", 215, (Object)("unable to load image [" + this.imageUrl + "]"), e);
                }
                this.isLoaded = true;
            }
            if (this.color != -1) {
                g.setColor(this.color);
                g.fillRect(x, y, width, height);
            }
            x += this.xOffset.getValue(width);
            y += this.yOffset.getValue(height);
            if (this.image == null) break block34;
            int imgWidth = this.image.getWidth() + this.paddingHorizontal;
            int imgHeight = this.image.getHeight() + this.paddingVertical;
            int numberOfXRepeats = (width + this.paddingHorizontal) / imgWidth - 1;
            if (numberOfXRepeats < 0) {
                numberOfXRepeats = 0;
            }
            if ((totalWidth = imgWidth - this.paddingHorizontal + numberOfXRepeats * imgWidth) < width && this.overlap) {
                ++numberOfXRepeats;
                totalWidth += imgWidth;
            }
            if ((numberOfYRepeats = (height + this.paddingVertical) / imgHeight - 1) < 0) {
                numberOfYRepeats = 0;
            }
            if ((totalHeight = imgHeight - this.paddingVertical + numberOfYRepeats * imgHeight) < height && this.overlap) {
                ++numberOfYRepeats;
                totalHeight += imgHeight;
            }
            if (this.repeatMode == 1) {
                if ((this.anchor & 2) == 2) {
                    y += (height - totalHeight) / 2;
                } else if ((this.anchor & 0x20) == 32) {
                    y += height - totalHeight;
                }
                if ((this.anchor & 1) == 1) {
                    x += (width - totalWidth) / 2;
                } else if ((this.anchor & 8) == 8) {
                    x += width - totalWidth;
                }
                int imgX = x;
                int imgY = y;
                for (int i = 0; i <= numberOfYRepeats; ++i) {
                    for (int j = 0; j <= numberOfXRepeats; ++j) {
                        g.drawImage(this.image, imgX, imgY, 20);
                        imgX += imgWidth;
                    }
                    imgY += imgHeight;
                    imgX = x;
                }
            } else if (this.repeatMode == 2) {
                if ((this.anchor & 1) == 1) {
                    x += (width - totalWidth) / 2 + (imgWidth - this.paddingHorizontal) / 2;
                } else if ((this.anchor & 8) == 8) {
                    x += width - totalWidth + (imgWidth - this.paddingHorizontal);
                }
                if ((this.anchor & 2) == 2) {
                    y += height / 2;
                } else if ((this.anchor & 0x20) == 32) {
                    y += height;
                }
                for (int j = 0; j <= numberOfXRepeats; ++j) {
                    g.drawImage(this.image, x, y, this.anchor);
                    x += imgWidth;
                }
            } else {
                if ((this.anchor & 1) == 1) {
                    x += width / 2;
                } else if ((this.anchor & 8) == 8) {
                    x += width;
                }
                if ((this.anchor & 2) == 2) {
                    y += (height - totalHeight) / 2 + (imgHeight - this.paddingVertical) / 2;
                } else if ((this.anchor & 0x20) == 32) {
                    y += height - totalHeight + (imgHeight - this.paddingVertical);
                }
                for (int i = 0; i <= numberOfYRepeats; ++i) {
                    g.drawImage(this.image, x, y, this.anchor);
                    y += imgHeight;
                }
            }
        }
    }

    public void releaseResources() {
        this.isLoaded = false;
        this.image = null;
    }

    public TiledImageBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.anchor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.image = (Image)Serializer.deserialize(dataInputStream);
        this.imageUrl = (String)Serializer.deserialize(dataInputStream);
        this.isLoaded = dataInputStream.readBoolean();
        this.overlap = dataInputStream.readBoolean();
        this.paddingHorizontal = dataInputStream.readInt();
        this.paddingVertical = dataInputStream.readInt();
        this.repeatMode = dataInputStream.readInt();
        this.xOffset = (Dimension)Serializer.deserialize(dataInputStream);
        this.yOffset = (Dimension)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.anchor);
        dataOutputStream.writeInt(this.color);
        Serializer.serialize(this.image, dataOutputStream);
        Serializer.serialize(this.imageUrl, dataOutputStream);
        dataOutputStream.writeBoolean(this.isLoaded);
        dataOutputStream.writeBoolean(this.overlap);
        dataOutputStream.writeInt(this.paddingHorizontal);
        dataOutputStream.writeInt(this.paddingVertical);
        dataOutputStream.writeInt(this.repeatMode);
        Serializer.serialize(this.xOffset, dataOutputStream);
        Serializer.serialize(this.yOffset, dataOutputStream);
    }
}

