/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import de.enough.polish.util.TextUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SlideShowBackground
extends Background {
    private Image currentImage;
    private int color;
    private int anchor;
    private boolean doCenter;
    private int xOffset;
    private int yOffset;
    private String[] imageUrls;
    private int currentImageIndex;
    private long lastImageSwitch;
    private long interval;

    public SlideShowBackground(int color2, String imageUrls, int anchor, long interval) {
        this(color2, imageUrls, anchor, interval, 0, 0);
    }

    public SlideShowBackground(int color2, String imageUrls, int anchor, long interval, int xOffset, int yOffset) {
        this.color = color2;
        this.imageUrls = TextUtil.split(imageUrls, ',');
        this.anchor = anchor;
        this.interval = interval;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.doCenter = anchor == 3;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        Image image = this.currentImage;
        if (image == null) {
            String url = null;
            try {
                this.lastImageSwitch = System.currentTimeMillis();
                url = this.imageUrls[this.currentImageIndex];
                this.currentImage = image = StyleSheet.getImage(url, this, false);
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.backgrounds.SlideShowBackground", 125, (Object)("unable to load image [" + url + "]"), e);
            }
        }
        if (this.color != -1) {
            g.setColor(this.color);
            g.fillRect(x, y, width, height);
        }
        x += this.xOffset;
        y += this.yOffset;
        if (image != null) {
            if (this.doCenter) {
                int centerX = x + width / 2;
                int centerY = y + height / 2;
                g.drawImage(image, centerX, centerY, 3);
            } else {
                if ((this.anchor & 1) == 1) {
                    x += width / 2;
                } else if ((this.anchor & 8) == 8) {
                    x += width;
                }
                if ((this.anchor & 2) == 2) {
                    y += height / 2;
                } else if ((this.anchor & 0x20) == 32) {
                    y += height;
                }
                g.drawImage(image, x, y, this.anchor);
            }
        }
    }

    public void setImage(Image image) {
        this.currentImage = image;
    }

    public Image getImage() {
        return this.currentImage;
    }

    public void releaseResources() {
        this.currentImage = null;
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        if (currentTime - this.lastImageSwitch > this.interval) {
            int index = this.currentImageIndex + 1;
            if (index >= this.imageUrls.length) {
                index = 0;
            }
            String url = null;
            try {
                this.lastImageSwitch = currentTime;
                this.currentImageIndex = index;
                url = this.imageUrls[index];
                this.currentImage = StyleSheet.getImage(url, this, false);
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.backgrounds.SlideShowBackground", 200, (Object)("unable to load image [" + url + "]"), e);
            }
            this.addRelativeToBackgroundRegion(repaintRegion, screen, parent, 0, 0, 0, 0);
        }
    }

    public SlideShowBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.anchor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.currentImage = (Image)Serializer.deserialize(dataInputStream);
        this.currentImageIndex = dataInputStream.readInt();
        this.doCenter = dataInputStream.readBoolean();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.imageUrls = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.imageUrls[n2] = (String)Serializer.deserialize(dataInputStream);
                ++n2;
            }
        }
        this.interval = dataInputStream.readLong();
        this.lastImageSwitch = dataInputStream.readLong();
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.anchor);
        dataOutputStream.writeInt(this.color);
        Serializer.serialize(this.currentImage, dataOutputStream);
        dataOutputStream.writeInt(this.currentImageIndex);
        dataOutputStream.writeBoolean(this.doCenter);
        if (this.imageUrls == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.imageUrls.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                Serializer.serialize(this.imageUrls[n2], dataOutputStream);
                ++n2;
            }
        }
        dataOutputStream.writeLong(this.interval);
        dataOutputStream.writeLong(this.lastImageSwitch);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

