/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.ImageUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScalingImageBackground
extends Background {
    public static final int MODE_NO_SCALE = 0;
    public static final int MODE_SCALE = 1;
    public static final int MODE_SCALE_PROPORTIONAL = 2;
    public static final int MODE_SCALE_PROPORTIONAL_EXPAND = 3;
    private Image image;
    private int color;
    private boolean isLoaded;
    private String imageUrl;
    private int anchor;
    private boolean doCenter;
    private int xOffset;
    private int yOffset;
    private int scalingMode;
    private int[] rgbData;
    private int[] rgbDataScaled;
    int lastWidth;
    int lastHeight;
    private int scaledWidth;
    private int scaledHeight;

    public ScalingImageBackground(int color2, String imageUrl, int scalingMode, int anchor, int xOffset, int yOffset) {
        this.color = color2;
        this.imageUrl = imageUrl;
        this.scalingMode = scalingMode;
        this.anchor = anchor;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.doCenter = anchor == 3;
        this.isLoaded = imageUrl == null;
    }

    public ScalingImageBackground(int color2, Image image, int scalingMode, int anchor, int xOffset, int yOffset) {
        this.color = color2;
        this.image = image;
        this.imageUrl = null;
        this.isLoaded = true;
        this.scalingMode = scalingMode;
        this.anchor = anchor;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.doCenter = anchor == 3;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (!this.isLoaded) {
            try {
                this.image = StyleSheet.getImage(this.imageUrl, this, false);
                this.rgbData = new int[this.image.getWidth() * this.image.getHeight()];
                this.image.getRGB(this.rgbData, 0, this.image.getWidth(), 0, 0, this.image.getWidth(), this.image.getHeight());
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.ui.backgrounds.ScalingImageBackground", 169, (Object)("unable to load image [" + this.imageUrl + "]"), e);
            }
            this.isLoaded = true;
        }
        if (this.color != -1) {
            g.setColor(this.color);
            g.fillRect(x, y, width, height);
        }
        x += this.xOffset;
        y += this.yOffset;
        if (this.image != null) {
            if (width != this.lastWidth || height != this.lastHeight) {
                int newHeight;
                int newWidth;
                switch (this.scalingMode) {
                    case 1: {
                        newWidth = width;
                        newHeight = height;
                        break;
                    }
                    case 2: {
                        int factor = Math.min((width << 8) / this.image.getWidth(), (height << 8) / this.image.getHeight());
                        newWidth = this.image.getWidth() * factor >> 8;
                        newHeight = this.image.getHeight() * factor >> 8;
                        break;
                    }
                    case 3: {
                        int factor = Math.max((width << 8) / this.image.getWidth(), (height << 8) / this.image.getHeight());
                        newWidth = this.image.getWidth() * factor >> 8;
                        newHeight = this.image.getHeight() * factor >> 8;
                        break;
                    }
                    default: {
                        newWidth = this.image.getWidth();
                        newHeight = this.image.getHeight();
                    }
                }
                this.rgbDataScaled = ImageUtil.scale(this.rgbData, newWidth, newHeight, this.image.getWidth(), this.image.getHeight());
                this.lastWidth = width;
                this.lastHeight = height;
                this.scaledWidth = newWidth;
                this.scaledHeight = newHeight;
            }
            if (this.doCenter) {
                x += (width >> 1) - (this.scaledWidth >> 1);
                y += (height >> 1) - (this.scaledHeight >> 1);
            } else {
                if ((this.anchor & 1) == 1) {
                    x += (width >> 1) - (this.scaledWidth >> 1);
                } else if ((this.anchor & 8) == 8) {
                    x += width - this.scaledWidth;
                }
                if ((this.anchor & 2) == 2) {
                    y += (height >> 1) - (this.scaledHeight >> 1);
                } else if ((this.anchor & 0x20) == 32) {
                    y += height - this.scaledHeight;
                }
            }
            DrawUtil.drawRgb(this.rgbDataScaled, x, y, this.scaledWidth, this.scaledHeight, true, g);
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.isLoaded = image != null;
    }

    public Image getImage() {
        return this.image;
    }

    public void releaseResources() {
        if (this.imageUrl != null) {
            this.isLoaded = false;
            this.image = null;
        }
        this.rgbData = null;
        this.rgbDataScaled = null;
        this.lastWidth = 0;
        this.lastHeight = 0;
    }

    public ScalingImageBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.anchor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.doCenter = dataInputStream.readBoolean();
        this.image = (Image)Serializer.deserialize(dataInputStream);
        this.imageUrl = (String)Serializer.deserialize(dataInputStream);
        this.isLoaded = dataInputStream.readBoolean();
        this.lastHeight = dataInputStream.readInt();
        this.lastWidth = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbData = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbData[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbDataScaled = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbDataScaled[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.scaledHeight = dataInputStream.readInt();
        this.scaledWidth = dataInputStream.readInt();
        this.scalingMode = dataInputStream.readInt();
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.anchor);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeBoolean(this.doCenter);
        Serializer.serialize(this.image, dataOutputStream);
        Serializer.serialize(this.imageUrl, dataOutputStream);
        dataOutputStream.writeBoolean(this.isLoaded);
        dataOutputStream.writeInt(this.lastHeight);
        dataOutputStream.writeInt(this.lastWidth);
        if (this.rgbData == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbData.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbData[n]);
                ++n;
            }
        }
        if (this.rgbDataScaled == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbDataScaled.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbDataScaled[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.scaledHeight);
        dataOutputStream.writeInt(this.scaledWidth);
        dataOutputStream.writeInt(this.scalingMode);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

