/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class PulsatingCircleBackground
extends Background {
    private int color;
    private int maxDiameter;
    private int minDiameter;
    private boolean isFlexibleMaxDiameter;
    private int currentDiameter;
    private boolean isGrowing;
    private int speed;

    public PulsatingCircleBackground(int color2, int minDiameter, int maxDiameter, int speed) {
        this.isGrowing = true;
        this.color = color2;
        this.minDiameter = minDiameter;
        this.maxDiameter = maxDiameter;
        this.speed = speed;
        this.isFlexibleMaxDiameter = maxDiameter == -1;
        this.currentDiameter = minDiameter;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (this.isFlexibleMaxDiameter) {
            this.maxDiameter = Math.min(width, height);
        }
        g.setColor(this.color);
        int centerX = x + (width >> 1);
        int centerY = y + (height >> 1);
        int current = this.currentDiameter;
        int offset = current >> 1;
        x = centerX - offset;
        y = centerY - offset;
        g.fillArc(x, y, current, current, 0, 360);
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        int current;
        int previous = current = this.currentDiameter;
        int adjust = this.speed;
        if (adjust == -1 && (adjust = (this.maxDiameter - current) / 3) < 1) {
            adjust = 1;
        }
        if (this.isGrowing) {
            if ((current += adjust) >= this.maxDiameter) {
                this.isGrowing = false;
            }
        } else if ((current -= adjust) <= this.minDiameter) {
            this.isGrowing = true;
        }
        this.currentDiameter = current;
        current = Math.max(current, previous);
        if (parent != null) {
            int w = parent.getBackgroundWidth();
            int h = parent.getBackgroundHeight();
            int x = w - current >> 1;
            int y = h - current >> 1;
            parent.addRelativeToBackgroundRegion(this, null, repaintRegion, x, y, current, current);
        } else {
            repaintRegion.addRegion(0, 0, screen.getWidth(), screen.getScreenHeight());
        }
    }

    public void showNotify() {
        super.showNotify();
        this.isGrowing = true;
        this.currentDiameter = this.minDiameter;
    }

    public PulsatingCircleBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.currentDiameter = dataInputStream.readInt();
        this.isFlexibleMaxDiameter = dataInputStream.readBoolean();
        this.isGrowing = dataInputStream.readBoolean();
        this.maxDiameter = dataInputStream.readInt();
        this.minDiameter = dataInputStream.readInt();
        this.speed = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.currentDiameter);
        dataOutputStream.writeBoolean(this.isFlexibleMaxDiameter);
        dataOutputStream.writeBoolean(this.isGrowing);
        dataOutputStream.writeInt(this.maxDiameter);
        dataOutputStream.writeInt(this.minDiameter);
        dataOutputStream.writeInt(this.speed);
    }
}

