/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.backgrounds.ImageResourceBackground;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class PatchBackground
extends ImageResourceBackground {
    private int leftWidth;
    private int topHeight;
    private int rightWidth;
    private int bottomHeight;
    private boolean isTransparent;

    public PatchBackground(String imageUrl, int leftWidth, int topHeight, int rightWidth, int bottomHeight, boolean isTransparent) {
        super(imageUrl);
        this.leftWidth = leftWidth;
        this.topHeight = topHeight;
        this.rightWidth = rightWidth;
        this.bottomHeight = bottomHeight;
        this.isTransparent = isTransparent;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (!this.isLoaded) {
            this.load();
            if (this.imageWidth - (this.leftWidth + this.rightWidth) < 1) {
                throw new IllegalArgumentException("Invalid patch-width: left=" + this.leftWidth + ", right=" + this.rightWidth + ", image-width=" + this.imageWidth + " of " + this.imageUrl);
            }
            if (this.imageHeight - (this.topHeight + this.bottomHeight) < 1) {
                throw new IllegalArgumentException("Invalid patch-height: top=" + this.topHeight + ", bottom=" + this.bottomHeight + ", image-height=" + this.imageHeight + " of " + this.imageUrl);
            }
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        this.paintHorizontalTiles(x, y, width, height, clipX, clipY, clipWidth, clipHeight, g);
        this.paintVerticalTiles(x, y, width, height, clipX, clipY, clipWidth, clipHeight, g);
        if (!this.isTransparent) {
            this.paintCenterTiles(x, y, width, height, clipX, clipY, clipWidth, clipHeight, g);
        }
        this.paintCorners(x, y, width, height, clipX, clipY, clipWidth, clipHeight, g);
    }

    private void paintCorners(int x, int y, int width, int height, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int srcX = 0;
        int srcY = 0;
        int dstX = x + srcX;
        int dstY = y + srcY;
        this.drawRegion(this.image, srcX, srcY, this.leftWidth, this.topHeight, dstX, dstY, clipX, clipY, clipWidth, clipHeight, g);
        srcX = this.imageWidth - this.rightWidth;
        srcY = 0;
        dstX = x + (width - this.rightWidth);
        dstY = y;
        this.drawRegion(this.image, srcX, srcY, this.rightWidth, this.topHeight, dstX, dstY, clipX, clipY, clipWidth, clipHeight, g);
        srcX = 0;
        srcY = this.imageHeight - this.bottomHeight;
        dstX = x;
        dstY = y + (height - this.bottomHeight);
        this.drawRegion(this.image, srcX, srcY, this.leftWidth, this.bottomHeight, dstX, dstY, clipX, clipY, clipWidth, clipHeight, g);
        srcX = this.imageWidth - this.rightWidth;
        srcY = this.imageHeight - this.bottomHeight;
        dstX = x + (width - this.rightWidth);
        dstY = y + (height - this.bottomHeight);
        this.drawRegion(this.image, srcX, srcY, this.rightWidth, this.bottomHeight, dstX, dstY, clipX, clipY, clipWidth, clipHeight, g);
    }

    private void paintHorizontalTiles(int x, int y, int width, int height, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int xOffset;
        int srcX = this.leftWidth;
        int srcWidth = this.imageWidth - (this.leftWidth + this.rightWidth);
        int srcHeight = this.topHeight;
        int dstX = x + this.leftWidth;
        int fillWidth = width - (this.leftWidth + this.rightWidth);
        this.storeClipping(g);
        clipX = dstX;
        clipY = y;
        clipWidth = fillWidth;
        clipHeight = height;
        g.clipRect(clipX, clipY, clipWidth, clipHeight);
        int srcY = 0;
        int dstY = y;
        for (xOffset = 0; xOffset < fillWidth; xOffset += srcWidth) {
            this.drawRegion(this.image, srcX, srcY, srcWidth, srcHeight, dstX + xOffset, dstY, clipX, clipY, clipWidth, clipHeight, g);
        }
        srcY = this.imageHeight - this.bottomHeight;
        srcHeight = this.bottomHeight;
        dstY = y + (height - this.bottomHeight);
        for (xOffset = 0; xOffset < fillWidth; xOffset += srcWidth) {
            this.drawRegion(this.image, srcX, srcY, srcWidth, srcHeight, dstX + xOffset, dstY, clipX, clipY, clipWidth, clipHeight, g);
        }
        this.restoreClipping(g);
    }

    private void paintVerticalTiles(int x, int y, int width, int height, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int yOffset;
        int srcX = 0;
        int srcY = this.topHeight;
        int srcWidth = this.leftWidth;
        int srcHeight = this.imageHeight - (this.topHeight + this.bottomHeight);
        int dstX = x;
        int dstY = y + this.topHeight;
        int fillHeight = height - this.topHeight - this.bottomHeight;
        this.storeClipping(g);
        clipX = x;
        clipY = dstY;
        clipWidth = width;
        clipHeight = fillHeight;
        g.clipRect(clipX, clipY, clipWidth, clipHeight);
        for (yOffset = 0; yOffset < fillHeight; yOffset += srcHeight) {
            this.drawRegion(this.image, srcX, srcY, srcWidth, srcHeight, dstX, dstY + yOffset, clipX, clipY, clipWidth, clipHeight, g);
        }
        srcX = this.imageWidth - this.rightWidth;
        srcWidth = this.rightWidth;
        dstX = x + (width - this.rightWidth);
        for (yOffset = 0; yOffset < fillHeight; yOffset += srcHeight) {
            this.drawRegion(this.image, srcX, srcY, srcWidth, srcHeight, dstX, dstY + yOffset, clipX, clipY, clipWidth, clipHeight, g);
        }
        this.restoreClipping(g);
    }

    private void paintCenterTiles(int x, int y, int width, int height, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int dstX = x + this.leftWidth;
        int dstY = y + this.topHeight;
        int fillWidth = width - (this.leftWidth + this.rightWidth);
        int fillHeight = height - (this.topHeight + this.bottomHeight);
        int srcX = this.leftWidth;
        int srcY = this.topHeight;
        int srcWidth = this.imageWidth - (this.leftWidth + this.rightWidth);
        int srcHeight = this.imageHeight - (this.topHeight + this.bottomHeight);
        this.storeClipping(g);
        clipX = dstX;
        clipY = dstY;
        clipWidth = fillWidth;
        clipHeight = fillHeight;
        g.clipRect(clipX, clipY, clipWidth, clipHeight);
        for (int yOffset = 0; yOffset < fillHeight; yOffset += srcHeight) {
            for (int xOffset = 0; xOffset < fillWidth; xOffset += srcWidth) {
                this.drawRegion(this.image, srcX, srcY, srcWidth, srcHeight, dstX + xOffset, dstY + yOffset, clipX, clipY, clipWidth, clipHeight, g);
            }
        }
        this.restoreClipping(g);
    }

    public PatchBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.bottomHeight = dataInputStream.readInt();
        this.isTransparent = dataInputStream.readBoolean();
        this.leftWidth = dataInputStream.readInt();
        this.rightWidth = dataInputStream.readInt();
        this.topHeight = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.bottomHeight);
        dataOutputStream.writeBoolean(this.isTransparent);
        dataOutputStream.writeInt(this.leftWidth);
        dataOutputStream.writeInt(this.rightWidth);
        dataOutputStream.writeInt(this.topHeight);
    }
}

