/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Dimension;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MaskBackground
extends Background {
    private Background mask;
    private Background background;
    private int[] buffer;
    private int[] maskBuffer;
    private int[] backgroundBuffer;
    private int lastWidth;
    private int lastHeight;
    private int maskColor;
    private int opacity;
    private boolean refreshMask;
    private boolean refreshBackground;

    public MaskBackground(Background mask, int maskColor, Background background, int opacity) {
        this.mask = mask;
        this.maskColor = maskColor;
        this.background = background;
        this.opacity = opacity;
    }

    public MaskBackground(Background mask, int maskColor, Background background, Dimension opacity) {
        this(mask, maskColor, background, opacity == null ? 255 : opacity.getValue(255));
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        boolean refreshAll;
        if (width <= 0 || height <= 0) {
            return;
        }
        int[] rgbData = this.buffer;
        boolean bl = refreshAll = rgbData == null || width != this.lastWidth || height != this.lastHeight;
        if (refreshAll || this.refreshBackground || this.refreshMask) {
            int area = width * height;
            Image image = Image.createImage(width, height);
            Graphics imageG = image.getGraphics();
            int[] maskData = this.maskBuffer;
            if (refreshAll || this.refreshMask) {
                this.mask.paint(0, 0, width, height, imageG);
                if (maskData == null || maskData.length != area) {
                    this.maskBuffer = maskData = new int[area];
                }
                image.getRGB(maskData, 0, width, 0, 0, width, height);
                this.refreshMask = false;
                if (refreshAll || this.refreshBackground) {
                    imageG.setColor(0xFFFFFF);
                    imageG.fillRect(0, 0, width, height);
                }
            }
            if (refreshAll || this.refreshBackground) {
                this.background.paint(0, 0, width, height, imageG);
                int[] backgroundData = this.backgroundBuffer;
                if (backgroundData == null || backgroundData.length != area) {
                    this.backgroundBuffer = backgroundData = new int[area];
                }
                image.getRGB(backgroundData, 0, width, 0, 0, width, height);
                this.refreshBackground = false;
            }
            if (rgbData == null || rgbData.length != area) {
                this.buffer = rgbData = new int[area];
            }
            int targetColor = imageG.getDisplayColor(this.maskColor) | 0xFF000000;
            int backgroundColor = imageG.getDisplayColor(0xFFFFFF) | 0xFF000000;
            for (int i = 0; i < area; ++i) {
                int maskCol = maskData[i];
                int maskAlpha = maskCol >>> 24;
                if ((maskCol |= 0xFF000000) != backgroundColor) {
                    int pixel = this.backgroundBuffer[i];
                    int pixelAlpha = pixel >>> 24;
                    int maxAlpha = Math.min(maskAlpha, this.opacity);
                    if (pixelAlpha > maxAlpha) {
                        pixel = (pixel | 0xFF000000) & (maxAlpha << 24 | 0xFFFFFF);
                    }
                    rgbData[i] = pixel;
                    continue;
                }
                rgbData[i] = 0;
            }
            this.buffer = rgbData;
            this.lastWidth = width;
            this.lastHeight = height;
        }
        DrawUtil.drawRgb(rgbData, x, y, width, height, true, g);
    }

    public boolean animate() {
        boolean animated = false;
        if (this.mask.animate()) {
            this.refreshMask = true;
            this.lastWidth = 0;
            animated = true;
        }
        if (this.background.animate()) {
            this.refreshBackground = true;
            this.lastWidth = 0;
            animated = true;
        }
        return animated;
    }

    public void hideNotify() {
        this.mask.hideNotify();
        this.background.hideNotify();
    }

    public void releaseResources() {
        this.lastWidth = 0;
        this.mask.releaseResources();
        this.background.releaseResources();
        this.buffer = null;
        this.maskBuffer = null;
        this.backgroundBuffer = null;
    }

    public void showNotify() {
        this.mask.showNotify();
        this.background.showNotify();
    }

    public MaskBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.background = (Background)Serializer.deserialize(dataInputStream);
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.backgroundBuffer = new int[n2];
            n = 0;
            while (n < n2) {
                this.backgroundBuffer[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.buffer = new int[n2];
            n = 0;
            while (n < n2) {
                this.buffer[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.lastHeight = dataInputStream.readInt();
        this.lastWidth = dataInputStream.readInt();
        this.mask = (Background)Serializer.deserialize(dataInputStream);
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.maskBuffer = new int[n2];
            n = 0;
            while (n < n2) {
                this.maskBuffer[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.maskColor = dataInputStream.readInt();
        this.opacity = dataInputStream.readInt();
        this.refreshBackground = dataInputStream.readBoolean();
        this.refreshMask = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        Serializer.serialize(this.background, dataOutputStream);
        if (this.backgroundBuffer == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.backgroundBuffer.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.backgroundBuffer[n]);
                ++n;
            }
        }
        if (this.buffer == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.buffer.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.buffer[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.lastHeight);
        dataOutputStream.writeInt(this.lastWidth);
        Serializer.serialize(this.mask, dataOutputStream);
        if (this.maskBuffer == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.maskBuffer.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.maskBuffer[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.maskColor);
        dataOutputStream.writeInt(this.opacity);
        dataOutputStream.writeBoolean(this.refreshBackground);
        dataOutputStream.writeBoolean(this.refreshMask);
    }
}

