/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class LayerVerticalBackground
extends Background {
    private Background[] layers;

    public LayerVerticalBackground(Background[] layers) {
        this.layers = layers;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        Background[] bgs = this.layers;
        int heightPerBg = height / bgs.length;
        y += height;
        int i = bgs.length;
        while (--i >= 0) {
            Background background = bgs[i];
            background.paint(x, y -= heightPerBg, width, heightPerBg, g);
        }
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        Background[] bgs = this.layers;
        int i = bgs.length;
        while (--i >= 0) {
            Background background = bgs[i];
            background.animate(screen, parent, currentTime, repaintRegion);
        }
    }

    public void showNotify() {
        Background[] bgs = this.layers;
        int i = bgs.length;
        while (--i >= 0) {
            Background background = bgs[i];
            background.showNotify();
        }
    }

    public void hideNotify() {
        Background[] bgs = this.layers;
        int i = bgs.length;
        while (--i >= 0) {
            Background background = bgs[i];
            background.hideNotify();
        }
    }

    public void releaseResources() {
        Background[] bgs = this.layers;
        int i = bgs.length;
        while (--i >= 0) {
            Background background = bgs[i];
            background.releaseResources();
        }
    }

    public LayerVerticalBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.layers = new Background[n];
            int n2 = 0;
            while (n2 < n) {
                this.layers[n2] = (Background)Serializer.deserialize(dataInputStream);
                ++n2;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        if (this.layers == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.layers.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                Serializer.serialize(this.layers[n2], dataOutputStream);
                ++n2;
            }
        }
    }
}

