/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Dimension;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class GradientVerticalBackground
extends Background {
    private int topColor;
    private int bottomColor;
    private int stroke;
    private Dimension start;
    private Dimension end;
    private int[] gradient;
    private int lastHeight;
    private int startLine;
    private int endLine;

    public GradientVerticalBackground(int topColor, int bottomColor, int stroke) {
        this(topColor, bottomColor, stroke, 0, 0, false);
    }

    public GradientVerticalBackground(int topColor, int bottomColor, int stroke, int start, int end, boolean isPercent) {
        this(topColor, bottomColor, stroke, new Dimension(start, isPercent), new Dimension(end, isPercent));
    }

    public GradientVerticalBackground(int topColor, int bottomColor, int stroke, Dimension start, Dimension end) {
        this.topColor = topColor;
        this.bottomColor = bottomColor;
        this.stroke = stroke;
        if (start != null && end != null && start.getValue(100) != end.getValue(100)) {
            this.start = start;
            if (end.getValue(100) < start.getValue(100)) {
                end = new Dimension(100, true);
            }
            this.end = end;
        }
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (height <= 0) {
            return;
        }
        g.setStrokeStyle(this.stroke);
        int startOffset = this.startLine;
        int endOffset = this.endLine;
        if (this.gradient == null || this.lastHeight != height) {
            int steps = height;
            if (this.start != null) {
                this.startLine = this.start.getValue(height);
                this.endLine = this.end.getValue(height);
                steps = this.endLine - this.startLine;
                startOffset = this.startLine;
                endOffset = this.endLine;
            } else {
                this.endLine = height;
                endOffset = height;
            }
            this.gradient = DrawUtil.getGradient(this.topColor, this.bottomColor, steps);
            this.lastHeight = height;
        }
        --width;
        g.setColor(this.topColor);
        for (int i = 0; i < height; ++i) {
            if (i >= startOffset && i < endOffset) {
                int color2 = this.gradient[i - startOffset];
                g.setColor(color2);
            }
            g.drawLine(x, y, x + width, y);
            ++y;
        }
        g.setStrokeStyle(0);
    }

    public GradientVerticalBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.bottomColor = dataInputStream.readInt();
        this.end = (Dimension)Serializer.deserialize(dataInputStream);
        this.endLine = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.gradient = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.gradient[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.lastHeight = dataInputStream.readInt();
        this.start = (Dimension)Serializer.deserialize(dataInputStream);
        this.startLine = dataInputStream.readInt();
        this.stroke = dataInputStream.readInt();
        this.topColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.bottomColor);
        Serializer.serialize(this.end, dataOutputStream);
        dataOutputStream.writeInt(this.endLine);
        if (this.gradient == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.gradient.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.gradient[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.lastHeight);
        Serializer.serialize(this.start, dataOutputStream);
        dataOutputStream.writeInt(this.startLine);
        dataOutputStream.writeInt(this.stroke);
        dataOutputStream.writeInt(this.topColor);
    }
}

