/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class FadeInBackground
extends Background {
    private int targetArgbColor;
    private int currentColor;
    private long lastUpdateTime;
    private int lastX;
    private int lastY;
    private boolean animationRunning;
    private int[] buffer;
    private int lastWidth;
    private boolean restartOnShowNotify;
    private boolean restartOnTime;

    public FadeInBackground(int targetArgbColor, boolean restartOnTime, boolean restartOnShowNotify) {
        this.animationRunning = true;
        this.targetArgbColor = targetArgbColor;
        this.restartOnTime = restartOnTime;
        this.restartOnShowNotify = restartOnShowNotify;
        this.currentColor = 0xFFFFFF & targetArgbColor;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (width != this.lastWidth) {
            this.lastWidth = width;
            int[] newBuffer = new int[width];
            int i = width;
            while (--i >= 0) {
                newBuffer[i] = this.currentColor;
            }
            this.buffer = newBuffer;
        }
        if (x != this.lastX || y != this.lastY) {
            this.lastX = x;
            this.lastY = y;
        }
        if (x < 0) {
            if ((width += x) < 0) {
                return;
            }
            x = 0;
        }
        if (y < 0) {
            if ((height += y) < 0) {
                return;
            }
            y = 0;
        }
        g.drawRGB(this.buffer, 0, 0, x, y, width, height, true);
        this.lastX = x;
        this.lastY = y;
    }

    public boolean animate() {
        if (!this.animationRunning) {
            return false;
        }
        if (this.restartOnTime) {
            this.lastUpdateTime = System.currentTimeMillis();
        }
        if (this.buffer == null) {
            return false;
        }
        int currentTranslucency = this.currentColor >>> 24;
        int targetTranslucency = this.targetArgbColor >>> 24;
        if ((currentTranslucency += 20) > targetTranslucency) {
            currentTranslucency = targetTranslucency;
            this.animationRunning = false;
        }
        this.currentColor = 0xFFFFFF & this.targetArgbColor | currentTranslucency << 24;
        int i = this.buffer.length;
        while (--i >= 0) {
            this.buffer[i] = this.currentColor;
        }
        return true;
    }

    public void showNotify() {
        super.showNotify();
        boolean restart = false;
        if (this.restartOnShowNotify) {
            restart = true;
        } else if (this.restartOnTime) {
            long updateTime = System.currentTimeMillis();
            restart = updateTime - this.lastUpdateTime > 5000L;
            this.lastUpdateTime = updateTime;
        }
        if (restart) {
            this.currentColor = 0xFFFFFF & this.targetArgbColor;
            this.animationRunning = true;
            this.animate();
        }
    }

    public FadeInBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animationRunning = dataInputStream.readBoolean();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.buffer = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.buffer[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.currentColor = dataInputStream.readInt();
        this.lastUpdateTime = dataInputStream.readLong();
        this.lastWidth = dataInputStream.readInt();
        this.lastX = dataInputStream.readInt();
        this.lastY = dataInputStream.readInt();
        this.restartOnShowNotify = dataInputStream.readBoolean();
        this.restartOnTime = dataInputStream.readBoolean();
        this.targetArgbColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animationRunning);
        if (this.buffer == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.buffer.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.buffer[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.currentColor);
        dataOutputStream.writeLong(this.lastUpdateTime);
        dataOutputStream.writeInt(this.lastWidth);
        dataOutputStream.writeInt(this.lastX);
        dataOutputStream.writeInt(this.lastY);
        dataOutputStream.writeBoolean(this.restartOnShowNotify);
        dataOutputStream.writeBoolean(this.restartOnTime);
        dataOutputStream.writeInt(this.targetArgbColor);
    }
}

