/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class BorderedRoundTabBackground
extends Background {
    private int color;
    private int arcWidth;
    private int arcHeight;
    private int borderColor;

    public BorderedRoundTabBackground(int color2, int arcWidth, int arcHeight, int borderColor, int borderWidth) {
        this.color = color2;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int border;
        g.setColor(this.color);
        g.fillRoundRect(x, y, width, height, this.arcWidth, this.arcHeight);
        g.setColor(this.borderColor);
        g.drawRoundRect(x, y, --width, --height, this.arcWidth, this.arcHeight);
        for (border = this.borderWidth - 1; border > 0; --border) {
            g.drawRoundRect(x + border, y + border, width - (border << 1), height - (border << 1), this.arcWidth, this.arcHeight);
        }
        g.setColor(this.color);
        y += height / 2;
        if ((height & 1) == 1) {
            ++y;
        }
        g.fillRect(x + this.borderWidth, y, width - 2 * this.borderWidth + 1, (height /= 2) + 1);
        g.setColor(this.borderColor);
        g.drawLine(x, y, x, y + height);
        g.drawLine(x + width, y, x + width, y + height);
        g.drawLine(x, y + height, x + width, y + height);
        for (border = this.borderWidth - 1; border > 0; --border) {
            g.drawLine(x + border, y, x + border, y + height);
            g.drawLine(x + width - border, y, x + width - border, y + height);
            g.drawLine(x, y + height - border, x + width, y + height - border);
        }
    }

    public BorderedRoundTabBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.borderColor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.borderColor);
        dataOutputStream.writeInt(this.color);
    }
}

