/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.midp.ui.TextBox;
import de.enough.polish.ui.Alert;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.List;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.DeviceControl;
import de.enough.polish.util.DeviceInfo;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.Locale;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextField
extends StringItem
implements CommandListener,
ItemCommandListener {
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int FIXED_POINT_DECIMAL = 20;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    public static final int INITIAL_CAPS_NEVER = 0x400000;
    public static final int CONSTRAINT_MASK = 65535;
    private static final int CLEAR_PRIORITY = 8;
    private static final int CLEAR_TYPE = 8;
    public static Command CLEAR_CMD = new Command(Locale.get(159), 8, 8);
    private static final int DELETE_PRIORITY = 1;
    private static final int DELETE_TYPE = 8;
    public static Command DELETE_CMD = new Command(Locale.get(160), 8, 1);
    private static final String VALID_LOCAL_EMAIL_ADDRESS_CHARACTERS = ".-_@!#$%&'*+/=?^`{|}~";
    private static final String VALID_DOMAIN_CHARACTERS = "._-";
    private int maxSize;
    private int constraints = -1;
    private char editingCaretChar = (char)124;
    protected char caretChar = (char)124;
    protected boolean showCaret;
    private long lastCaretSwitch;
    protected String title;
    private String passwordText;
    private boolean isPassword;
    private boolean enableDirectInput;
    private boolean noNewLine = false;
    private boolean noComplexInput = false;
    private ItemCommandListener additionalItemCommandListener;
    protected int inputMode;
    protected static List symbolsList;
    protected static String[] definedSymbols;
    private static int ENTER_SYMBOL_PRIORITY;
    public static Command ENTER_SYMBOL_CMD;
    private boolean isKeyDown;
    private static final int INPUT_TIMEOUT = 1000;
    public static final int MODE_LOWERCASE = 0;
    public static final int MODE_FIRST_UPPERCASE = 1;
    public static final int MODE_UPPERCASE = 2;
    public static final int MODE_NUMBERS = 3;
    public static final int MODE_NATIVE = 4;
    public static final int KEY_CHANGE_MODE;
    public static final int KEY_DELETE = -8;
    private static final int KEY_SHIFT = -50;
    private boolean nextCharUppercase;
    private String[] realTextLines;
    private String originalRowText;
    private int caretPosition;
    private int caretColumn;
    private int caretRow;
    private int caretRowWidth;
    private int caretX;
    private int caretY;
    private int caretWidth;
    private int lastKey;
    long lastInputTime;
    private int characterIndex;
    private static String charactersKey1;
    private static String charactersKey2;
    private static String charactersKey3;
    private static String charactersKey4;
    private static String charactersKey5;
    private static String charactersKey6;
    private static String charactersKey7;
    private static String charactersKey8;
    private static String charactersKey9;
    protected static String charactersKey0;
    protected static String charactersKeyStar;
    protected static String charactersKeyPound;
    public static String[] CHARACTERS;
    private static final String[] EMAIL_CHARACTERS;
    private String[] characters;
    private boolean isNumeric;
    private boolean isDecimal;
    private boolean isEmail;
    private boolean isUrl;
    private int rowHeight;
    protected final Object lock = new Object();
    private long deleteKeyRepeatCount;
    protected char emailSeparatorChar = (char)59;
    private TextBox midpTextBox;
    private boolean skipKeyReleasedEvent = false;
    private boolean cskOpensNativeEditor = true;
    protected boolean flashCaret = true;
    protected boolean isUneditable;
    private boolean isShowInputInfo = true;
    private boolean suppressCommands = false;
    private StringItem helpItem;
    private boolean isKeyPressedHandled;
    private int numberOfDecimalFractions = 2;

    public TextField(String label, String text, int maxSize, int constraints) {
        this(label, text, maxSize, constraints, null);
    }

    public TextField(String label, String text, int maxSize, int constraints, Style style) {
        super(label, null, 3, style);
        int spaceKey = DeviceInfo.getKeySpace();
        if (spaceKey == 35) {
            charactersKey0 = "0";
            charactersKeyPound = " ";
        }
        this.maxSize = maxSize;
        this.title = label != null ? label : "Input";
        if ((constraints & 0x10000) == 65536) {
            this.isPassword = true;
        }
        this.enableDirectInput = true;
        this.setConstraints(constraints);
        this.helpItem = new StringItem(null, null, StyleSheet.helpStyle);
        this.helpItem.setText("type text here");
        this.setString(text);
    }

    private void createTextBox() {
        String currentText = this.isPassword ? this.passwordText : this.text;
        this.midpTextBox = new TextBox(this.title, currentText, this.maxSize, this.getMidpConstraints());
        this.midpTextBox.addCommand(StyleSheet.OK_CMD);
        if (!this.isUneditable) {
            this.midpTextBox.addCommand(StyleSheet.CANCEL_CMD);
        }
        this.midpTextBox.setCommandListener(this);
        if ((this.constraints & 0x400000) == 0x400000) {
            this.midpTextBox.setInitialInputMode("MIDP_LOWERCASE_LATIN");
        }
    }

    public int getMidpConstraints() {
        int cont = this.constraints;
        if ((cont & 0x14) == 20) {
            cont = cont & 0xFFFFFFEB | 5;
        }
        return cont;
    }

    public String getString() {
        if (this.isPassword) {
            if (this.passwordText == null) {
                return "";
            }
            return this.passwordText;
        }
        if (this.text == null) {
            return "";
        }
        return this.text;
    }

    public String getDotSeparatedDecimalString() {
        if (!this.isDecimal) {
            throw new IllegalStateException();
        }
        String value = this.getString();
        if ((this.constraints & 0x14) == 20) {
            StringBuffer buffer = new StringBuffer(value.length());
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == Locale.DECIMAL_SEPARATOR) {
                    buffer.append('.');
                    continue;
                }
                if (c == Locale.GROUPING_SEPARATOR) continue;
                buffer.append(c);
            }
            return buffer.toString();
        }
        if (Locale.DECIMAL_SEPARATOR == '.' || value == null) {
            return value;
        }
        return value.replace(Locale.DECIMAL_SEPARATOR, '.');
    }

    public void setString(String text) {
        int fieldType;
        if (text != null && text.length() > 0 && (fieldType = this.constraints & 0xFFFF) == 20) {
            int lengthBefore = text.length();
            int lengthAfter = (text = this.convertToFixedPointDecimal(text, true)).length();
            if (lengthAfter > lengthBefore) {
                this.setCaretPosition(this.getCaretPosition() + lengthAfter - lengthBefore);
            }
        }
        if (this.midpTextBox != null) {
            this.midpTextBox.setString(text);
        }
        if (this.isPassword) {
            this.passwordText = text;
            if (text != null) {
                int length = text.length();
                StringBuffer buffer = new StringBuffer(length);
                for (int i = 0; i < length; ++i) {
                    buffer.append('*');
                }
                text = buffer.toString();
            }
        }
        if (text == null) {
            this.caretPosition = 0;
            this.caretRow = 0;
            this.caretColumn = 0;
            this.caretX = 0;
            this.caretY = 0;
        } else if (this.caretPosition == 0 && (this.text == null || this.text.length() == 0) || this.caretPosition > text.length() || this.text != null && text != null && text.length() > this.text.length() + 1) {
            this.caretPosition = text.length();
        }
        if (this.isFocused) {
            this.updateDeleteCommand(text);
        }
        this.setText(text);
        if ((text == null || text.length() == 0) && this.inputMode == 1) {
            this.nextCharUppercase = true;
        }
    }

    public void setNumberOfDecimalFractions(int number) {
        this.numberOfDecimalFractions = number;
    }

    public int getNumberOfDecimalFractions() {
        return this.numberOfDecimalFractions;
    }

    protected String convertToFixedPointDecimal(String original) {
        return this.convertToFixedPointDecimal(original, false);
    }

    protected String convertToFixedPointDecimal(String original, boolean addGroupingSeparator) {
        int numberBeforeDecimalSeparator;
        char c;
        int fractions = this.numberOfDecimalFractions;
        StringBuffer buffer = new StringBuffer(original.length() + 3);
        int added = 0;
        int i = original.length();
        while (--i >= 0) {
            char c2 = original.charAt(i);
            if (c2 < '0' || c2 > '9') continue;
            buffer.insert(0, c2);
            if (++added != fractions) continue;
            buffer.insert(0, Locale.DECIMAL_SEPARATOR);
        }
        ++fractions;
        while (added > fractions && (c = buffer.charAt(0)) == '0') {
            buffer.deleteCharAt(0);
            --added;
        }
        while (added < fractions) {
            buffer.insert(0, '0');
            if (++added != fractions - 1) continue;
            buffer.insert(0, Locale.DECIMAL_SEPARATOR);
        }
        if (addGroupingSeparator && (numberBeforeDecimalSeparator = buffer.length() - fractions - 1) >= 3) {
            for (int i2 = 3; i2 <= numberBeforeDecimalSeparator; i2 += 3) {
                int pos = numberBeforeDecimalSeparator - i2 + 1;
                buffer.insert(pos, Locale.GROUPING_SEPARATOR);
            }
        }
        original = buffer.toString();
        return original;
    }

    protected void updateDeleteCommand(String newText) {
        if (!this.isUneditable) {
            if (newText == null || this.caretPosition == 0 && this.caretChar == this.editingCaretChar) {
                this.removeCommand(DELETE_CMD);
            } else if (this.text == null || this.text.length() == 0 || this.caretPosition > 0) {
                this.addCommand(DELETE_CMD);
            }
        }
    }

    public int getChars(char[] data) {
        if (this.text == null) {
            return 0;
        }
        String txt = this.text;
        if (this.isPassword) {
            txt = this.passwordText;
        }
        char[] textArray = txt.toCharArray();
        System.arraycopy(textArray, 0, data, 0, textArray.length);
        return textArray.length;
    }

    public void setChars(char[] data, int offset, int length) {
        char[] copy = new char[length];
        System.arraycopy(data, offset, copy, 0, length);
        this.setString(new String(copy));
    }

    public void insert(String src, int position) {
        String txt = this.getString();
        String start = txt.substring(0, position);
        String end = txt.substring(position);
        this.setString(start + src + end);
        if (position == this.caretPosition) {
            this.caretPosition += src.length();
        }
    }

    public void insert(char[] data, int offset, int length, int position) {
        char[] copy = new char[length];
        System.arraycopy(data, offset, copy, 0, length);
        this.insert(new String(copy), position);
    }

    public void delete(int offset, int length) {
        String txt = this.getString();
        String start = txt.substring(0, offset);
        String end = txt.substring(offset + length);
        this.setString(start + end);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int setMaxSize(int maxSize) {
        if (this.text != null && maxSize < this.text.length() || maxSize < 1) {
            throw new IllegalArgumentException();
        }
        if (this.midpTextBox != null) {
            this.maxSize = this.midpTextBox.setMaxSize(maxSize);
            return this.maxSize;
        }
        this.maxSize = maxSize;
        return maxSize;
    }

    public int size() {
        if (this.text == null) {
            return 0;
        }
        return this.text.length();
    }

    public int getCaretPosition() {
        int curPos = 0;
        curPos = this.caretPosition;
        return curPos;
    }

    public void setCaretPosition(int position) {
        this.caretPosition = position;
        if (this.isInitialized && this.realTextLines != null) {
            int row = 0;
            int col = 0;
            int passedCharacters = 0;
            String textLine = null;
            for (int i = 0; i < this.textLines.size(); ++i) {
                textLine = this.realTextLines[i];
                if ((passedCharacters += textLine.length()) < position) continue;
                row = i;
                col = textLine.length() - (passedCharacters - position);
                break;
            }
            this.caretRow = row;
            this.caretColumn = col;
            textLine = this.textLines.getLine(row);
            String firstPart = this.caretColumn < textLine.length() ? textLine.substring(0, this.caretColumn) : textLine;
            this.caretX = this.isPassword ? this.stringWidth("*") * firstPart.length() : this.stringWidth(firstPart);
            this.caretY = this.internalY = this.caretRow * this.rowHeight;
            this.repaint();
        }
    }

    public void setConstraints(int constraints) {
        if (constraints == this.constraints) {
            return;
        }
        this.constraints = constraints;
        int fieldType = constraints & 0xFFFF;
        boolean bl = this.isUneditable = (constraints & 0x20000) == 131072;
        if (this.midpTextBox != null) {
            this.midpTextBox.setConstraints(constraints);
        }
        if ((constraints & 0x10000) == 65536) {
            this.isPassword = true;
        }
        this.characters = CHARACTERS;
        this.isEmail = false;
        this.isUrl = false;
        if ((constraints & 0x10000) == 65536) {
            this.isPassword = true;
        }
        if (fieldType == 2 || fieldType == 3) {
            this.isNumeric = true;
            this.inputMode = 3;
        } else {
            this.isNumeric = false;
        }
        if (fieldType == 5 || fieldType == 20) {
            this.isNumeric = true;
            this.isDecimal = true;
            this.inputMode = 3;
        } else {
            this.isDecimal = false;
        }
        if (fieldType == 1) {
            this.isEmail = true;
            this.characters = EMAIL_CHARACTERS;
        }
        if (fieldType == 4) {
            this.isUrl = true;
        }
        if ((constraints & 0x100000) == 0x100000) {
            this.inputMode = 1;
            this.nextCharUppercase = true;
        }
        this.removeCommand(DELETE_CMD);
        this.removeCommand(CLEAR_CMD);
        this.removeCommand(ENTER_SYMBOL_CMD);
        if (!this.suppressCommands) {
            if (this.isFocused) {
                this.getScreen().removeItemCommands(this);
            }
            if (!this.isUneditable) {
                String delLabel = Locale.get(160);
                if (delLabel != DELETE_CMD.getLabel()) {
                    DELETE_CMD = new Command(delLabel, 3, 1);
                }
                this.addCommand(DELETE_CMD);
            }
            if (!this.isUneditable) {
                String clearLabel = Locale.get(159);
                if (clearLabel != CLEAR_CMD.getLabel()) {
                    CLEAR_CMD = new Command(clearLabel, 8, 8);
                }
                this.addCommand(CLEAR_CMD);
            }
            if (!this.isNumeric && !this.isUneditable) {
                String enterSymbolLabel = Locale.get(161);
                if (enterSymbolLabel != ENTER_SYMBOL_CMD.getLabel()) {
                    ENTER_SYMBOL_CMD = new Command(enterSymbolLabel, 8, ENTER_SYMBOL_PRIORITY);
                }
                this.addCommand(ENTER_SYMBOL_CMD);
            }
        }
        this.itemCommandListener = this;
        if (this.isFocused) {
            this.showCommands();
        }
    }

    public void activate(boolean editable) {
    }

    public void setEditable(boolean editable) {
    }

    public int getConstraints() {
        return this.constraints;
    }

    public void setInitialInputMode(String characterSubset) {
        if (this.midpTextBox == null) {
            this.createTextBox();
        }
        this.midpTextBox.setInitialInputMode(characterSubset);
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int cY;
        int cX;
        if (this.isUneditable || !this.isFocused) {
            if (this.text == null || this.text.length() == 0) {
                this.helpItem.paint(x, y, leftBorder, rightBorder, g);
            } else {
                super.paintContent(x, y, leftBorder, rightBorder, g);
            }
            return;
        }
        int availWidth = rightBorder - leftBorder;
        int availHeight = this.availableHeight;
        if (this.text == null || this.text.length() == 0) {
            this.helpItem.paint(x, y, leftBorder, rightBorder, g);
        } else if (this.isPassword && !this.showCaret && !this.isNumeric && this.caretChar != this.editingCaretChar) {
            int h;
            cX = this.getCaretXPosition(x, rightBorder, availWidth);
            cY = y + this.caretY;
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            g.clipRect(x, y, cX - x, clipHeight);
            super.paintContent(x, y, leftBorder, rightBorder, g);
            g.setClip(clipX, clipY, clipWidth, clipHeight);
            int w = this.caretWidth;
            int starWidth = this.charWidth('*');
            if (starWidth > w) {
                w = starWidth;
            }
            if (this.caretX + w < this.contentWidth) {
                g.clipRect(cX + w, y, clipWidth, clipHeight);
                super.paintContent(x, y, leftBorder, rightBorder, g);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
            if (cY > y) {
                g.clipRect(clipX, clipY, clipWidth, cY - clipY);
                super.paintContent(x, y, leftBorder, rightBorder, g);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
            if (this.caretY + (h = this.getFontHeight()) < this.contentHeight) {
                g.clipRect(x, cY + h, clipWidth, clipHeight);
                super.paintContent(x, y, leftBorder, rightBorder, g);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
            g.setColor(this.textColor);
            int anchor = 20;
            g.drawChar(this.caretChar, cX, cY, anchor);
        } else {
            super.paintContent(x, y, leftBorder, rightBorder, g);
        }
        if (this.showCaret) {
            g.setColor(this.textColor);
            cX = this.getCaretXPosition(x, rightBorder, availWidth);
            cY = y + this.caretY;
            if (this.caretChar != this.editingCaretChar) {
                int starWidth;
                int w = this.caretWidth;
                if (this.isPassword && (starWidth = this.charWidth('*')) > w) {
                    w = starWidth;
                }
                int h = this.getFontHeight();
                g.fillRect(cX, cY, w, h);
                g.setColor(DrawUtil.getComplementaryColor(g.getColor()));
                int anchor = 20;
                g.drawChar(this.caretChar, cX, cY, anchor);
            } else {
                g.drawLine(cX, cY, cX, cY + this.getFontHeight() - 2);
            }
        }
    }

    private int getCaretXPosition(int x, int rightBorder, int availWidth) {
        int cX = x + this.caretX;
        return cX;
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        this.screen = this.getScreen();
        super.initContent(firstLineWidth, availWidth, availHeight);
        UiAccess.init(this.helpItem, firstLineWidth, availWidth, availHeight);
        if (this.font == null) {
            this.font = Font.getDefaultFont();
        }
        if (this.contentHeight < this.getFontHeight()) {
            this.contentHeight = this.getFontHeight();
        }
        this.rowHeight = this.getFontHeight() + this.paddingVertical;
        if (this.textLines == null || this.text == null || this.text.length() == 0) {
            this.caretX = 0;
            this.caretY = 0;
            this.caretPosition = 0;
            this.caretColumn = 0;
            this.caretRow = 0;
            this.originalRowText = "";
            this.realTextLines = null;
        } else {
            int length = this.textLines.size();
            int textLength = this.text.length();
            String[] realLines = this.realTextLines;
            if (realLines == null || realLines.length != length) {
                realLines = new String[length];
            }
            boolean caretPositionHasBeenSet = false;
            int cp = this.caretPosition;
            int endOfLinePos = 0;
            for (int i = 0; i < length; ++i) {
                char c;
                String line = this.textLines.getLine(i);
                if ((endOfLinePos += line.length()) < textLength && ((c = this.text.charAt(endOfLinePos)) == ' ' || c == '\t' || c == '\n')) {
                    line = line + c;
                    ++endOfLinePos;
                }
                realLines[i] = line;
                if (caretPositionHasBeenSet || endOfLinePos <= cp && (endOfLinePos != cp || i != length - 1)) continue;
                this.caretRow = i;
                this.setCaretRow(line, line.length() - (endOfLinePos - cp));
                this.caretY = this.caretRow * this.rowHeight;
                caretPositionHasBeenSet = true;
            }
            this.realTextLines = realLines;
            if (!caretPositionHasBeenSet) {
                this.caretRow = 0;
                String caretRowText = this.realTextLines[this.caretRow];
                int caretRowLength = caretRowText.length();
                if (caretRowLength > 0 && caretRowText.charAt(caretRowLength - 1) == '\n') {
                    caretRowText = caretRowText.substring(0, caretRowLength - 1);
                }
                this.setCaretRow(caretRowText, caretRowLength);
                this.caretPosition = this.caretColumn;
                this.caretY = 0;
                this.textLines.setLine(0, this.textLines.getLine(0) + " ");
            }
        }
        this.internalX = 0;
        this.internalY = this.caretY;
        this.internalWidth = this.contentWidth;
        this.internalHeight = this.rowHeight;
        this.screen = this.getScreen();
        if (this.isFocused && this.parent instanceof Container) {
            ((Container)this.parent).scroll(0, this, true);
        }
    }

    private void setCaretRow(String line, int column) {
        String caretRowFirstPart;
        this.originalRowText = line;
        int length = line.length();
        if (column > length) {
            column = length;
        }
        this.caretColumn = column;
        boolean endsInLineBreak = length >= 1 && line.charAt(length - 1) == '\n';
        boolean firstPartIsFullRow = false;
        if (column == length || endsInLineBreak && column == length - 1) {
            caretRowFirstPart = endsInLineBreak ? line.substring(0, length - 1) : line;
            firstPartIsFullRow = true;
        } else {
            caretRowFirstPart = line.substring(0, column);
        }
        this.caretX = this.isPassword ? this.stringWidth("*") * caretRowFirstPart.length() : this.stringWidth(caretRowFirstPart);
        if (this.isLayoutCenter || this.isLayoutRight) {
            this.caretRowWidth = firstPartIsFullRow ? this.caretX : this.stringWidth(line);
        }
    }

    protected String createCssSelector() {
        return "textfield";
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        if (this.font == null) {
            this.font = Font.getDefaultFont();
        }
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
    }

    protected boolean isValidInput(char insertChar, int position, String myText) {
        boolean isValidInput;
        if (!this.isEmail) {
            return true;
        }
        char lowerCaseInsertChar = Character.toLowerCase(insertChar);
        boolean bl = isValidInput = insertChar >= '0' && insertChar <= '9' || lowerCaseInsertChar >= 'a' && lowerCaseInsertChar <= 'z';
        if (!isValidInput) {
            boolean isInLocalPart = true;
            String emailAddressText = myText;
            int atPosition = -1;
            int relativeCaretPosition = this.caretPosition;
            if (emailAddressText != null) {
                int separatorPosition;
                while ((separatorPosition = emailAddressText.indexOf(this.emailSeparatorChar)) != -1) {
                    if (separatorPosition < this.caretPosition) {
                        emailAddressText = emailAddressText.substring(separatorPosition + 1);
                        relativeCaretPosition -= separatorPosition;
                        continue;
                    }
                    emailAddressText = emailAddressText.substring(0, separatorPosition);
                    break;
                }
                boolean bl2 = isInLocalPart = (atPosition = emailAddressText.indexOf(64)) == -1 || atPosition >= this.caretPosition;
            }
            if (isInLocalPart) {
                boolean isAtFirstChar = emailAddressText == null || relativeCaretPosition == 0;
                isValidInput = !(VALID_LOCAL_EMAIL_ADDRESS_CHARACTERS.indexOf(insertChar) == -1 || insertChar == '.' && isAtFirstChar || atPosition != -1 && insertChar == '@' && atPosition != position || insertChar == '@' && isAtFirstChar);
            } else {
                boolean bl3 = isValidInput = VALID_DOMAIN_CHARACTERS.indexOf(insertChar) != -1;
            }
            if (!isValidInput) {
                // empty if block
            }
        }
        return isValidInput;
    }

    protected void commitCurrentCharacter() {
        char insertChar = this.caretChar;
        String myText = this.isPassword ? this.passwordText : this.text;
        if (!this.isValidInput(insertChar, this.caretPosition, myText)) {
            return;
        }
        this.caretChar = this.editingCaretChar;
        ++this.caretPosition;
        ++this.caretColumn;
        this.caretX = this.isPassword ? (this.caretX += this.stringWidth("*")) : (this.caretX += this.caretWidth);
        boolean nextCharInputHasChanged = false;
        nextCharInputHasChanged = this.nextCharUppercase;
        this.nextCharUppercase = (this.inputMode == 1 || this.nextCharUppercase) && insertChar == ' ' || insertChar == '.' && !this.isEmail && !this.isUrl && (this.constraints & 0x400000) != 0x400000;
        boolean bl = nextCharInputHasChanged = this.nextCharUppercase != nextCharInputHasChanged;
        if (this.inputMode == 1) {
            this.inputMode = 0;
        }
        this.notifyStateChanged();
    }

    protected void insertCharacter(char insertChar, boolean append, boolean commit) {
        StringBuffer buffer;
        if (append && this.text != null && this.text.length() >= this.maxSize) {
            return;
        }
        int cp = this.caretPosition;
        String myText = this.getString();
        if (!this.isValidInput(insertChar, cp, myText)) {
            return;
        }
        if (myText == null || myText.length() == 0) {
            myText = "" + insertChar;
        } else if (append) {
            buffer = new StringBuffer(myText.length() + 1);
            buffer.append(myText.substring(0, cp)).append(insertChar);
            if (cp < myText.length()) {
                buffer.append(myText.substring(cp));
            }
            myText = buffer.toString();
        } else {
            buffer = new StringBuffer(myText.length());
            buffer.append(myText.substring(0, cp)).append(insertChar);
            if (cp < myText.length() - 1) {
                buffer.append(myText.substring(this.caretPosition + 1));
            }
            myText = buffer.toString();
        }
        boolean nextCharInputHasChanged = false;
        if (commit) {
            ++this.caretPosition;
            ++this.caretColumn;
            nextCharInputHasChanged = this.nextCharUppercase;
            this.nextCharUppercase = (this.inputMode == 1 || this.nextCharUppercase) && insertChar == ' ' || insertChar == '.' && !this.isEmail && !this.isUrl;
            boolean bl = nextCharInputHasChanged = this.nextCharUppercase != nextCharInputHasChanged;
            if (this.inputMode == 1) {
                this.inputMode = 0;
            }
            this.caretChar = this.editingCaretChar;
        }
        this.setString(myText);
        if (!commit) {
            if (myText.length() == 1) {
                this.caretPosition = 0;
            }
        } else {
            this.notifyStateChanged();
        }
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean animate() {
        if (!this.isFocused) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            if (this.caretChar != this.editingCaretChar) {
                if (!this.isKeyDown && currentTime - this.lastInputTime >= 1000L) {
                    this.commitCurrentCharacter();
                }
            } else if (this.isKeyDown && this.deleteKeyRepeatCount != 0L && this.deleteKeyRepeatCount % 3L == 0L && this.text != null && this.caretPosition > 0) {
                if (this.deleteKeyRepeatCount >= 9L) {
                    String myText = this.text;
                    if (myText != null && myText.length() > 0) {
                        this.setString(null);
                        this.notifyStateChanged();
                    }
                } else if (this.caretPosition > 0) {
                    int nextStop;
                    String myText = this.getString();
                    for (nextStop = this.caretPosition - 1; myText.charAt(nextStop) != ' ' && nextStop > 0; --nextStop) {
                    }
                    this.setString(myText.substring(0, nextStop) + myText.substring(this.caretPosition));
                    this.notifyStateChanged();
                }
            }
        }
        if (!this.flashCaret || this.isUneditable) {
            return false;
        }
        if (currentTime - this.lastCaretSwitch > 500L) {
            this.lastCaretSwitch = currentTime;
            this.showCaret = !this.showCaret;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        this.isKeyPressedHandled = false;
        if (this.inputMode == 4 && (gameAction == 1 && keyCode != 50 || gameAction == 6 && keyCode != 56 || gameAction == 2 && keyCode != 52 || gameAction == 5 && keyCode != 54 || (gameAction != 8 || !this.cskOpensNativeEditor) && this.screen.isSoftKey(keyCode, gameAction))) {
            return false;
        }
        this.isKeyDown = true;
        if (this.inputMode == 4 && keyCode != KEY_CHANGE_MODE) {
            this.showTextBox();
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isUneditable) {
                return false;
            }
            boolean handled = false;
            if (keyCode == -8 || keyCode == 8 && !handled) {
                handled = this.handleKeyClear(keyCode, gameAction);
            }
            if (!handled && keyCode != KEY_CHANGE_MODE) {
                handled = this.handleKeyInsert(keyCode, gameAction);
            }
            if (!(handled || gameAction != 1 && gameAction != 6 && gameAction != 2 && gameAction != 5 && gameAction != 8 || (handled = this.handleKeyNavigation(keyCode, gameAction)) || !this.getScreen().isGameActionFire(keyCode, gameAction) || this.defaultCommand == null)) {
                this.notifyItemPressedStart();
                handled = true;
            }
            this.isKeyPressedHandled = handled;
            return handled;
        }
    }

    protected boolean handleKeyInsert(int keyCode, int gameAction) {
        int currentLength = this.text == null ? 0 : this.text.length();
        char insertChar = (char)(32 + (keyCode - 32));
        if (this.inputMode == 3 && !this.isUneditable) {
            if (keyCode >= 48 && keyCode <= 57) {
                if (currentLength >= this.maxSize) {
                    return true;
                }
                insertChar = Integer.toString(keyCode - 48).charAt(0);
                this.insertCharacter(insertChar, true, true);
                return true;
            }
            if (this.isDecimal && (this.text == null || currentLength < this.maxSize && (keyCode == 35 || keyCode == 42) && this.text.indexOf(Locale.DECIMAL_SEPARATOR) == -1)) {
                insertChar = Locale.DECIMAL_SEPARATOR;
                this.insertCharacter(insertChar, true, true);
                return true;
            }
        }
        if (!this.isNumeric && !this.isUneditable && (currentLength < this.maxSize || currentLength == this.maxSize && this.caretChar != this.editingCaretChar && keyCode == this.lastKey) && (keyCode >= 48 && keyCode <= 57 || keyCode == 35 || keyCode == 42)) {
            String alphabet = keyCode == 35 ? charactersKeyPound : (keyCode == 42 ? charactersKeyStar : this.characters[keyCode - 48]);
            if (alphabet == null || alphabet.length() == 0) {
                return false;
            }
            this.lastInputTime = System.currentTimeMillis();
            int alphabetLength = alphabet.length();
            boolean appendNewCharacter = false;
            if (keyCode == this.lastKey && this.caretChar != this.editingCaretChar) {
                ++this.characterIndex;
                if (this.characterIndex >= alphabetLength) {
                    this.characterIndex = 0;
                }
            } else {
                if (this.caretChar != this.editingCaretChar) {
                    this.commitCurrentCharacter();
                    if (currentLength + 1 > this.maxSize) {
                        return true;
                    }
                }
                appendNewCharacter = true;
                this.characterIndex = 0;
                this.lastKey = keyCode;
            }
            char newCharacter = alphabet.charAt(this.characterIndex);
            if (this.inputMode == 2 || this.nextCharUppercase) {
                newCharacter = Character.toUpperCase(newCharacter);
            }
            this.caretWidth = this.charWidth(newCharacter);
            this.caretChar = newCharacter;
            if (alphabetLength == 1) {
                this.insertCharacter(newCharacter, true, true);
            } else {
                this.insertCharacter(newCharacter, appendNewCharacter, false);
            }
            return true;
        }
        return false;
    }

    protected boolean handleKeyClear(int keyCode, int gameAction) {
        if (this.isUneditable) {
            return false;
        }
        if (this.text != null && this.text.length() > 0) {
            return this.deleteCurrentChar();
        }
        return false;
    }

    protected boolean handleKeyMode(int keyCode, int gameAction) {
        if (keyCode == KEY_CHANGE_MODE && !this.isNumeric && !this.isUneditable) {
            if (this.nextCharUppercase && this.inputMode == 0) {
                this.nextCharUppercase = false;
            } else {
                ++this.inputMode;
            }
            if (this.inputMode > 3) {
                this.inputMode = 0;
            }
            if (this.caretChar != this.editingCaretChar) {
                this.commitCurrentCharacter();
            }
            this.nextCharUppercase = this.inputMode == 1;
            return true;
        }
        return false;
    }

    protected boolean handleKeyNavigation(int keyCode, int gameAction) {
        boolean characterInserted;
        if (this.realTextLines == null) {
            return false;
        }
        char character = this.caretChar;
        boolean bl = characterInserted = character != this.editingCaretChar;
        if (characterInserted) {
            this.commitCurrentCharacter();
        }
        if (this.getScreen().isGameActionFire(keyCode, gameAction) && this.defaultCommand != null && this.itemCommandListener != null) {
            this.itemCommandListener.commandAction(this.defaultCommand, this);
            return true;
        }
        if (gameAction == 1 && keyCode != 50) {
            if (this.caretRow == 0) {
                return false;
            }
            --this.caretRow;
            this.caretY -= this.rowHeight;
            this.internalY = this.caretY;
            String fullLine = this.realTextLines[this.caretRow];
            int previousCaretRowFirstLength = this.caretColumn;
            this.setCaretRow(fullLine, this.caretColumn);
            this.caretPosition -= previousCaretRowFirstLength + (this.originalRowText.length() - this.caretColumn);
            this.internalX = 0;
            this.internalY = this.caretRow * this.rowHeight;
            this.updateDeleteCommand(this.text);
            return true;
        }
        if (gameAction == 6 && keyCode != 56) {
            if (this.textLines == null || this.caretRow >= this.textLines.size() - 1) {
                return false;
            }
            String lastLine = this.originalRowText;
            int lastLineLength = lastLine.length();
            ++this.caretRow;
            this.caretY += this.rowHeight;
            this.internalY = this.caretY;
            int lastCaretRowLastPartLength = lastLineLength - this.caretColumn;
            String nextLine = this.realTextLines[this.caretRow];
            this.setCaretRow(nextLine, this.caretColumn);
            this.caretPosition += lastCaretRowLastPartLength + this.caretColumn;
            this.internalY = this.caretRow * this.rowHeight;
            this.updateDeleteCommand(this.text);
            return true;
        }
        if (gameAction == 2 && keyCode != 52) {
            int column = this.caretColumn;
            if (column > 0) {
                --this.caretPosition;
                this.setCaretRow(this.originalRowText, --column);
                this.updateDeleteCommand(this.text);
                return true;
            }
            if (this.caretRow > 0) {
                boolean isOnNewlineChar;
                --this.caretRow;
                String prevLine = this.realTextLines[this.caretRow];
                int carColumn = prevLine.length();
                boolean bl2 = isOnNewlineChar = prevLine.charAt(carColumn - 1) == '\n';
                if (isOnNewlineChar) {
                    --this.caretPosition;
                    --carColumn;
                }
                this.setCaretRow(prevLine, carColumn);
                this.caretY -= this.rowHeight;
                this.internalY = this.caretY;
                this.updateDeleteCommand(this.text);
                return true;
            }
        } else if (gameAction == 5 && keyCode != 54) {
            boolean isOnNewlineChar;
            if (characterInserted) {
                return true;
            }
            boolean bl3 = isOnNewlineChar = this.caretColumn < this.originalRowText.length() && this.originalRowText.charAt(this.caretColumn) == '\n';
            if (this.caretColumn < this.originalRowText.length() && !isOnNewlineChar) {
                ++this.caretColumn;
                ++this.caretPosition;
                this.setCaretRow(this.originalRowText, this.caretColumn);
                this.updateDeleteCommand(this.text);
                return true;
            }
            if (this.caretRow < this.realTextLines.length - 1) {
                ++this.caretRow;
                if (isOnNewlineChar) {
                    ++this.caretPosition;
                }
                this.originalRowText = this.realTextLines[this.caretRow];
                if (characterInserted) {
                    this.caretX = this.isPassword ? this.stringWidth("*") : this.stringWidth(String.valueOf(character));
                    this.caretColumn = 1;
                } else {
                    this.setCaretRow(this.originalRowText, 0);
                }
                this.caretY += this.rowHeight;
                this.internalY = this.caretY;
                this.updateDeleteCommand(this.text);
                return true;
            }
            if (characterInserted) {
                this.caretX = this.isPassword ? (this.caretX += this.stringWidth("*")) : (this.caretX += this.caretWidth);
                ++this.caretColumn;
                ++this.caretPosition;
                this.updateDeleteCommand(this.text);
                return true;
            }
        }
        return false;
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        if (keyCode >= 48 && keyCode <= 57) {
            int currentLength;
            if (this.isNumeric || this.inputMode == 3) {
                if (keyCode == 48 && this.inputMode == 3 && this.caretPosition == 1 && this.text.charAt(0) == '0') {
                    String str = this.getString();
                    if (str.length() > 0 && str.charAt(0) == '0') {
                        str = str.substring(1);
                    }
                    this.setString("+" + str);
                    return true;
                }
                return false;
            }
            int n = currentLength = this.text == null ? 0 : this.text.length();
            if (!this.isUneditable && currentLength <= this.maxSize) {
                this.lastInputTime = System.currentTimeMillis();
                char newCharacter = Integer.toString(keyCode - 48).charAt(0);
                this.caretWidth = this.charWidth(newCharacter);
                if (newCharacter != this.caretChar) {
                    this.caretChar = newCharacter;
                    this.insertCharacter(newCharacter, false, false);
                }
                return true;
            }
        }
        if (keyCode == -8 && this.caretPosition > 0 && this.text != null) {
            ++this.deleteKeyRepeatCount;
        }
        return false;
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        boolean clearKeyPressed;
        if (!this.enableDirectInput) {
            return super.handleKeyReleased(keyCode, gameAction);
        }
        if (this.skipKeyReleasedEvent) {
            this.skipKeyReleasedEvent = false;
            return true;
        }
        this.isKeyDown = false;
        this.deleteKeyRepeatCount = 0L;
        int clearKey = -8;
        boolean bl = clearKeyPressed = keyCode == clearKey;
        if (keyCode == KEY_CHANGE_MODE && !this.isNumeric && !this.isUneditable) {
            return this.handleKeyMode(keyCode, gameAction) || clearKeyPressed;
        }
        return this.isKeyPressedHandled || clearKeyPressed || super.handleKeyReleased(keyCode, gameAction);
    }

    protected boolean handlePointerReleased(int x, int y) {
        int fieldType;
        if (this.isInItemArea(x, y) && (fieldType = this.constraints & 0xFFFF) != 20) {
            this.notifyItemPressedEnd();
            this.showTextBox();
            return true;
        }
        return super.handlePointerReleased(x, y);
    }

    public void handleOnFocusSoftKeyboardDisplayBehavior() {
        DeviceControl.showSoftKeyboard();
    }

    private synchronized boolean deleteCurrentChar() {
        String myText = this.isPassword ? this.passwordText : this.text;
        int position = this.caretPosition;
        if (this.caretChar != this.editingCaretChar) {
            myText = myText.substring(0, position) + myText.substring(position + 1);
            this.caretChar = this.editingCaretChar;
            this.caretPosition = position;
            this.setString(myText);
            return true;
        }
        if (position > 0) {
            myText = myText.substring(0, --position) + myText.substring(position + 1);
            this.caretPosition = position;
            this.setString(myText);
            this.notifyStateChanged();
            return true;
        }
        return false;
    }

    protected void showTextBox() {
        if (this.midpTextBox == null) {
            this.createTextBox();
        }
        if (StyleSheet.currentScreen != null) {
            this.screen = StyleSheet.currentScreen;
        } else if (this.screen == null) {
            this.screen = this.getScreen();
        }
        StyleSheet.display.setCurrent(this.midpTextBox);
    }

    public void commandAction(Command cmd, Displayable box) {
        if (box instanceof List) {
            if (cmd != StyleSheet.CANCEL_CMD) {
                int index = symbolsList.getSelectedIndex();
                this.insert(definedSymbols[index], this.caretPosition);
                StyleSheet.currentScreen = this.screen;
                this.updateDeleteCommand(this.text);
            } else {
                StyleSheet.currentScreen = this.screen;
            }
            StyleSheet.display.setCurrent(this.screen);
            this.notifyStateChanged();
            return;
        }
        if (cmd == StyleSheet.CANCEL_CMD) {
            this.midpTextBox.setString(this.text);
            this.skipKeyReleasedEvent = true;
        } else if (!this.isUneditable) {
            this.setString(this.midpTextBox.getString());
            this.setCaretPosition(this.size());
            this.notifyStateChanged();
            this.skipKeyReleasedEvent = true;
        }
        StyleSheet.display.setCurrent(this.screen);
    }

    public void setItemCommandListener(ItemCommandListener l) {
        this.additionalItemCommandListener = l;
    }

    public ItemCommandListener getItemCommandListener() {
        return this.additionalItemCommandListener;
    }

    public static void initSymbolsList() {
        if (symbolsList == null) {
            symbolsList = new List(ENTER_SYMBOL_CMD.getLabel(), 3, StyleSheet.textfieldsymbollistStyle);
            for (int i = 0; i < definedSymbols.length; ++i) {
                symbolsList.append(definedSymbols[i], null, StyleSheet.textfieldsymbolitemStyle);
            }
            symbolsList.addCommand(StyleSheet.CANCEL_CMD);
        }
    }

    private void showSymbolsList() {
        if (this.caretChar != this.editingCaretChar) {
            this.commitCurrentCharacter();
        }
        TextField.initSymbolsList();
        symbolsList.setCommandListener(this);
        StyleSheet.display.setCurrent(symbolsList);
    }

    public void commandAction(Command cmd, Item item) {
        if (cmd.commandAction(this, null)) {
            return;
        }
        if (cmd == ENTER_SYMBOL_CMD) {
            this.showSymbolsList();
            return;
        }
        if (cmd == DELETE_CMD) {
            if (this.text != null && this.text.length() > 0) {
                this.handleKeyClear(-8, 0);
                return;
            }
        } else if (cmd == CLEAR_CMD) {
            this.setString(null);
            this.notifyStateChanged();
        } else if (this.additionalItemCommandListener != null) {
            this.additionalItemCommandListener.commandAction(cmd, item);
        } else {
            CommandListener listener;
            Screen scr = this.getScreen();
            if (scr != null && (listener = scr.getCommandListener()) != null) {
                listener.commandAction(cmd, scr);
            }
        }
    }

    protected Style focus(Style focStyle, int direction) {
        this.setCaretPosition(this.getString().length());
        Style unfocusedStyle = super.focus(focStyle, direction);
        this.updateDeleteCommand(this.text);
        return unfocusedStyle;
    }

    public void setInputMode(int inputMode) {
        this.inputMode = inputMode;
        if (this.caretChar != this.editingCaretChar) {
            this.commitCurrentCharacter();
        }
        this.nextCharUppercase = inputMode == 1;
    }

    public int getInputMode() {
        return this.inputMode;
    }

    public void setShowInputInfo(boolean show) {
        this.isShowInputInfo = show;
    }

    protected void showNotify() {
        this.updateDeleteCommand(this.text);
        super.showNotify();
    }

    protected void hideNotify() {
        if (this.caretChar != this.editingCaretChar) {
            this.commitCurrentCharacter();
        }
        super.hideNotify();
    }

    public boolean isSuppressCommands() {
        return this.suppressCommands;
    }

    public void setSuppressCommands(boolean suppressCommands) {
        this.suppressCommands = suppressCommands;
        this.setConstraints(this.constraints);
    }

    public void setHelpText(String text) {
        this.helpItem.setText(text);
    }

    public void setHelpText(String text, Style helpStyle) {
        this.helpItem.setText(text);
        if (helpStyle != null) {
            this.helpItem.setStyle(helpStyle);
        }
    }

    public void setHelpStyle() {
    }

    public void setHelpStyle(Style style) {
        this.helpItem.setStyle(style);
    }

    public String getHelpText() {
        String text = null;
        if (this.helpItem != null) {
            text = this.helpItem.getText();
        }
        return text;
    }

    public static String[] getDefinedSymbols() {
        return definedSymbols;
    }

    public ArrayList getPredictiveMatchingWords() {
        return null;
    }

    public void setPredictiveDictionary(String[] words) {
    }

    public void setPredictiveInfo(String info) {
    }

    public void setPredictiveWordNotFoundAlert(Alert alert) {
    }

    public boolean isCskOpensNativeEditor() {
        return this.cskOpensNativeEditor;
    }

    public void setCskOpensNativeEditor(boolean cskOpensNativeEditor) {
        this.cskOpensNativeEditor = cskOpensNativeEditor;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setNoComplexInput(boolean noComplexInput) {
        this.noComplexInput = noComplexInput;
        this.setConstraints(this.constraints);
    }

    public void setNoNewLine(boolean noNewLine) {
        this.noNewLine = noNewLine;
    }

    public boolean isNoNewLine() {
        return this.noNewLine;
    }

    public boolean isEditable() {
        return (this.constraints & 0x20000) != 131072;
    }

    public boolean isConstraintsPhoneNumber() {
        return (this.constraints & 3) == 3;
    }

    public boolean isConstraintsEmail() {
        return (this.constraints & 1) == 1;
    }

    public boolean isConstraintsNumeric() {
        return (this.constraints & 2) == 2;
    }

    public boolean isConstraintsDecimal() {
        return (this.constraints & 5) == 5 || (this.constraints & 0x14) == 20;
    }

    public boolean isConstraintsPassword() {
        return (this.constraints & 0x10000) == 65536;
    }

    static {
        definedSymbols = new String[]{"&", "@", "/", "\\", "<", ">", "(", ")", "{", "}", "[", "]", ".", "+", "-", "*", ":", "_", "\"", "#", "$", "%", ":)", ":(", ";)", ":x", ":D", ":P"};
        ENTER_SYMBOL_PRIORITY = 9;
        ENTER_SYMBOL_CMD = new Command(Locale.get(161), 1, ENTER_SYMBOL_PRIORITY);
        KEY_CHANGE_MODE = DeviceInfo.getKeyInputModeSwitch();
        charactersKey1 = ".,!?\u00bf:/()@_-+1'\";";
        charactersKey2 = "abc2\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7";
        charactersKey3 = "def3\u00e8\u00e9\u00ea\u00eb";
        charactersKey4 = "ghi4\u00ec\u00ed\u00ee\u00ef";
        charactersKey5 = "jkl5";
        charactersKey6 = "mno6\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6";
        charactersKey7 = "pqrs7\u00df";
        charactersKey8 = "tuv8\u00f9\u00fa\u00fb\u00fc";
        charactersKey9 = "wxyz9\u00fd";
        charactersKey0 = " 0";
        charactersKeyStar = ".,!?\u00bf:/@_-+1'\";";
        charactersKeyPound = null;
        CHARACTERS = new String[]{charactersKey0, charactersKey1, charactersKey2, charactersKey3, charactersKey4, charactersKey5, charactersKey6, charactersKey7, charactersKey8, charactersKey9};
        EMAIL_CHARACTERS = new String[]{".-_@!#$%&'*+/=?^`{|}~0", ".-_@!#$%&'*+/=?^`{|}~1", "abc2", "def3", "ghi4", "jkl5", "mno6", "pqrs7", "tuv8", "wxyz9"};
    }
}

