/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TabbedForm;
import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TabBar
extends Item {
    private final ArrayList tabs;
    private Style activeStyle;
    private Style activeFocusedStyle;
    private Style inactiveStyle;
    private Style activeStyleUsed;
    private int activeTabIndex;
    protected boolean handlePointerReleaseEvent;
    private int xOffset;
    private int scrollArrowHeight = 10;
    private int scrollArrowPadding = 2;
    private int scrollArrowColor = 0xFFFFFF;
    private int arrowYOffset;
    private int arrowXOffset;
    private boolean allowRoundtrip;
    private int nextTabIndex;

    public TabBar(String[] tabNames, Image[] tabImages) {
        this(tabNames, tabImages, null);
    }

    public TabBar(String[] tabNames, Image[] tabImages, Style style) {
        super(null, 0, 3, style);
        if (tabImages == null) {
            tabImages = new Image[tabNames.length];
        } else if (tabNames == null) {
            tabNames = new String[tabImages.length];
        }
        this.activeStyle = StyleSheet.defaultStyle;
        this.activeFocusedStyle = StyleSheet.defaultStyle;
        this.inactiveStyle = StyleSheet.defaultStyle;
        this.tabs = new ArrayList(tabNames.length);
        for (int i = 0; i < tabImages.length; ++i) {
            String name = tabNames[i];
            Image image = tabImages[i];
            IconItem tab = new IconItem(name, image, this.inactiveStyle);
            tab.parent = this;
            this.tabs.add(tab);
        }
        ((Item)this.tabs.get((int)0)).style = this.activeStyleUsed = this.activeStyle;
    }

    public void setActiveTab(int index) {
        ((Item)this.tabs.get(this.activeTabIndex)).setStyle(this.inactiveStyle);
        this.activeTabIndex = index;
        ((Item)this.tabs.get(index)).setStyle(this.activeStyleUsed);
        this.setInitialized(false);
        this.nextTabIndex = index;
    }

    protected Style focus(Style newStyle, int direction) {
        this.activeStyleUsed = this.activeFocusedStyle;
        ((Item)this.tabs.get(this.activeTabIndex)).setStyle(this.activeFocusedStyle);
        return super.focus(newStyle, direction);
    }

    protected void defocus(Style originalStyle) {
        this.activeStyleUsed = this.activeStyle;
        ((Item)this.tabs.get(this.activeTabIndex)).setStyle(this.activeStyle);
        super.defocus(originalStyle);
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        Item tab;
        int i;
        int arrowWidth;
        int maxHeight = arrowWidth = this.scrollArrowHeight + 2 * this.scrollArrowPadding;
        int completeWidth = 0;
        int rightBorder = availWidth - arrowWidth;
        int startX = 0;
        if (this.activeTabIndex > 0) {
            startX = arrowWidth;
        }
        if (this.activeTabIndex == 0 || this.activeTabIndex == this.tabs.size() - 1) {
            if (this.activeTabIndex != 0) {
                rightBorder = availWidth;
            }
            availWidth -= maxHeight;
            completeWidth = maxHeight;
        } else {
            availWidth -= 2 * maxHeight;
            completeWidth = 2 * maxHeight;
        }
        int activeTabXPos = 0;
        int activeTabWidth = 0;
        int minHeight = Integer.MAX_VALUE;
        for (i = 0; i < this.tabs.size(); ++i) {
            tab = (Item)this.tabs.get(i);
            int tabHeight = tab.getItemHeight(firstLineWidth, availWidth, availHeight);
            if (tabHeight > maxHeight) {
                maxHeight = tabHeight;
            }
            if (tabHeight < minHeight) {
                minHeight = tabHeight;
            }
            if (i == this.activeTabIndex) {
                activeTabXPos = completeWidth;
                activeTabWidth = tab.itemWidth;
            }
            tab.relativeX = startX;
            tab.relativeY = 0;
            startX += tab.itemWidth;
            completeWidth += tab.itemWidth;
        }
        if (maxHeight > minHeight) {
            for (i = 0; i < this.tabs.size(); ++i) {
                tab = (Item)this.tabs.get(i);
                tab.relativeY = maxHeight - tab.itemHeight;
            }
        }
        this.contentHeight = maxHeight;
        this.contentWidth = completeWidth;
        if (this.activeTabIndex == 0) {
            this.xOffset = 0;
        } else if (this.xOffset + activeTabXPos < arrowWidth) {
            this.xOffset = arrowWidth - activeTabXPos;
        } else if (this.xOffset + activeTabXPos + activeTabWidth > rightBorder) {
            this.xOffset = rightBorder - activeTabWidth - (activeTabXPos - arrowWidth);
        }
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        g.setColor(this.scrollArrowColor);
        int cHeight = this.contentHeight;
        y += (cHeight - this.scrollArrowHeight) / 2;
        int startX = x;
        if (this.activeTabIndex > 0) {
            int arrowX = x + this.scrollArrowPadding;
            int halfWidth = this.scrollArrowHeight >> 1;
            g.fillTriangle(arrowX, y + halfWidth - 1, arrowX + this.scrollArrowHeight, y, arrowX + this.scrollArrowHeight, y + this.scrollArrowHeight);
            startX = arrowX + this.scrollArrowHeight + this.scrollArrowPadding;
        }
        if (this.activeTabIndex < this.tabs.size() - 1) {
            int halfWidth = this.scrollArrowHeight / 2;
            g.fillTriangle(rightBorder -= this.scrollArrowHeight + this.scrollArrowPadding, y, rightBorder, y + this.scrollArrowHeight, rightBorder + this.scrollArrowHeight, y + halfWidth - 1);
            rightBorder -= this.scrollArrowPadding;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(startX, y -= (cHeight - this.scrollArrowHeight) / 2, rightBorder - startX, clipHeight);
        x += this.xOffset;
        for (int i = 0; i < this.tabs.size(); ++i) {
            Item tab = (Item)this.tabs.get(i);
            tab.paint(x + tab.relativeX, y + tab.relativeY, leftBorder, rightBorder, g);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    protected String createCssSelector() {
        return "tabbar";
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        int index = this.activeTabIndex;
        if (gameAction == 5 && index < this.tabs.size() - 1) {
            ++index;
        } else if (gameAction == 2 && index > 0) {
            --index;
        }
        if (index != this.activeTabIndex) {
            this.setActiveTab(index);
            this.notifyStateChanged();
            return true;
        }
        return super.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handlePointerPressed(int x, int y) {
        this.handlePointerReleaseEvent = false;
        if (!this.isInItemArea(x, y)) {
            return false;
        }
        int scrollerWidth = this.scrollArrowHeight + 2 * this.scrollArrowPadding;
        int newActiveTabIndex = this.activeTabIndex;
        if ((this.activeTabIndex > 0 || this.allowRoundtrip) && x <= scrollerWidth) {
            int index = this.activeTabIndex - 1;
            if (index < 0) {
                index = this.tabs.size() - 1;
            }
            newActiveTabIndex = index;
        } else if ((this.activeTabIndex < this.tabs.size() - 1 || this.allowRoundtrip) && x >= this.itemWidth - scrollerWidth) {
            newActiveTabIndex = (this.activeTabIndex + 1) % this.tabs.size();
        } else {
            for (int i = 0; i < this.tabs.size(); ++i) {
                Item tab = (Item)this.tabs.get(i);
                int tabX = tab.relativeX + this.xOffset;
                if (tabX > x || x > tabX + tab.itemWidth) continue;
                newActiveTabIndex = i;
                break;
            }
        }
        int activeTab = this.activeTabIndex;
        if (newActiveTabIndex != activeTab) {
            ((Item)this.tabs.get(newActiveTabIndex)).notifyItemPressedStart();
            this.nextTabIndex = newActiveTabIndex;
            this.handlePointerReleaseEvent = true;
        }
        return this.handlePointerReleaseEvent;
    }

    protected boolean handlePointerReleased(int x, int y) {
        if (this.handlePointerReleaseEvent) {
            this.handlePointerReleaseEvent = false;
            ((Item)this.tabs.get(this.nextTabIndex)).notifyItemPressedEnd();
            if (this.screen instanceof TabbedForm) {
                ((TabbedForm)this.screen).setActiveTab(this.nextTabIndex);
            } else {
                this.setActiveTab(this.nextTabIndex);
                this.notifyStateChanged();
            }
            return true;
        }
        return false;
    }

    public void setImage(int tabIndex, Image image) {
        Object tab = this.tabs.get(tabIndex);
        if (tab instanceof IconItem) {
            ((IconItem)tab).setImage(image);
        } else if (tab instanceof ImageItem) {
            ((ImageItem)tab).setImage(image);
        }
    }

    public void setText(int tabIndex, String text) {
        Object tab = this.tabs.get(tabIndex);
        if (tab instanceof StringItem) {
            ((StringItem)tab).setText(text);
        } else if (tab instanceof ImageItem) {
            ((ImageItem)tab).setAltText(text);
        }
    }

    public int getNextTab() {
        return this.nextTabIndex;
    }

    public void addNewTab(String tabName, Image tabImage) {
        this.addNewTab(tabName, tabImage, this.inactiveStyle);
    }

    public void addNewTab(String tabName, Image tabImage, Style tabStyle) {
        IconItem tab = new IconItem(tabName, tabImage);
        this.addNewTab(tab, tabStyle);
        this.tabs.add(tab);
    }

    public void addNewTab(Item tab) {
        this.addNewTab(tab, this.inactiveStyle);
    }

    public void addNewTab(Item tab, Style tabStyle) {
        this.tabs.add(tab);
        if (tabStyle != null) {
            tab.setStyle(tabStyle);
        }
        tab.parent = this;
        this.setInitialized(false);
    }

    public void addNewTab(int index, String tabName, Image tabImage) {
        this.addNewTab(tabName, tabImage, this.inactiveStyle);
    }

    public void addNewTab(int index, String tabName, Image tabImage, Style tabStyle) {
        IconItem tab = new IconItem(tabName, tabImage);
        this.addNewTab(index, tab, tabStyle);
    }

    public void addNewTab(int index, Item tab) {
        this.addNewTab(index, tab, this.inactiveStyle);
    }

    public void addNewTab(int index, Item tab, Style tabStyle) {
        this.tabs.add(index, tab);
        if (tabStyle != null) {
            tab.setStyle(tabStyle);
        }
        tab.parent = this;
        this.setInitialized(false);
    }

    public void removeTab(int index) {
        this.tabs.remove(index);
    }

    public Item getTabItem(int tabIndex) {
        return (Item)this.tabs.get(tabIndex);
    }

    public void setTabItem(int tabIndex, Item item) {
        this.tabs.set(tabIndex, item);
    }

    public boolean isRoundtrip() {
        return this.allowRoundtrip;
    }

    public void setRoundtrip(boolean allow) {
        this.allowRoundtrip = allow;
    }
}

