/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Color;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.util.TextUtil;
import de.enough.polish.util.WrappedText;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class StringItem
extends Item {
    private static final int DIRECTION_BACK_AND_FORTH = 0;
    private static final int DIRECTION_LEFT = 1;
    private static final int DIRECTION_RIGHT = 2;
    protected String text;
    protected final WrappedText textLines;
    protected int textColor;
    protected Font font;
    protected int maxLines = Integer.MAX_VALUE;
    protected String maxLinesAppendix = "...";
    protected int maxLinesAppendixPosition = 0;
    protected int textLayout;
    protected boolean isTextInitializationRequired;
    private int lastAvailableContentWidth;
    private int lastContentWidth;
    private int lastContentHeight;

    public StringItem(String label, String text) {
        this(label, text, 0);
    }

    public StringItem(String label, String text, Style style) {
        this(label, text, 0, style);
    }

    public StringItem(String label, String text, int appearanceMode) {
        this(label, text, appearanceMode, null);
    }

    public StringItem(String label, String text, int appearanceMode, Style style) {
        super(label, 0, appearanceMode, style);
        this.text = text;
        this.textLines = new WrappedText();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.setText(text, null);
    }

    public void setText(String text, Style style) {
        if (style != null) {
            this.setStyle(style);
        }
        if (text != this.text) {
            this.text = text;
            if (text == null) {
                this.textLines.clear();
            }
            this.isTextInitializationRequired = true;
            this.requestInit();
        }
        this.notifyValueChanged(text);
    }

    public void setTextColor(int color2) {
        this.textColor = color2;
    }

    public void setFont(Font font) {
        if (font == null || !font.equals(this.font)) {
            this.font = font;
            this.setInitialized(false);
        }
    }

    public Font getFont() {
        if (this.font == null) {
            if (this.style != null) {
                this.font = this.style.getFont();
            }
            if (this.font == null) {
                this.font = Font.getDefaultFont();
            }
        }
        return this.font;
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        boolean isExpand;
        WrappedText lines = this.textLines;
        if (lines.size() == 0) {
            return;
        }
        g.setFont(this.font);
        g.setColor(this.textColor);
        int lineHeight = this.getLineHeight();
        int centerX = 0;
        int lo = this.textLayout;
        boolean isCenter = (lo & 3) == 3;
        boolean isRight = (lo & 3) == 2;
        boolean bl = isExpand = (lo & 0x800) == 2048;
        if (isCenter) {
            centerX = leftBorder + (rightBorder - leftBorder) / 2;
        }
        int lineX = x;
        int lineY = y;
        int orientation = 4;
        orientation = 0x10 | orientation;
        int startIndex = 0;
        int endIndex = lines.size();
        if (endIndex > 2) {
            int clippingHeight;
            int clippingY = g.getClipY();
            if (lineY + endIndex * lineHeight > clippingY + (clippingHeight = g.getClipHeight())) {
                endIndex -= (lineY + endIndex * lineHeight - (clippingY + clippingHeight)) / lineHeight;
            }
            if (lineY < clippingY) {
                startIndex = (clippingY - lineY) / lineHeight;
                lineY += startIndex * lineHeight;
                if (startIndex > 0) {
                    lineX = leftBorder;
                }
            }
            if (endIndex > lines.size()) {
                endIndex = lines.size();
            }
        }
        Object[] lineObjects = lines.getLinesInternalArray();
        for (int i = startIndex; i < endIndex; ++i) {
            String line = (String)lineObjects[i];
            if (isCenter || isRight) {
                int lineWidth = lines.getLineWidth(i);
                lineX = isCenter ? centerX - lineWidth / 2 : rightBorder - lineWidth;
            }
            this.drawString(line, lineX, lineY, orientation, g);
            lineY += lineHeight;
            if (i != 0 || x <= leftBorder) continue;
            lineX = leftBorder;
        }
    }

    public void drawString(String line, int x, int y, int anchor, Graphics g) {
        g.drawString(line, x, y, anchor);
    }

    public int getLineHeight() {
        return this.getFontHeight() + this.paddingVertical;
    }

    public int stringWidth(String str) {
        return this.getFont().stringWidth(str);
    }

    public int charWidth(char c) {
        return this.font.charWidth(c);
    }

    public int getFontHeight() {
        return this.getFont().getHeight();
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        int maxWidth;
        String body = this.text;
        if (body != null && this.font == null) {
            this.font = Font.getDefaultFont();
        }
        if (body == null) {
            this.contentWidth = 0;
            this.contentHeight = 0;
            this.textLines.clear();
            return;
        }
        if (!this.isTextInitializationRequired && availWidth == this.lastAvailableContentWidth) {
            this.contentWidth = this.lastContentWidth;
            this.contentHeight = this.lastContentHeight;
            return;
        }
        this.isTextInitializationRequired = false;
        this.lastAvailableContentWidth = availWidth;
        this.textLines.clear();
        this.wrap(body, firstLineWidth, availWidth);
        WrappedText lines = this.textLines;
        this.contentHeight = this.calculateLinesHeight(lines, this.getLineHeight());
        this.lastContentWidth = this.contentWidth = (maxWidth = lines.getMaxLineWidth());
        this.lastContentHeight = this.contentHeight;
    }

    public void setTextInitializationRequired(boolean isInitializationRequired) {
        this.isTextInitializationRequired = isInitializationRequired;
    }

    public boolean isTextInitializationRequired() {
        return this.isTextInitializationRequired;
    }

    protected void wrap(String body, int firstLineWidth, int availWidth) {
        int maxNumberOfLines = Integer.MAX_VALUE;
        String maxAppendix = null;
        int maxPosition = 0;
        maxNumberOfLines = this.maxLines;
        maxAppendix = this.maxLinesAppendix;
        maxPosition = this.maxLinesAppendixPosition;
        TextUtil.wrap(body, this.font, firstLineWidth, availWidth, maxNumberOfLines, maxAppendix, maxPosition, this.textLines);
    }

    protected int calculateLinesHeight(WrappedText lines, int lineHeight) {
        int linesHeight = lines.size() * lineHeight - this.paddingVertical;
        return linesHeight;
    }

    protected void setContentWidth(int width) {
        if (width < this.contentWidth) {
            this.initContent(width, width, this.availContentHeight);
        }
        super.setContentWidth(width);
    }

    public void setStyle(Style style) {
        Integer layoutInt = style.getIntProperty(388);
        this.textLayout = layoutInt != null ? layoutInt : style.layout;
        super.setStyle(style);
    }

    public void setStyle(Style style, boolean resetStyle) {
        Integer maxLinesInt;
        Color textColorObj;
        super.setStyle(style, resetStyle);
        if (resetStyle) {
            this.textColor = style.getFontColor();
            Font prevFont = this.font;
            this.font = style.getFont();
            boolean bl = this.isTextInitializationRequired = this.isTextInitializationRequired || prevFont == null && this.font != null || prevFont != null && !prevFont.equals(this.font);
        }
        if ((textColorObj = style.getColorProperty(-17)) != null) {
            this.textColor = textColorObj.getColor();
        }
        if ((maxLinesInt = style.getIntProperty(369)) != null && maxLinesInt != this.maxLines) {
            this.maxLines = maxLinesInt;
            if (this.maxLines <= 0) {
                this.maxLines = Integer.MAX_VALUE;
            }
            this.isTextInitializationRequired = true;
        }
    }

    protected String createCssSelector() {
        if (this.appearanceMode == 2) {
            return "button";
        }
        if (this.appearanceMode == 1) {
            return "a";
        }
        return "p";
    }

    public String toString() {
        return "StringItem " + super.toString() + ": \"" + this.getText() + "\"";
    }

    public void releaseResources() {
        super.releaseResources();
    }

    public WrappedText getWrappedText() {
        return this.textLines;
    }

    public int getNumberOfLines() {
        if (this.textLines == null) {
            return -1;
        }
        return this.textLines.size();
    }
}

