/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Command;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.video.CaptureSource;
import de.enough.polish.video.VideoContainer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class SnapshotScreen
extends Screen {
    private Command cmdCapture;
    private VideoContainer videoContainer;
    private CaptureSource captureSource;

    public SnapshotScreen(String title) {
        this(title, null);
    }

    public SnapshotScreen(String title, Style style) {
        super(title, true, style);
        boolean adjustSizeAutomatically = true;
        this.videoContainer = new VideoContainer(adjustSizeAutomatically);
        this.captureSource = CaptureSource.CAPTURE;
        this.videoContainer.setSource(this.captureSource);
        this.container.add(this.videoContainer);
        if (style.getLayout() == 0) {
            style.setLayout(51);
        }
    }

    public boolean isSnapshotInProgress() {
        return this.captureSource.isSnapshotInProgress();
    }

    public void hideNotify() {
        super.hideNotify();
        if (!this.captureSource.isSnapshotInProgress()) {
            this.stopSnapshot(false);
        }
    }

    public void showNotify() {
        super.showNotify();
        if (this.videoContainer.getState() != 2) {
            this.videoContainer.play();
        }
    }

    public Image getSnapshotImage() throws MediaException {
        return this.getSnapshotImage(null);
    }

    public Image getSnapshotImage(String encoding) throws MediaException {
        byte[] data = this.getSnapshot(encoding);
        if (data == null) {
            throw new MediaException("no data");
        }
        return Image.createImage(data, 0, data.length);
    }

    public byte[] getSnapshot() throws MediaException {
        return this.getSnapshot(null);
    }

    public byte[] getSnapshot(String encoding) throws MediaException {
        byte[] data = this.videoContainer.capture(encoding);
        if (data == null) {
            Exception e = this.videoContainer.getLastException();
            if (e instanceof MediaException) {
                throw (MediaException)e;
            }
            if (e != null) {
                throw new MediaException(e.toString());
            }
            throw new MediaException();
        }
        return data;
    }

    public void setAutofocus(boolean autofocus) {
        this.captureSource.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.captureSource.isAutofocus();
    }

    protected void paintScreen(Graphics g) {
    }

    protected String createCssSelector() {
        return "snapshotscreen";
    }

    public void stopSnapshot() {
        this.stopSnapshot(false);
    }

    public void stopSnapshot(boolean removeInstanceVariables) {
        this.videoContainer.stop();
    }

    public Player getPlayer() {
        return this.captureSource.getPlayer();
    }

    public boolean handleKeyReleased(int keyCode, int gameAction) {
        boolean handled = super.handleKeyReleased(keyCode, gameAction);
        if (!(handled || keyCode != -24 && keyCode != -26 || this.cmdCapture == null || this.getCommandListener() == null || this.isBusy())) {
            this.getCommandListener().commandAction(this.cmdCapture, this);
            handled = true;
        }
        return handled;
    }

    public Command getCaptureCommand() {
        return this.cmdCapture;
    }

    public void setCaptureCommand(Command cmdCapture) {
        if (this.cmdCapture != null) {
            this.removeCommand(this.cmdCapture);
        }
        this.cmdCapture = cmdCapture;
        if (cmdCapture != null) {
            this.addCommand(cmdCapture);
        }
    }

    public boolean isBusy() {
        return this.captureSource.isBusy();
    }
}

