/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;

public class ScrollBar
extends Item {
    private static final int MODE_AREA = 0;
    private static final int MODE_ITEM = 1;
    private static final int MODE_PAGE = 2;
    protected int sliderColor;
    protected Dimension sliderWidth;
    protected boolean hideSlider = true;
    protected int sliderY;
    protected int sliderHeight;
    protected int sliderMinHeight = 1;
    protected int scrollBarHeight;
    protected boolean isVisible;
    protected boolean overlap;
    private int screenAvailableContentHeight;
    private int screenActualContentHeight;
    private boolean isPointerDraggedHandled;
    protected boolean isPointerPressedHandled;

    public ScrollBar() {
    }

    public ScrollBar(Style style) {
        super(style);
    }

    public int initScrollBar(int screenWidth, int screenAvailableHeight, int screenContentHeight, int contentYOffset, int selectionStart, int selectionHeight, int focusedIndex, int numberOfItems) {
        this.screenActualContentHeight = screenContentHeight;
        this.screenAvailableContentHeight = screenAvailableHeight;
        if (screenAvailableHeight >= screenContentHeight || screenContentHeight == 0) {
            this.isVisible = false;
            return 0;
        }
        int lastSliderY = this.sliderY;
        int lastSliderHeight = this.sliderHeight;
        this.isVisible = true;
        this.scrollBarHeight = screenAvailableHeight;
        int nextSliderY = -contentYOffset * screenAvailableHeight / screenContentHeight;
        int nextSliderHeight = screenAvailableHeight * screenAvailableHeight / screenContentHeight;
        if (nextSliderY < 0) {
            nextSliderHeight += nextSliderY;
            nextSliderY = 0;
        }
        this.sliderY = nextSliderY;
        if (!this.isInitialized || this.scrollBarHeight != this.itemHeight) {
            this.init(screenWidth, screenWidth, screenAvailableHeight);
        }
        this.itemHeight = this.scrollBarHeight;
        if (nextSliderHeight < this.sliderMinHeight) {
            nextSliderHeight = this.sliderMinHeight;
        } else if (nextSliderHeight < 0) {
            nextSliderHeight = 0;
        }
        this.sliderHeight = nextSliderHeight;
        return this.itemWidth;
    }

    public void resetAnimation() {
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        this.contentWidth = this.sliderWidth != null ? this.sliderWidth.getValue(availWidth) : 2;
        this.contentHeight = this.scrollBarHeight - (this.paddingTop + this.paddingBottom + this.marginTop + this.marginBottom + this.getBorderWidthTop() + this.getBorderWidthBottom());
    }

    public void paint(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (!this.isVisible) {
            return;
        }
        super.paint(x, y, leftBorder, rightBorder, g);
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        boolean doClip = false;
        int clipX = 0;
        int clipY = 0;
        int clipWidth = 0;
        int clipHeight = 0;
        if (this.sliderY + this.sliderHeight > this.contentHeight) {
            doClip = true;
            clipX = g.getClipX();
            clipY = g.getClipY();
            clipWidth = g.getClipWidth();
            clipHeight = g.getClipHeight();
            g.clipRect(clipX, y, clipWidth, this.contentHeight);
        }
        g.setColor(this.sliderColor);
        g.fillRect(x, y + this.sliderY, this.contentWidth, this.sliderHeight);
        if (doClip) {
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    protected String createCssSelector() {
        return "scrollbar";
    }

    public void setStyle(Style style) {
        Integer sliderColorInt;
        super.setStyle(style);
        Dimension sliderWidthDim = (Dimension)style.getObjectProperty(119);
        if (sliderWidthDim != null) {
            this.sliderWidth = sliderWidthDim;
        }
        if ((sliderColorInt = style.getIntProperty(120)) != null) {
            this.sliderColor = sliderColorInt;
        }
    }

    protected boolean handlePointerPressed(int relX, int relY) {
        this.isPointerPressedHandled = false;
        if (this.screenActualContentHeight <= this.screenAvailableContentHeight || relY < 0 || relY > this.screenAvailableContentHeight) {
            return false;
        }
        if (relX >= 0 || (this.hideSlider || !this.isVisible) && relX >= -this.itemWidth) {
            this.isPointerPressedHandled = true;
            return true;
        }
        return false;
    }

    protected boolean handlePointerReleased(int relX, int relY) {
        if (this.screenActualContentHeight <= this.screenAvailableContentHeight) {
            return false;
        }
        if (this.isPointerPressedHandled) {
            if (this.isPointerDraggedHandled) {
                return true;
            }
            int diff = 0;
            if (relY < this.sliderY) {
                diff = this.screen.contentHeight / 2;
            } else if (relY > this.sliderY + this.sliderHeight) {
                diff = -(this.screen.contentHeight / 2);
            }
            if (diff != 0) {
                this.screen.scrollRelative(diff);
                return true;
            }
        }
        return false;
    }

    protected boolean handlePointerDragged(int x, int y) {
        this.isPointerDraggedHandled = false;
        if (this.screenActualContentHeight <= this.screenAvailableContentHeight) {
            return false;
        }
        if (this.isPointerPressedHandled) {
            int scrollOffset = y * this.screenActualContentHeight / this.screenAvailableContentHeight;
            if (scrollOffset < 0) {
                scrollOffset = 0;
            } else if (scrollOffset > this.screenActualContentHeight - this.screenAvailableContentHeight) {
                scrollOffset = this.screenActualContentHeight - this.screenAvailableContentHeight;
            }
            this.screen.setScrollYOffset(-scrollOffset, false);
            this.isPointerDraggedHandled = true;
            return true;
        }
        return false;
    }
}

