/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.util.RgbImage;
import javax.microedition.lcdui.Graphics;

public class RgbImageItem
extends Item {
    private RgbImage image;

    public RgbImageItem(RgbImage image) {
        this(null, image, null);
    }

    public RgbImageItem(RgbImage image, Style style) {
        this(null, image, style);
    }

    public RgbImageItem(String label, RgbImage image, Style style) {
        super(label, 0, 0, style);
        this.image = image;
    }

    public RgbImage getImage() {
        return this.image;
    }

    public void setImage(RgbImage image) {
        this.image = image;
        if (this.isInitialized) {
            if (image == null && this.contentWidth != 0 || image != null && (image.getWidth() != this.contentWidth || image.getHeight() != this.contentHeight)) {
                this.requestInit();
            }
            this.repaint();
        }
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        RgbImage img = this.image;
        if (img == null) {
            this.contentWidth = 0;
            this.contentHeight = 0;
        } else {
            this.contentWidth = img.getWidth();
            this.contentHeight = img.getHeight();
        }
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        RgbImage img = this.image;
        if (img != null) {
            img.paint(x, y, g);
        }
    }

    protected String createCssSelector() {
        return "rgbimage";
    }
}

