/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandItem;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.backgrounds.TranslucentSimpleBackground;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.IdentityArrayList;
import de.enough.polish.util.Locale;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuBar
extends Item {
    protected final IdentityArrayList commandsList;
    protected final Container commandsContainer;
    protected boolean isOpened;
    protected Command singleLeftCommand;
    protected final CommandItem singleLeftCommandItem;
    protected Command singleRightCommand;
    protected final CommandItem singleRightCommandItem;
    protected Command singleMiddleCommand;
    protected final CommandItem singleMiddleCommandItem;
    private int topY;
    protected boolean isSoftKeyPressed;
    protected boolean canScrollDownwards;
    protected boolean canScrollUpwards;
    protected boolean paintScrollIndicator;
    protected Image optionsImage;
    protected boolean showImageAndText;
    protected Image selectImage;
    protected Image cancelImage;
    protected Background overlayBackground;
    protected final HashMap allCommands;
    protected boolean isOrientationVertical;
    protected Style menuItemStyle;
    private ArrayList commandsBeforeLayer;
    private int screenHeight;
    private static String OPTIONS_CMD_TXT = "Options";
    private static String SELECT_CMD_TXT = "Select";
    private static String CANCEL_CMD_TXT = "Cancel";
    private static Command tmpMiddleCommand = new Command("", 4, -1);

    public MenuBar(Screen screen) {
        this(screen, null);
    }

    public MenuBar(Screen screen, Style style) {
        super(style);
        this.screen = screen;
        this.commandsList = new IdentityArrayList();
        this.allCommands = new HashMap();
        this.commandsContainer = new Container(true, StyleSheet.menuStyle);
        this.commandsContainer.parent = this;
        this.commandsContainer.screen = screen;
        if (this.commandsContainer.style != null) {
            this.commandsContainer.setStyle(this.commandsContainer.style);
        }
        this.commandsContainer.layout |= 0x400;
        Command dummy = new Command("", 8, 10000);
        this.singleRightCommandItem = new CommandItem(dummy, this, StyleSheet.rightcommandStyle);
        this.singleRightCommandItem.setImageAlign(4);
        this.singleLeftCommandItem = new CommandItem(dummy, this, StyleSheet.leftcommandStyle);
        this.singleLeftCommandItem.setImageAlign(4);
        this.singleMiddleCommandItem = new CommandItem(dummy, this, StyleSheet.middlecommandStyle);
        this.singleMiddleCommandItem.setImageAlign(4);
    }

    public void addCommand(Command cmd) {
        if (this.menuItemStyle != null) {
            this.addCommand(cmd, this.menuItemStyle);
        } else {
            this.addCommand(cmd, StyleSheet.menuitemStyle);
        }
    }

    public void addCommand(Command cmd, Style commandStyle) {
        if (cmd == this.singleLeftCommand || cmd == this.singleRightCommand || cmd == this.singleMiddleCommand || this.commandsList.contains(cmd)) {
            return;
        }
        CommandItem item = new CommandItem(cmd, this, commandStyle);
        this.allCommands.put(cmd, item);
        int type = cmd.getCommandType();
        int priority = cmd.getPriority();
        if (type == 8 || type == 4) {
            if (this.singleMiddleCommand == null) {
                this.singleMiddleCommand = cmd;
                this.singleMiddleCommandItem.setImage((Image)null);
                this.singleMiddleCommandItem.setText(cmd.getLabel());
                if (this.isInitialized) {
                    this.setInitialized(false);
                    this.repaint();
                }
                return;
            }
            if (this.singleMiddleCommand.getPriority() > priority) {
                Command oldMiddleCommand = this.singleMiddleCommand;
                this.singleMiddleCommand = cmd;
                this.singleMiddleCommandItem.setText(cmd.getLabel());
                cmd = oldMiddleCommand;
                item = (CommandItem)this.allCommands.get(cmd);
                priority = oldMiddleCommand.getPriority();
            }
        }
        if (type == 2 || type == 3 || type == 7) {
            if (this.singleRightCommand == null) {
                this.singleRightCommand = cmd;
                this.singleRightCommandItem.setImage((Image)null);
                this.singleRightCommandItem.setText(cmd.getLabel());
                if (this.isInitialized) {
                    this.setInitialized(false);
                    this.repaint();
                }
                return;
            }
            if (this.singleRightCommand.getPriority() > priority) {
                Command oldRightCommand = this.singleRightCommand;
                this.singleRightCommand = cmd;
                this.singleRightCommandItem.setText(cmd.getLabel());
                cmd = oldRightCommand;
                item = (CommandItem)this.allCommands.get(cmd);
                priority = oldRightCommand.getPriority();
            }
        }
        if (this.singleLeftCommand != null) {
            CommandItem singleItem = (CommandItem)this.allCommands.get(this.singleLeftCommand);
            this.commandsList.add(this.singleLeftCommand);
            this.commandsContainer.add(singleItem);
            this.singleLeftCommand = null;
        } else if (this.commandsList.size() == 0) {
            this.singleLeftCommand = cmd;
            this.singleLeftCommandItem.setText(cmd.getLabel());
            if (this.isInitialized) {
                this.setInitialized(false);
                this.repaint();
            }
            return;
        }
        this.addCommand(item);
        if (this.isInitialized) {
            this.setInitialized(false);
            this.repaint();
        }
    }

    public void removeCommand(Command cmd) {
        int index;
        this.allCommands.remove(cmd);
        if (cmd == this.singleMiddleCommand) {
            Command newMiddleCommand;
            this.singleMiddleCommand = newMiddleCommand = this.extractNextMiddleCommand();
            if (newMiddleCommand == null) {
                this.singleMiddleCommandItem.setText(null);
            } else {
                this.singleMiddleCommandItem.setText(newMiddleCommand.getLabel());
            }
            if (this.isInitialized) {
                this.setInitialized(false);
                this.repaint();
            }
            return;
        }
        if (cmd == this.singleLeftCommand) {
            this.singleLeftCommand = null;
            if (this.isInitialized) {
                this.setInitialized(false);
                this.repaint();
            }
        }
        if (cmd == this.singleRightCommand) {
            this.singleRightCommand = null;
            if (this.singleLeftCommand != null) {
                if (this.singleLeftCommand.getCommandType() == 2 || this.singleLeftCommand.getCommandType() == 3) {
                    this.singleRightCommand = this.singleLeftCommand;
                    this.singleRightCommandItem.setText(this.singleLeftCommand.getLabel());
                    this.singleLeftCommand = null;
                }
                if (this.isInitialized) {
                    this.setInitialized(false);
                    this.repaint();
                }
                return;
            }
            int newSingleRightCommandIndex = this.getNextNegativeOrPositiveCommandIndex(true);
            if (newSingleRightCommandIndex != -1) {
                if (newSingleRightCommandIndex == this.commandsContainer.getFocusedIndex()) {
                    this.commandsContainer.focusChild(-1);
                }
                this.singleRightCommand = (Command)this.commandsList.remove(newSingleRightCommandIndex);
                this.commandsContainer.remove(newSingleRightCommandIndex);
                this.singleRightCommandItem.setText(this.singleRightCommand.getLabel());
            }
        }
        if ((index = this.commandsList.indexOf(cmd)) != -1) {
            if (index == this.commandsContainer.getFocusedIndex()) {
                this.commandsContainer.focusChild(-1);
            }
            this.commandsList.remove(index);
            this.commandsContainer.remove(index);
        }
        if (this.commandsList.size() == 1) {
            CommandItem item = (CommandItem)this.commandsContainer.get(0);
            if (!item.hasChildren) {
                Command command = (Command)this.commandsList.remove(0);
                this.commandsContainer.focusChild(-1);
                this.commandsContainer.remove(0);
                this.singleLeftCommand = command;
                this.singleLeftCommandItem.setText(command.getLabel());
            }
        }
        if (this.isInitialized()) {
            this.setInitialized(false);
            this.repaint();
        }
    }

    private Command extractNextMiddleCommand() {
        Command command;
        Command next = null;
        next = this.getNextMiddleCommand(next, this.singleLeftCommand);
        next = this.getNextMiddleCommand(next, this.singleRightCommand);
        Object[] myCommands = this.commandsList.getInternalArray();
        int index = -1;
        for (int i = 0; i < myCommands.length && (command = (Command)myCommands[i]) != null; ++i) {
            Command cmd = this.getNextMiddleCommand(next, command);
            if (cmd == next) continue;
            index = i;
            next = cmd;
        }
        if (next != null) {
            if (next == this.singleLeftCommand) {
                this.singleLeftCommand = null;
                this.singleLeftCommandItem.setText(null);
                index = this.getNextNegativeOrPositiveCommandIndex(false);
                if (index != -1) {
                    this.singleLeftCommand = (Command)this.commandsList.remove(index);
                    this.commandsContainer.remove(index);
                    this.singleLeftCommandItem.setText(this.singleLeftCommand.getLabel());
                }
            } else if (next == this.singleRightCommand) {
                this.singleRightCommand = null;
                this.singleRightCommandItem.setText(null);
                index = this.getNextNegativeOrPositiveCommandIndex(false);
                if (index != -1) {
                    this.singleRightCommand = (Command)this.commandsList.remove(index);
                    this.commandsContainer.remove(index);
                    this.singleRightCommandItem.setText(this.singleRightCommand.getLabel());
                }
            } else {
                if (index == this.commandsContainer.focusedIndex) {
                    this.commandsContainer.focusChild(-1);
                }
                this.commandsContainer.remove(index);
                this.commandsList.remove(index);
                if (this.commandsList.size() == 1) {
                    CommandItem remainingItem = (CommandItem)this.commandsContainer.get(0);
                    if (!remainingItem.hasChildren) {
                        this.singleLeftCommand = (Command)this.commandsList.get(0);
                        this.singleLeftCommandItem.setText(this.singleLeftCommand.getLabel());
                        this.commandsList.clear();
                        this.commandsContainer.clear();
                    }
                }
            }
        }
        return next;
    }

    private Command getNextMiddleCommand(Command current, Command cmd) {
        int commandType;
        if (!(cmd == null || (commandType = cmd.getCommandType()) != 4 && commandType != 8 || current != null && cmd.getPriority() >= current.getPriority())) {
            return cmd;
        }
        return current;
    }

    private int getNextNegativeOrPositiveCommandIndex(boolean isNegative) {
        Command command;
        Object[] myCommands = this.commandsList.getInternalArray();
        int maxPriority = 1000;
        int maxPriorityId = -1;
        for (int i = 0; i < myCommands.length && (command = (Command)myCommands[i]) != null; ++i) {
            int type = command.getCommandType();
            if ((!isNegative || type != 2 && type != 3 && type != 6 && type != 7) && (isNegative || type != 4 && type != 8 && type != 1) || command.getPriority() >= maxPriority) continue;
            maxPriority = command.getPriority();
            maxPriorityId = i;
        }
        return maxPriorityId;
    }

    public void onScreenSizeChanged(int sWidth, int sHeight) {
        this.screenHeight = sHeight;
        super.onScreenSizeChanged(sWidth, sHeight);
    }

    protected void init(int firstLineWidth, int availWidth, int availHeight) {
        super.init(firstLineWidth, availWidth, availHeight);
        if (this.isOpened) {
            int titleHeight;
            Container cmdCont = this.commandsContainer;
            int cmdContHeight = cmdCont.getItemHeight(firstLineWidth, firstLineWidth, availHeight - this.itemHeight);
            int cmdContY = this.screenHeight - this.itemHeight - cmdContHeight - 1;
            if (cmdContY < (titleHeight = this.screen.getTitleHeight())) {
                cmdContHeight -= titleHeight - cmdContY;
                cmdContY = titleHeight;
            }
            int scrollHeight = this.screenHeight - titleHeight - this.itemHeight;
            cmdCont.setScrollHeight(scrollHeight);
            cmdCont.relativeY = -cmdContHeight;
            this.canScrollDownwards = cmdCont.yOffset + cmdContHeight > scrollHeight && cmdCont.focusedIndex != this.commandsList.size() - 1;
            this.paintScrollIndicator = this.canScrollUpwards || this.canScrollDownwards;
        }
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        if (this.isOpened) {
            int titleHeight;
            this.topY = titleHeight = this.screen.getTitleHeight();
            this.commandsContainer.relativeX = 0;
            this.canScrollUpwards = this.commandsContainer.yOffset != 0 && this.commandsContainer.focusedIndex != 0;
            CommandItem item = this.singleLeftCommandItem;
            this.setupCommandMenuItem(item, this.getMenuSelectText(), this.selectImage);
            item = this.singleRightCommandItem;
            this.setupCommandMenuItem(item, this.getMenuCancelText(), this.cancelImage);
        } else {
            CommandItem item;
            if (this.singleLeftCommand == null && this.singleRightCommand == null && this.singleMiddleCommand == null && this.commandsList.size() == 0) {
                this.contentWidth = 0;
                this.contentHeight = 0;
                return;
            }
            this.paintScrollIndicator = false;
            this.singleRightCommandItem.isInitialized = false;
            if (this.singleRightCommand != null) {
                item = (CommandItem)this.allCommands.get(this.singleRightCommand);
                if (item != null) {
                    this.singleRightCommandItem.setText(item.getText());
                } else {
                    this.singleRightCommandItem.setText(null);
                }
            } else {
                this.singleRightCommandItem.setText(null);
            }
            this.singleRightCommandItem.setImage((Image)null);
            if (this.commandsList.size() > 0) {
                item = this.singleLeftCommandItem;
                this.setupCommandMenuItem(item, this.getMenuOptionsText(), this.optionsImage);
            }
        }
        int availScreenWidth = availWidth >> 1;
        int height = Math.max(this.singleLeftCommandItem.getItemHeight(availScreenWidth, availScreenWidth, availHeight), this.singleRightCommandItem.getItemHeight(availScreenWidth, availScreenWidth, availHeight));
        height = Math.max(height, this.singleMiddleCommandItem.getItemHeight(availScreenWidth, availScreenWidth, availHeight));
        this.singleMiddleCommandItem.relativeX = availScreenWidth - this.singleMiddleCommandItem.itemWidth / 2;
        this.contentHeight = height;
        CommandItem item = this.singleRightCommandItem;
        item.relativeX = availScreenWidth;
        int width = item.itemWidth;
        if (width < availScreenWidth) {
            if (item.isLayoutCenter) {
                item.relativeX = availScreenWidth + (availScreenWidth - width) / 2;
            } else if (item.isLayoutRight) {
                item.relativeX = availScreenWidth + (availScreenWidth - width);
            }
        }
        item = this.singleLeftCommandItem;
        item.relativeX = 0;
        width = item.itemWidth;
        if (width < availScreenWidth) {
            if (item.isLayoutCenter) {
                item.relativeX = (availScreenWidth - width) / 2;
            } else if (item.isLayoutRight) {
                item.relativeX = availScreenWidth - width;
            }
        }
        this.singleRightCommandItem.relativeY = this.singleRightCommandItem.isLayoutVerticalCenter() ? this.contentHeight - this.singleRightCommandItem.itemHeight >> 1 : (this.singleRightCommandItem.isLayoutBottom() ? this.contentHeight - this.singleRightCommandItem.itemHeight : 0);
        this.contentWidth = availWidth;
    }

    protected void setupCommandMenuItem(IconItem item, String text, Image img) {
        item.isInitialized = false;
        item.setImage((Image)null);
        item.setText(null);
        if (img != null) {
            item.setImage(img);
        }
        if (this.showImageAndText || img == null) {
            item.setText(text);
        }
    }

    public String getMenuOptionsText() {
        String optionsText = Locale.get(166);
        return optionsText;
    }

    public String getMenuSelectText() {
        String selectText = Locale.get(167);
        return selectText;
    }

    public String getMenuCancelText() {
        String cancelText = Locale.get(158);
        return cancelText;
    }

    protected void paintBackgroundAndBorder(int x, int y, int width, int height, Graphics g) {
        if (this.isOpened && this.overlayBackground != null) {
            int overlayWidth = this.screen.screenWidth;
            int titleHeight = this.screen.getTitleHeight();
            this.overlayBackground.paint(0, titleHeight, overlayWidth, this.screenHeight - titleHeight, g);
        }
        super.paintBackgroundAndBorder(x, y, width, height, g);
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int itemX;
        boolean paintLeftCommand = false;
        boolean paintRightCommand = false;
        boolean paintMiddleCommand = false;
        if (this.isOpened) {
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            int scrHeight = this.screenHeight - this.itemHeight;
            int maxClipHeight = Math.max(this.relativeY - this.topY, scrHeight - this.topY);
            g.setClip(0, this.topY, this.screen.screenWidth, maxClipHeight);
            Container cont = this.commandsContainer;
            cont.paint(x + cont.relativeX, y + cont.relativeY, x + cont.relativeX, x + cont.relativeX + cont.itemWidth, g);
            g.setClip(clipX, clipY, clipWidth, clipHeight);
            paintLeftCommand = true;
            paintRightCommand = true;
        } else {
            if (this.singleMiddleCommand != null) {
                paintMiddleCommand = true;
            }
            if (this.singleLeftCommand != null || this.commandsContainer.size() > 0) {
                paintLeftCommand = true;
            }
            if (this.singleRightCommand != null) {
                paintRightCommand = true;
            }
        }
        if (paintLeftCommand) {
            CommandItem item = this.singleLeftCommandItem;
            itemX = x + item.relativeX;
            item.paint(itemX, y + item.relativeY, itemX, itemX + item.itemWidth, g);
        }
        if (paintRightCommand) {
            CommandItem item = this.singleRightCommandItem;
            itemX = x + item.relativeX;
            item.paint(itemX, y + item.relativeY, itemX, itemX + item.itemWidth, g);
        }
        if (paintMiddleCommand) {
            CommandItem item = this.singleMiddleCommandItem;
            itemX = x + item.relativeX;
            item.paint(itemX, y + item.relativeY, itemX, itemX + item.itemWidth, g);
        }
    }

    protected String createCssSelector() {
        return "menubar";
    }

    protected void setOpen(boolean open) {
        if (!open && this.isOpened) {
            this.commandsContainer.hideNotify();
            this.isInitialized = open == this.isOpened;
            this.isOpened = open;
        } else if (open && !this.isOpened) {
            if (this.commandsContainer.size() == 0) {
                return;
            }
            this.isInitialized = open == this.isOpened;
            this.isOpened = open;
            this.commandsContainer.focusChild(0);
            this.commandsContainer.showNotify();
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        this.isSoftKeyPressed = false;
        if (this.isOpened) {
            if (this.isSelectOptionsMenuKey(keyCode, gameAction)) {
                this.isSoftKeyPressed = true;
                MenuBar.notifyKeyPressed();
                CommandItem commandItem = (CommandItem)this.commandsContainer.getFocusedItem();
                commandItem.handleKeyPressed(0, 8);
                return true;
            }
            if (this.isCloseOptionsMenuKey(keyCode, gameAction)) {
                CommandItem item = this.getCloseOptionsItem();
                if (item != null) {
                    item.notifyItemPressedStart();
                }
                this.isSoftKeyPressed = true;
                MenuBar.notifyKeyPressed();
                this.commandsContainer.handleKeyPressed(0, 2);
                return true;
            }
            boolean handled = this.commandsContainer.handleKeyPressed(keyCode, gameAction);
            if (handled) {
                this.setInitialized(false);
            } else {
                CommandItem item;
                int index;
                if (gameAction == 6 || gameAction == 1) {
                    Debug.debug("error", "de.enough.polish.ui.MenuBar", 1324, "Container DID NOT HANDLE DOWN OR UP probably since cycling has been DEACTIVATED - check your polish.Container.allowCycling preprocessing variable");
                    Debug.debug("error", "de.enough.polish.ui.MenuBar", 1328, (Object)("view-type of container " + this.commandsContainer + " = "), this.commandsContainer.containerView);
                }
                if (keyCode >= 49 && keyCode <= 57 && (index = keyCode - 49) <= this.commandsContainer.size() && (item = (CommandItem)this.commandsContainer.get(index)).getAppearanceMode() != 0) {
                    if (!item.isFocused) {
                        this.commandsContainer.focusChild(index);
                    }
                    handled = item.handleKeyPressed(0, 8);
                    return handled;
                }
            }
            return true;
        }
        if (this.screen.isGameActionFire(keyCode, gameAction) && this.singleMiddleCommand != null && this.singleMiddleCommandItem.getAppearanceMode() != 0) {
            MenuBar.notifyKeyPressed();
            this.singleMiddleCommandItem.notifyItemPressedStart();
            return true;
        }
        if (this.singleLeftCommand != null && this.screen.isSoftKeyLeft(keyCode, gameAction) && this.singleLeftCommandItem.getAppearanceMode() != 0) {
            this.isSoftKeyPressed = true;
            MenuBar.notifyKeyPressed();
            this.singleLeftCommandItem.notifyItemPressedStart();
            return true;
        }
        if (this.singleRightCommand != null && this.screen.isSoftKeyRight(keyCode, gameAction) && this.singleRightCommandItem.getAppearanceMode() != 0) {
            this.isSoftKeyPressed = true;
            MenuBar.notifyKeyPressed();
            this.singleRightCommandItem.notifyItemPressedStart();
            return true;
        }
        if (this.isOpenOptionsMenuKey(keyCode, gameAction)) {
            this.isSoftKeyPressed = true;
            CommandItem item = this.getOpenOptionsItem();
            if (item != null) {
                item.notifyItemPressedStart();
            }
            return true;
        }
        return false;
    }

    private CommandItem getOpenOptionsItem() {
        CommandItem result = this.singleLeftCommandItem;
        return result;
    }

    private CommandItem getCloseOptionsItem() {
        CommandItem item = this.singleRightCommandItem;
        return item;
    }

    private boolean isOpenOptionsMenuKey(int keyCode, int gameAction) {
        boolean result = this.screen.isSoftKeyLeft(keyCode, gameAction);
        return result;
    }

    private boolean isCloseOptionsMenuKey(int keyCode, int gameAction) {
        boolean result = this.screen.isSoftKeyRight(keyCode, gameAction);
        return result;
    }

    private boolean isSelectOptionsMenuKey(int keyCode, int gameAction) {
        boolean result = this.screen.isSoftKeyLeft(keyCode, gameAction);
        return result;
    }

    public static void notifyKeyPressed() {
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        if (this.isOpened) {
            CommandItem item;
            int index;
            if (this.isSelectOptionsMenuKey(keyCode, gameAction)) {
                this.isSoftKeyPressed = true;
                CommandItem commandItem = (CommandItem)this.commandsContainer.getFocusedItem();
                return commandItem.handleKeyReleased(0, 8);
            }
            if (this.isCloseOptionsMenuKey(keyCode, gameAction)) {
                this.isSoftKeyPressed = true;
                int selectedIndex = this.commandsContainer.getFocusedIndex();
                if (!this.commandsContainer.handleKeyReleased(0, 2) || selectedIndex != this.commandsContainer.getFocusedIndex()) {
                    CommandItem item2 = this.getCloseOptionsItem();
                    if (item2 != null) {
                        item2.notifyItemPressedEnd();
                    }
                    this.setOpen(false);
                }
                return true;
            }
            boolean handled = this.commandsContainer.handleKeyReleased(keyCode, gameAction);
            if (handled) {
                this.setInitialized(false);
            } else if (keyCode >= 49 && keyCode <= 57 && (index = keyCode - 49) <= this.commandsContainer.size() && (item = (CommandItem)this.commandsContainer.get(index)).getAppearanceMode() != 0) {
                if (!item.isFocused) {
                    this.commandsContainer.focusChild(index);
                }
                handled = item.handleKeyReleased(0, 8);
                return handled;
            }
            return true;
        }
        if (this.getScreen().isGameActionFire(keyCode, gameAction) && this.singleMiddleCommand != null && this.singleMiddleCommandItem.getAppearanceMode() != 0) {
            this.singleMiddleCommandItem.notifyItemPressedEnd();
            this.screen.callCommandListener(this.singleMiddleCommand);
            return true;
        }
        if (this.singleLeftCommand != null && this.screen.isSoftKeyLeft(keyCode, gameAction) && this.singleLeftCommandItem.getAppearanceMode() != 0) {
            this.isSoftKeyPressed = true;
            this.singleLeftCommandItem.notifyItemPressedEnd();
            this.screen.callCommandListener(this.singleLeftCommand);
            return true;
        }
        if (this.singleRightCommand != null && this.screen.isSoftKeyRight(keyCode, gameAction) && this.singleRightCommandItem.getAppearanceMode() != 0) {
            this.isSoftKeyPressed = true;
            this.singleRightCommandItem.notifyItemPressedEnd();
            this.screen.callCommandListener(this.singleRightCommand);
            return true;
        }
        if (this.isOpenOptionsMenuKey(keyCode, gameAction)) {
            this.isSoftKeyPressed = true;
            CommandItem item = this.getOpenOptionsItem();
            if (item != null) {
                item.notifyItemPressedEnd();
            }
            if (this.commandsList.size() > 0) {
                this.setOpen(true);
                return true;
            }
        }
        return super.handleKeyReleased(keyCode, gameAction);
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        return false;
    }

    protected boolean isInMenubar(int relativeY) {
        return relativeY > 0;
    }

    protected boolean handlePointerPressed(int relX, int relY) {
        int rightCommandStartX = this.contentWidth / 2;
        if (this.isInMenubar(relY)) {
            CommandItem selectedCommandItem = null;
            selectedCommandItem = relX > this.singleMiddleCommandItem.relativeX && relX < this.singleMiddleCommandItem.relativeX + this.singleMiddleCommandItem.itemWidth && this.singleMiddleCommandItem.getAppearanceMode() != 0 ? this.singleMiddleCommandItem : (relX > rightCommandStartX ? this.singleRightCommandItem : this.singleLeftCommandItem);
            if (selectedCommandItem != null) {
                selectedCommandItem.notifyItemPressedStart();
            }
            return true;
        }
        if (this.isOpened) {
            boolean handled = this.commandsContainer.handlePointerPressed(relX -= this.commandsContainer.relativeX, relY -= this.commandsContainer.relativeY);
            return true;
        }
        return false;
    }

    protected boolean handlePointerReleased(int relX, int relY) {
        int rightCommandStartX = this.contentWidth / 2;
        if (this.isInMenubar(relY)) {
            CommandItem selectedCommandItem = null;
            selectedCommandItem = relX > this.singleMiddleCommandItem.relativeX && relX < this.singleMiddleCommandItem.relativeX + this.singleMiddleCommandItem.itemWidth && this.singleMiddleCommandItem.getAppearanceMode() != 0 ? this.singleMiddleCommandItem : (relX > rightCommandStartX ? this.singleRightCommandItem : this.singleLeftCommandItem);
            if (selectedCommandItem != null) {
                if (!selectedCommandItem.isPressed) {
                    return false;
                }
                selectedCommandItem.notifyItemPressedEnd();
            }
            boolean isOpenKeySelected = relX < rightCommandStartX;
            boolean isCloseKeySelected = !isOpenKeySelected;
            boolean isSelectKeySelected = isOpenKeySelected;
            if (this.isOpened) {
                if (isSelectKeySelected) {
                    this.setOpen(false);
                    Command command = (Command)this.commandsList.get(this.commandsContainer.focusedIndex);
                    this.screen.callCommandListener(command);
                } else if (isCloseKeySelected) {
                    this.setOpen(false);
                }
            } else if (selectedCommandItem != null && selectedCommandItem.getAppearanceMode() != 0) {
                if (selectedCommandItem == this.singleLeftCommandItem && this.singleLeftCommand != null) {
                    this.screen.callCommandListener(this.singleLeftCommand);
                } else if (selectedCommandItem == this.singleRightCommandItem && this.singleRightCommand != null) {
                    this.screen.callCommandListener(this.singleRightCommand);
                } else if (selectedCommandItem == this.singleMiddleCommandItem && this.singleMiddleCommand != null) {
                    this.screen.callCommandListener(this.singleMiddleCommand);
                } else if (isOpenKeySelected && this.commandsList.size() > 0) {
                    this.setOpen(true);
                }
            }
            return true;
        }
        if (this.isOpened) {
            boolean handled = this.commandsContainer.handlePointerReleased(relX -= this.commandsContainer.relativeX, relY -= this.commandsContainer.relativeY);
            if (!handled) {
                this.setOpen(false);
            }
            return true;
        }
        return false;
    }

    protected boolean handlePointerDragged(int relX, int relY, ClippingRegion repaintRegion) {
        if (this.isOpened) {
            int y = relY - this.commandsContainer.relativeY;
            int x = relX = this.commandsContainer.relativeX;
            this.commandsContainer.handlePointerDragged(x, y, repaintRegion);
            return true;
        }
        if (relY < 0) {
            if (this.singleLeftCommandItem.isPressed) {
                this.singleLeftCommandItem.notifyItemPressedEnd();
                return true;
            }
            if (this.singleRightCommandItem.isPressed) {
                this.singleRightCommandItem.notifyItemPressedEnd();
                return true;
            }
            if (this.singleMiddleCommandItem.isPressed) {
                this.singleMiddleCommandItem.notifyItemPressedEnd();
                return true;
            }
        }
        return super.handlePointerDragged(relX, relY, repaintRegion);
    }

    public void setStyle(Style style) {
        if (this.overlayBackground == null) {
            this.overlayBackground = new TranslucentSimpleBackground(-2013265920);
        }
        super.setStyle(style);
    }

    public void resetStyle(boolean recursive) {
        super.resetStyle(recursive);
        if (recursive) {
            this.commandsContainer.resetStyle(recursive);
            this.singleLeftCommandItem.resetStyle(recursive);
            this.singleRightCommandItem.resetStyle(recursive);
            this.singleMiddleCommandItem.resetStyle(recursive);
        }
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        if (this.isOpened) {
            this.commandsContainer.animate(currentTime, repaintRegion);
        }
        if (this.singleLeftCommandItem != null) {
            this.singleLeftCommandItem.animate(currentTime, repaintRegion);
        }
        if (this.singleRightCommandItem != null) {
            this.singleRightCommandItem.animate(currentTime, repaintRegion);
        }
    }

    public void addSubCommand(Command childCommand, Command parentCommand) {
        if (this.menuItemStyle != null) {
            this.addSubCommand(childCommand, parentCommand, this.menuItemStyle);
        } else {
            this.addSubCommand(childCommand, parentCommand, StyleSheet.menuitemStyle);
        }
    }

    public void addSubCommand(Command childCommand, Command parentCommand, Style commandStyle) {
        CommandItem parentCommandItem = (CommandItem)this.allCommands.get(parentCommand);
        if (parentCommand == this.singleLeftCommand) {
            this.addCommand(parentCommandItem);
            this.singleLeftCommand = null;
        } else if (parentCommand == this.singleRightCommand) {
            this.addCommand(parentCommandItem);
            this.singleRightCommand = null;
            if (this.singleLeftCommand != null) {
                Command cmd = this.singleLeftCommand;
                this.singleLeftCommand = null;
                this.addCommand(cmd);
            }
        }
        if (parentCommandItem == null) {
            throw new IllegalStateException();
        }
        CommandItem child = new CommandItem(childCommand, parentCommandItem, commandStyle);
        this.allCommands.put(childCommand, child);
        parentCommandItem.addChild(child);
        if (this.isOpened) {
            this.setInitialized(false);
            this.repaint();
        }
    }

    public void removeSubCommand(Command childCommand, Command parentCommand) {
        CommandItem childCommandItem = (CommandItem)this.allCommands.get(childCommand);
        if (childCommandItem == null) {
            throw new IllegalStateException();
        }
        CommandItem parentCommandItem = (CommandItem)this.allCommands.get(parentCommand);
        if (parentCommandItem == null) {
            throw new IllegalStateException();
        }
        this.allCommands.remove(childCommand);
        parentCommandItem.removeChild(childCommand);
        if (this.isOpened) {
            this.setInitialized(false);
            this.repaint();
        }
    }

    private void addCommand(CommandItem item) {
        if (item == null) {
            Debug.debug("error", "de.enough.polish.ui.MenuBar", 2130, "MenuBar.addCommand(CommandItem): Unable to add null CommandItem");
            return;
        }
        Command cmd = item.command;
        int priority = cmd.getPriority();
        if (this.commandsList.size() == 0) {
            this.commandsList.add(cmd);
            this.commandsContainer.add(item);
        } else {
            Command[] myCommands = (Command[])this.commandsList.toArray(new Command[this.commandsList.size()]);
            boolean inserted = false;
            for (int i = 0; i < myCommands.length; ++i) {
                Command command = myCommands[i];
                if (cmd == command) {
                    return;
                }
                if (command.getPriority() <= priority) continue;
                this.commandsList.add(i, cmd);
                this.commandsContainer.add(i, item);
                inserted = true;
                break;
            }
            if (!inserted) {
                this.commandsList.add(cmd);
                this.commandsContainer.add(item);
            }
        }
    }

    public void removeAllCommands() {
        this.singleLeftCommand = null;
        this.singleRightCommand = null;
        this.singleMiddleCommand = null;
        this.commandsList.clear();
        this.allCommands.clear();
        this.commandsContainer.clear();
        this.singleLeftCommandItem.setText(null);
        this.singleLeftCommandItem.setImage((Image)null);
        this.singleRightCommandItem.setText(null);
        this.singleRightCommandItem.setImage((Image)null);
        this.singleMiddleCommandItem.setText(null);
        this.singleMiddleCommandItem.setImage((Image)null);
        this.setOpen(false);
        this.repaint();
    }

    public CommandItem getCommandItem(Command command) {
        if (command == this.singleLeftCommand) {
            return this.singleLeftCommandItem;
        }
        if (command == this.singleRightCommand) {
            return this.singleRightCommandItem;
        }
        if (command == this.singleMiddleCommand) {
            return this.singleMiddleCommandItem;
        }
        return (CommandItem)this.allCommands.get(command);
    }

    public Item getItemAt(int relX, int relY) {
        if (this.isOpened && relY < 0) {
            return this.commandsContainer.getItemAt(relX - this.commandsContainer.relativeX, relY - this.commandsContainer.relativeY);
        }
        if (relY >= 0) {
            Item item = this.singleLeftCommandItem.getItemAt(relX - this.singleLeftCommandItem.relativeX, relY - this.singleLeftCommandItem.relativeY);
            if (item != null) {
                return item;
            }
            item = this.singleRightCommandItem.getItemAt(relX - this.singleRightCommandItem.relativeX, relY - this.singleRightCommandItem.relativeY);
            if (item != null) {
                return item;
            }
        }
        return super.getItemAt(relX, relY);
    }

    public boolean isOrientationVertical() {
        return this.isOrientationVertical;
    }

    public void setOrientationVertical(boolean isVertical) {
    }

    public int getSpaceTop(int width, int height) {
        return 0;
    }

    public int getSpaceLeft(int width, int height) {
        return 0;
    }

    public int getSpaceRight(int width, int height) {
        return 0;
    }

    public int getSpaceBottom(int width, int height) {
        return this.getItemHeight(width, width, height);
    }

    public int size() {
        return this.allCommands.size();
    }

    public Command getCommand(int index) {
        return (Command)this.allCommands.keys()[index];
    }

    public Style getMenuItemStyle() {
        return this.menuItemStyle;
    }

    public void setMenuItemStyle(Style menuItemStyle) {
        this.menuItemStyle = menuItemStyle;
        Object[] commandItems = this.allCommands.values();
        for (int i = 0; i < commandItems.length; ++i) {
            CommandItem item = (CommandItem)commandItems[i];
            item.setStyle(menuItemStyle);
        }
        this.repaint();
    }

    public Container getCommandsContainer() {
        return this.commandsContainer;
    }

    public boolean contains(Command command) {
        return this.allCommands != null && this.allCommands.get(command) != null;
    }

    public void addCommandsLayer(Command[] layerCommands) {
        if (this.allCommands != null) {
            this.commandsBeforeLayer = new ArrayList();
            this.commandsBeforeLayer.addAll(this.allCommands.keys());
        }
        this.removeAllCommands();
        for (int i = 0; i < layerCommands.length; ++i) {
            Command command = layerCommands[i];
            this.addCommand(command);
        }
    }

    public void removeCommandsLayer() {
        this.removeAllCommands();
        if (this.commandsBeforeLayer != null) {
            Command command;
            Object[] originalCommands = this.commandsBeforeLayer.getInternalArray();
            for (int i = 0; i < originalCommands.length && (command = (Command)originalCommands[i]) != null; ++i) {
                this.addCommand(command);
            }
        }
    }

    public void informDefaultCommand(Command cmd) {
        if (cmd != this.singleMiddleCommand) {
            this.removeCommand(cmd);
            if (this.singleMiddleCommand != null) {
                this.addCommand(tmpMiddleCommand);
            }
            this.singleMiddleCommand = cmd;
            this.singleMiddleCommandItem.setText(cmd.getLabel());
        }
    }

    public void fireEvent(String eventName, Object eventData) {
        super.fireEvent(eventName, eventData);
        this.singleLeftCommandItem.fireEvent(eventName, eventData);
        this.singleRightCommandItem.fireEvent(eventName, eventData);
        this.singleMiddleCommandItem.fireEvent(eventName, eventData);
        this.commandsContainer.fireEvent(eventName, eventData);
    }

    public void focusChild(Item item) {
        if (this.isOpened) {
            int index = this.commandsContainer.indexOf(item);
            if (index != -1) {
                this.commandsContainer.focusChild(index);
            } else {
                CommandItem focItem = (CommandItem)this.commandsContainer.focusedItem;
                if (focItem != null) {
                    focItem.focusChild(item);
                }
            }
        }
    }

    protected void hideNotify() {
        super.hideNotify();
        if (this.isOpened) {
            this.setOpen(false);
        }
        if (this.singleLeftCommandItem != null) {
            this.singleLeftCommandItem.hideNotify();
        }
        if (this.singleRightCommandItem != null) {
            this.singleRightCommandItem.hideNotify();
        }
        if (this.singleMiddleCommandItem != null) {
            this.singleMiddleCommandItem.hideNotify();
        }
    }

    protected void showNotify() {
        super.showNotify();
        if (this.singleLeftCommandItem != null) {
            this.singleLeftCommandItem.showNotify();
        }
        if (this.singleRightCommandItem != null) {
            this.singleRightCommandItem.showNotify();
        }
        if (this.singleMiddleCommandItem != null) {
            this.singleMiddleCommandItem.showNotify();
        }
    }

    public Object[] getCommands() {
        return this.allCommands.keys();
    }
}

