/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Choice;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.FilteredList;
import de.enough.polish.ui.List;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class FilteredChoiceGroup
extends StringItem
implements Choice,
CommandListener {
    public static final int EXCLUSIVE = 1;
    public static final int MULTIPLE = 2;
    public static final int IMPLICIT = 3;
    private final FilteredList filteredList;
    private boolean[] lastChoices;
    private String lastFilterText;
    private String nullText;
    private String delimiter = ", ";

    public FilteredChoiceGroup(String label, String nullText, int listType) {
        this(label, nullText, listType, null);
    }

    public FilteredChoiceGroup(String label, String nullText, int listType, Style style) {
        super(label, nullText, 3, style);
        this.filteredList = new FilteredList(label, listType);
        if (listType == 3) {
            this.filteredList.setSelectCommand(StyleSheet.OK_CMD);
        } else {
            this.filteredList.addCommand(StyleSheet.OK_CMD);
        }
        this.filteredList.addCommand(StyleSheet.CANCEL_CMD);
        this.filteredList.setCommandListener(this);
        this.nullText = nullText;
    }

    public void setFilterText(String text) {
        this.filteredList.setFilterText(text);
    }

    public String getFilterText() {
        return this.filteredList.getFilterText();
    }

    public int append(String stringPart, Image imagePart) {
        return this.filteredList.append(stringPart, imagePart);
    }

    public int append(String stringPart, Image imagePart, Style itemStyle) {
        return this.filteredList.append(stringPart, imagePart, itemStyle);
    }

    public int append(ChoiceItem item) {
        return this.filteredList.append(item);
    }

    public void delete(int elementNum) {
        this.filteredList.delete(elementNum);
    }

    public void deleteAll() {
        this.filteredList.deleteAll();
    }

    public int getFitPolicy() {
        return this.filteredList.getFitPolicy();
    }

    public Font getFont(int elementNum) {
        return this.filteredList.getFont(elementNum);
    }

    public Image getImage(int elementNum) {
        return this.filteredList.getImage(elementNum);
    }

    public int getSelectedFlags(boolean[] selectedArray_return) {
        return this.filteredList.getSelectedFlags(selectedArray_return);
    }

    public int getSelectedIndex() {
        return this.filteredList.getSelectedIndex();
    }

    public String getString(int elementNum) {
        return this.filteredList.getString(elementNum);
    }

    public void insert(int elementNum, String stringPart, Image imagePart) {
        this.filteredList.insert(elementNum, stringPart, imagePart);
    }

    public void insert(int elementNum, String stringPart, Image imagePart, Style elementStyle) {
        this.filteredList.insert(elementNum, stringPart, imagePart, elementStyle);
    }

    public boolean isSelected(int elementNum) {
        return this.filteredList.isSelected(elementNum);
    }

    public void set(int elementNum, String stringPart, Image imagePart) {
        this.filteredList.set(elementNum, stringPart, imagePart);
    }

    public void set(int elementNum, String stringPart, Image imagePart, Style elementStyle) {
        this.filteredList.set(elementNum, stringPart, imagePart, elementStyle);
    }

    public void setFitPolicy(int fitPolicy) {
        this.filteredList.setFitPolicy(fitPolicy);
    }

    public void setFont(int elementNum, Font font) {
        this.filteredList.setFont(elementNum, font);
    }

    public void setSelectedFlags(boolean[] selectedArray) {
        this.filteredList.setSelectedFlags(selectedArray);
        this.lastChoices = selectedArray;
        this.updateText();
    }

    public void setSelectedIndex(int elementNum, boolean selected) {
        this.filteredList.setSelectedIndex(elementNum, selected);
        this.updateText();
    }

    public int size() {
        return this.filteredList.size();
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        if (this.getScreen().isGameActionFire(keyCode, gameAction) && StyleSheet.display != null) {
            this.showFilteredList(StyleSheet.display);
            return true;
        }
        return super.handleKeyReleased(keyCode, gameAction);
    }

    public void commandAction(Command cmd, Displayable disp) {
        try {
            if (disp == this.filteredList) {
                if (cmd == StyleSheet.OK_CMD || cmd == List.SELECT_COMMAND) {
                    if (this.filteredList.containsChangesTo(this.lastChoices)) {
                        if (this.filteredList.listType != 2) {
                            this.filteredList.setSelectedIndex(this.getSelectedIndex(), true);
                        }
                        this.updateText();
                        this.notifyStateChanged();
                    }
                } else if (cmd == StyleSheet.CANCEL_CMD) {
                    this.filteredList.setFilterText(this.lastFilterText);
                    this.filteredList.setSelectedFlags(this.lastChoices);
                }
                this.lastChoices = null;
                this.lastFilterText = null;
                Screen scr = this.getScreen();
                if (scr != null) {
                    StyleSheet.display.setCurrent(scr);
                }
            }
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.FilteredChoiceGroup", 330, (Object)("Unable to handle command " + cmd.getLabel()), e);
        }
    }

    private void updateText() {
        if (this.filteredList.listType == 2) {
            String selectionText = this.filteredList.toSelectionString(this.delimiter);
            if (selectionText == null) {
                this.setText(this.nullText);
            } else {
                this.setText(selectionText);
            }
        } else {
            int index = this.filteredList.getSelectedIndex();
            if (index == -1) {
                this.setText(this.nullText);
            } else {
                this.setText(this.filteredList.getString(index));
            }
        }
    }

    public void resetFilter() {
        this.filteredList.setFilterText(null);
    }

    public void showFilteredList(Display display) {
        int selectedIdx;
        if (this.filteredList.listType == 3 && (selectedIdx = this.filteredList.getSelectedIndex()) != -1) {
            ChoiceItem selectedItem = this.filteredList.getItem(selectedIdx);
            this.filteredList.focus(selectedItem);
        }
        this.filteredList.setTitle(this.getLabel());
        this.lastChoices = new boolean[this.filteredList.size()];
        this.filteredList.getSelectedFlags(this.lastChoices);
        this.lastFilterText = this.filteredList.getFilterText();
        display.setCurrent(this.filteredList);
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

