/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.midp.ui.NativeDisplayImpl;
import de.enough.polish.ui.Alert;
import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.Canvas;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.NativeDisplay;
import de.enough.polish.ui.Point;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class Display
extends javax.microedition.lcdui.Canvas
implements javax.microedition.lcdui.CommandListener {
    public static final int LIST_ELEMENT = 1;
    public static final int CHOICE_GROUP_ELEMENT = 2;
    public static final int ALERT = 3;
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_FOREGROUND = 1;
    public static final int COLOR_HIGHLIGHTED_BACKGROUND = 2;
    public static final int COLOR_HIGHLIGHTED_FOREGROUND = 3;
    public static final int COLOR_BORDER = 4;
    public static final int COLOR_HIGHLIGHTED_BORDER = 5;
    public static final int INPUT_METHOD_TOUCH = 0;
    public static final int INPUT_METHOD_KEY = 1;
    private static Display instance;
    protected Displayable currentDisplayable;
    protected Canvas currentCanvas;
    protected MIDlet midlet;
    private NativeDisplay nativeDisplay;
    private int screenWidth;
    private int screenHeight;
    protected boolean enableScreenChangeAnimations = true;
    private CommandListener commandListener;
    protected int nonFullScreenHeight;
    private int inputMethod = 0;
    private boolean emitNotifyOnUserEvent;
    protected boolean isLastEventProcessed;
    private Displayable nextOrCurrentDisplayable;
    private boolean hasBeenShown;

    protected Display(MIDlet midlet, NativeDisplay nativeDisplay) {
        this.midlet = midlet;
        this.nativeDisplay = nativeDisplay;
        this.nonFullScreenHeight = super.getHeight();
        super.setFullScreenMode(true);
    }

    public static Display getDisplay(MIDlet m) {
        if (instance == null) {
            NativeDisplayImpl nativeDisplay = NativeDisplayImpl.getDisplay(m);
            instance = new Display(m, nativeDisplay);
            StyleSheet.midlet = m;
            StyleSheet.display = instance;
        }
        return instance;
    }

    public int getColor(int colorSpecifier) {
        return this.nativeDisplay.getColor(colorSpecifier);
    }

    public int getBorderStyle(boolean highlighted) {
        return this.nativeDisplay.getBorderStyle(highlighted);
    }

    public boolean isColor() {
        return this.nativeDisplay.isColor();
    }

    public int numColors() {
        return this.nativeDisplay.numColors();
    }

    public int numAlphaLevels() {
        return this.nativeDisplay.numAlphaLevels();
    }

    public Displayable getCurrent() {
        return this.currentDisplayable;
    }

    public Displayable getNextOrCurrent() {
        if (this.nextOrCurrentDisplayable != null) {
            return this.nextOrCurrentDisplayable;
        }
        return this.currentDisplayable;
    }

    public void setCurrent(Displayable nextDisplayable) {
        Style screenTransitionStyle = null;
        boolean isTransitionForward = true;
        this.setCurrent(nextDisplayable, isTransitionForward, screenTransitionStyle);
    }

    public void setCurrent(Displayable nextDisplayable, Style screenTransitionStyle) {
        this.setCurrent(nextDisplayable, true, screenTransitionStyle);
    }

    public void setCurrent(Displayable nextDisplayable, boolean isTransitionForward, Style screenTransitionStyle) {
        this.nextOrCurrentDisplayable = nextDisplayable;
        if (nextDisplayable == this.currentDisplayable) {
            this.repaint();
            this.nextOrCurrentDisplayable = null;
            return;
        }
        if (nextDisplayable == null || !(nextDisplayable instanceof Canvas)) {
            if (nextDisplayable != null) {
                if (this.currentCanvas != null) {
                    this.currentCanvas._hideNotify();
                    this.currentCanvas = null;
                }
                this.currentDisplayable = nextDisplayable;
            }
            this.nativeDisplay.setCurrent(nextDisplayable);
            this.nextOrCurrentDisplayable = null;
            return;
        }
        if (nextDisplayable instanceof Alert && this.currentDisplayable != nextDisplayable) {
            Alert alert = (Alert)nextDisplayable;
            if (alert.nextDisplayable == null) {
                Displayable nxt;
                alert.nextDisplayable = nxt = Display.instance.currentDisplayable;
            }
        }
        Canvas canvas = (Canvas)nextDisplayable;
        if (this.isShown()) {
            if (this.commandListener != null) {
                this.commandListener = null;
            }
            if (canvas != null) {
                canvas._showNotify();
            }
            if (this.screenWidth != 0) {
                nextDisplayable.sizeChanged(this.screenWidth, this.screenHeight);
            }
        }
        Canvas oldCanvas = this.currentCanvas;
        this.currentCanvas = canvas;
        this.currentDisplayable = nextDisplayable;
        if (oldCanvas != null) {
            oldCanvas._hideNotify();
        }
        if (StyleSheet.currentScreen != nextDisplayable && !(nextDisplayable instanceof Screen)) {
            StyleSheet.currentScreen = null;
        }
        if (!this.isShown()) {
            this.nativeDisplay.setCurrent(this);
        } else {
            this.repaint();
        }
        this.nextOrCurrentDisplayable = null;
    }

    public void setCurrent(Alert alert, Displayable nextDisplayable) {
        if (nextDisplayable != null) {
            alert.nextDisplayable = nextDisplayable;
        }
        this.setCurrent(alert);
    }

    public void setCurrentItem(Item item) {
        this.setCurrentItem(item, null);
    }

    public void setCurrentItem(Item item, Style screenTransitionStyle) {
        item.show(this, screenTransitionStyle);
    }

    public void callSerially(Runnable r) {
        this.nativeDisplay.callSerially(r);
    }

    public boolean flashBacklight(int duration) {
        return this.nativeDisplay.flashBacklight(duration);
    }

    public boolean vibrate(int duration) {
        return this.nativeDisplay.vibrate(duration);
    }

    public int getBestImageWidth(int imageType) {
        return this.nativeDisplay.getBestImageWidth(imageType);
    }

    public int getBestImageHeight(int imageType) {
        return this.nativeDisplay.getBestImageHeight(imageType);
    }

    public boolean isGameActionFire(int keyCode, int gameAction) {
        return gameAction == 8 && keyCode != 53;
    }

    public final boolean isSoftKeyLeft(int keyCode, int gameAction) {
        if (gameAction == 2 || gameAction == 5 || gameAction == 1 || gameAction == 6) {
            return false;
        }
        int expected = -6;
        boolean result = keyCode == expected;
        return result;
    }

    public final boolean isSoftKeyRight(int keyCode, int gameAction) {
        if (gameAction == 2 || gameAction == 5 || gameAction == 1 || gameAction == 6) {
            return false;
        }
        int expected = -7;
        boolean result = keyCode == expected;
        return result;
    }

    public final boolean isSoftKeyMiddle(int keyCode, int gameAction) {
        if (gameAction == 2 || gameAction == 5 || gameAction == 1 || gameAction == 6) {
            return false;
        }
        boolean expected = false;
        return false;
    }

    public boolean isSoftKey(int keyCode) {
        int gameAction = 0;
        try {
            gameAction = this.getGameAction(keyCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.isSoftKey(keyCode, gameAction);
    }

    public boolean isSoftKey(int keyCode, int gameAction) {
        return this.isSoftKeyLeft(keyCode, gameAction) || this.isSoftKeyRight(keyCode, gameAction) || this.isSoftKeyMiddle(keyCode, gameAction);
    }

    protected void paint(Graphics g) {
        if (this.currentCanvas != null) {
            this.currentCanvas.paint(g);
        }
    }

    private int getSpriteTransform(int degrees) {
        switch (degrees) {
            case 0: {
                return 0;
            }
            case 90: {
                return 5;
            }
            case 180: {
                return 3;
            }
            case 270: {
                return 6;
            }
        }
        return 0;
    }

    public NativeDisplay getNativeDisplay() {
        return this.nativeDisplay;
    }

    public static Display getInstance() {
        return instance;
    }

    public static void _setFullScreenMode(boolean mode) {
        if (instance != null) {
            instance.setFullScreenMode(mode);
        }
    }

    public static boolean _isShown() {
        if (instance != null) {
            return instance.isShown();
        }
        return false;
    }

    public void setCommandListener(CommandListener listener) {
        this.commandListener = listener;
        super.setCommandListener(this);
    }

    protected void hideNotify() {
        if (this.currentCanvas != null) {
            this.currentCanvas._hideNotifyExternal();
        }
    }

    protected void showNotify() {
        this.hasBeenShown = true;
        StyleSheet.showNotify();
        if (this.nonFullScreenHeight == 0) {
            this.nonFullScreenHeight = this.getHeight();
        }
        this.setFullScreenMode(true);
        boolean startAnimationThread = false;
        if (StyleSheet.animationThread == null) {
            StyleSheet.animationThread = new AnimationThread();
            startAnimationThread = true;
        }
        Display.getScreenWidth();
        int h = Display.getScreenHeight();
        if (this.currentCanvas != null) {
            this.currentCanvas._showNotify();
            if (this.screenWidth != 0) {
                this.currentCanvas.sizeChanged(this.screenWidth, this.screenHeight);
            }
        }
        if (startAnimationThread) {
            StyleSheet.animationThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int keyCode) {
        this.setInputMethod(1);
        if (this.emitNotifyOnUserEvent) {
            this.emitNotifyOnUserEvent = false;
            Display display = this;
            synchronized (display) {
                this.notifyAll();
            }
        }
        if (this.currentCanvas != null) {
            this.isLastEventProcessed = this.currentCanvas._keyPressed(keyCode);
        }
    }

    protected void keyRepeated(int keyCode) {
        if (this.currentCanvas != null) {
            this.isLastEventProcessed = this.currentCanvas._keyRepeated(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.currentCanvas != null) {
            this.isLastEventProcessed = this.currentCanvas._keyReleased(keyCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pointerPressed(int x, int y) {
        this.setInputMethod(0);
        if (this.emitNotifyOnUserEvent) {
            this.emitNotifyOnUserEvent = false;
            Display display = this;
            synchronized (display) {
                this.notifyAll();
            }
        }
        if (this.currentCanvas != null) {
            this.isLastEventProcessed = this.currentCanvas._pointerPressed(x, y);
        }
    }

    protected void pointerReleased(int x, int y) {
        if (this.currentCanvas != null) {
            this.isLastEventProcessed = this.currentCanvas._pointerReleased(x, y);
        }
    }

    protected void pointerDragged(int x, int y) {
        if (this.currentCanvas != null) {
            this.isLastEventProcessed = this.currentCanvas._pointerDragged(x, y);
        }
    }

    private Point translatePoint(int x, int y) {
        return null;
    }

    public void sizeChanged(int width, int height) {
        this.sizeChanged(width, height, false);
    }

    public void sizeChanged(int width, int height, boolean isRotated) {
        this.screenWidth = width;
        this.screenHeight = height;
        if (this.currentCanvas != null && this.hasBeenShown) {
            this.currentCanvas.sizeChanged(width, height);
        }
        this.repaint();
    }

    protected boolean isNativeUiShownFor(Item item) {
        return false;
    }

    public static int getScreenHeight() {
        int h = 0;
        if (instance != null) {
            h = Display.instance.screenHeight;
            if (h == 0) {
                Display.instance.screenHeight = h = instance.getHeight();
            }
        } else {
            h = new javax.microedition.lcdui.Canvas(){

                protected void paint(Graphics g) {
                }
            }.getHeight();
        }
        return h;
    }

    public static int getScreenWidth() {
        int w = 0;
        if (instance != null) {
            w = Display.instance.screenWidth;
            if (w == 0) {
                Display.instance.screenWidth = w = instance.getWidth();
            }
        } else {
            w = new javax.microedition.lcdui.Canvas(){

                protected void paint(Graphics g) {
                }
            }.getWidth();
        }
        return w;
    }

    public static void setScreenOrientation(int degrees) {
    }

    private void setScreenOrientationImpl(int degrees) {
    }

    public void requestRepaint(int x, int y, int width, int height) {
        this.repaint(x, y, width, height);
    }

    public void requestRepaint() {
        this.repaint();
    }

    public MIDlet getMidlet() {
        return this.midlet;
    }

    public void commandAction(javax.microedition.lcdui.Command c, javax.microedition.lcdui.Displayable d) {
        if (c instanceof Command) {
            if (this.commandListener != null) {
                this.commandListener.commandAction((Command)c, this.currentDisplayable);
            } else if (this.currentCanvas instanceof Screen) {
                ((Screen)this.currentCanvas).handleCommand((Command)c);
            }
        }
    }

    public void toggleScreen() {
    }

    public void setMidlet(MIDlet midlet) {
        this.midlet = midlet;
    }

    protected void emitNotifyOnUserEvents(boolean emitNotify) {
        this.emitNotifyOnUserEvent = emitNotify;
    }

    public int getInputMethod() {
        return this.inputMethod;
    }

    public boolean isInputMethod(int method) {
        return this.inputMethod == method;
    }

    private void setInputMethod(int inputMethod) {
        this.inputMethod = inputMethod;
    }
}

